/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.publishevent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.utils.DataBridgeCommonsUtils;
import org.wso2.carbon.event.sink.EventSink;
import org.wso2.carbon.event.sink.EventSinkService;
import org.wso2.carbon.mediator.publishevent.ActivityIDSetter;
import org.wso2.carbon.mediator.publishevent.Property;
import org.wso2.carbon.mediator.publishevent.PublishEventMediatorFactory;

public class PublishEventMediator
extends AbstractMediator {
    private static final String TASK_EXECUTING_TENANT_ID = "CURRENT_TASK_EXECUTING_TENANT_IDENTIFIER";
    private EventSinkService eventSinkService = null;
    private String streamName;
    private String streamVersion;
    private List<Property> metaProperties = new ArrayList<Property>();
    private List<Property> correlationProperties = new ArrayList<Property>();
    private List<Property> payloadProperties = new ArrayList<Property>();
    private List<Property> arbitraryProperties = new ArrayList<Property>();
    private EventSink eventSink;
    private String eventSinkName;
    private boolean isAsync = true;
    private long asyncTimeout;

    public boolean isContentAware() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mediate(MessageContext messageContext) {
        SynapseLog synLog;
        String errorMsg;
        Object tenantDomainObj;
        if (messageContext.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(messageContext)) {
            return true;
        }
        Integer tenantId = null;
        if (messageContext.getProperty(TASK_EXECUTING_TENANT_ID) != null && messageContext.getProperty(TASK_EXECUTING_TENANT_ID) instanceof Integer) {
            tenantId = (Integer)messageContext.getProperty(TASK_EXECUTING_TENANT_ID);
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId.intValue());
        }
        if (PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId() == -1) {
            PrivilegedCarbonContext.startTenantFlow();
            tenantDomainObj = ((Axis2MessageContext)messageContext).getAxis2MessageContext().getProperty("tenantDomain");
            String tenantDomain = tenantDomainObj != null ? (String)tenantDomainObj : "carbon.super";
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
            tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        }
        if (this.getEventSink() == null) {
            tenantDomainObj = this;
            synchronized (tenantDomainObj) {
                if (this.getEventSink() == null) {
                    try {
                        this.setEventSink(this.loadEventSink());
                    }
                    catch (SynapseException e) {
                        errorMsg = "Cannot mediate message. Failed to load event sink '" + this.getEventSinkName() + "'. Error: " + e.getLocalizedMessage();
                        this.handleException(errorMsg, (Exception)((Object)e), messageContext);
                    }
                }
            }
        }
        if (tenantId != null) {
            PrivilegedCarbonContext.endTenantFlow();
        }
        if ((synLog = this.getLog(messageContext)).isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)("Start : " + PublishEventMediatorFactory.getTagName() + " mediator"));
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace((Object)("Message : " + messageContext.getEnvelope()));
            }
        }
        ActivityIDSetter.setActivityIdInTransportHeader(messageContext);
        try {
            Object[] metaData = new Object[this.metaProperties.size()];
            for (int i = 0; i < this.metaProperties.size(); ++i) {
                metaData[i] = this.metaProperties.get(i).extractPropertyValue(messageContext);
            }
            Object[] correlationData = new Object[this.correlationProperties.size()];
            for (int i = 0; i < this.correlationProperties.size(); ++i) {
                correlationData[i] = this.correlationProperties.get(i).extractPropertyValue(messageContext);
            }
            Object[] payloadData = new Object[this.payloadProperties.size()];
            for (int i = 0; i < this.payloadProperties.size(); ++i) {
                payloadData[i] = this.payloadProperties.get(i).extractPropertyValue(messageContext);
            }
            HashMap<String, String> arbitraryData = new HashMap<String, String>();
            for (int i = 0; i < this.arbitraryProperties.size(); ++i) {
                Property arbitraryProperty = this.arbitraryProperties.get(i);
                arbitraryData.put(arbitraryProperty.getKey(), arbitraryProperty.extractPropertyValue(messageContext).toString());
            }
            if (this.isAsync) {
                if (this.asyncTimeout != 0L) {
                    this.eventSink.getDataPublisher().tryPublish(DataBridgeCommonsUtils.generateStreamId((String)this.getStreamName(), (String)this.getStreamVersion()), metaData, correlationData, payloadData, arbitraryData, this.asyncTimeout);
                } else {
                    this.eventSink.getDataPublisher().tryPublish(DataBridgeCommonsUtils.generateStreamId((String)this.getStreamName(), (String)this.getStreamVersion()), metaData, correlationData, payloadData, arbitraryData);
                }
            } else {
                this.eventSink.getDataPublisher().publish(DataBridgeCommonsUtils.generateStreamId((String)this.getStreamName(), (String)this.getStreamVersion()), metaData, correlationData, payloadData, arbitraryData);
            }
        }
        catch (SynapseException e) {
            errorMsg = "Error occurred while constructing the event: " + e.getLocalizedMessage();
            this.handleException(errorMsg, (Exception)((Object)e), messageContext);
        }
        catch (Exception e) {
            errorMsg = "Error occurred while sending the event: " + e.getLocalizedMessage();
            this.handleException(errorMsg, e, messageContext);
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)("End : " + PublishEventMediatorFactory.getTagName() + " mediator"));
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace((Object)("Message : " + messageContext.getEnvelope()));
            }
        }
        return true;
    }

    private EventSink loadEventSink() throws SynapseException {
        EventSink eventSink;
        if (this.eventSinkService == null) {
            Object serviceObject = PrivilegedCarbonContext.getThreadLocalCarbonContext().getOSGiService(EventSinkService.class);
            if (serviceObject instanceof EventSinkService) {
                this.eventSinkService = (EventSinkService)serviceObject;
            } else {
                throw new SynapseException("Internal error occurred. Failed to obtain EventSinkService");
            }
        }
        if ((eventSink = this.eventSinkService.getEventSink(this.getEventSinkName())) == null) {
            throw new SynapseException("Event sink \"" + this.getEventSinkName() + "\" not found");
        }
        try {
            StreamDefinition streamDef = new StreamDefinition(this.getStreamName(), this.getStreamVersion());
            streamDef.setCorrelationData(this.generateAttributeList(this.getCorrelationProperties()));
            streamDef.setMetaData(this.generateAttributeList(this.getMetaProperties()));
            streamDef.setPayloadData(this.generateAttributeList(this.getPayloadProperties()));
        }
        catch (MalformedStreamDefinitionException e) {
            String errorMsg = "Failed to set stream definition. Malformed Stream Definition: " + e.getMessage();
            throw new SynapseException(errorMsg, (Throwable)e);
        }
        catch (Exception e) {
            String errorMsg = "Error occurred while creating the Stream Definition: " + e.getMessage();
            throw new SynapseException(errorMsg, (Throwable)e);
        }
        return eventSink;
    }

    private List<Attribute> generateAttributeList(List<Property> propertyList) throws SynapseException {
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        for (Property property : propertyList) {
            attributeList.add(new Attribute(property.getKey(), property.getDatabridgeAttributeType()));
        }
        return attributeList;
    }

    public EventSink getEventSink() {
        return this.eventSink;
    }

    public String getEventSinkName() {
        return this.eventSinkName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getStreamVersion() {
        return this.streamVersion;
    }

    public List<Property> getMetaProperties() {
        return this.metaProperties;
    }

    public List<Property> getCorrelationProperties() {
        return this.correlationProperties;
    }

    public List<Property> getPayloadProperties() {
        return this.payloadProperties;
    }

    public List<Property> getArbitraryProperties() {
        return this.arbitraryProperties;
    }

    public void setEventSink(EventSink eventSink) {
        this.eventSink = eventSink;
    }

    public void setEventSinkName(String eventSinkName) {
        this.eventSinkName = eventSinkName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public void setStreamVersion(String streamVersion) {
        this.streamVersion = streamVersion;
    }

    public void setMetaProperties(List<Property> metaProperties) {
        this.metaProperties = metaProperties;
    }

    public void setCorrelationProperties(List<Property> correlationProperties) {
        this.correlationProperties = correlationProperties;
    }

    public void setPayloadProperties(List<Property> payloadProperties) {
        this.payloadProperties = payloadProperties;
    }

    public void setArbitraryProperties(List<Property> arbitraryProperties) {
        this.arbitraryProperties = arbitraryProperties;
    }

    public void setAsync(boolean async) {
        this.isAsync = async;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public long getAsyncTimeout() {
        return this.asyncTimeout;
    }

    public void setAsyncTimeout(long asyncTimeout) {
        this.asyncTimeout = asyncTimeout;
    }
}

