/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.publishevent;

import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.mediator.publishevent.PropertyTypeConverter;
import org.wso2.carbon.mediator.publishevent.PublishEventMediatorFactory;

public class Property {
    private String key = "";
    private String value = null;
    private SynapseXPath expression = null;
    private String defaultValue = "";
    private String type = "";
    public static final String DATA_TYPE_STRING = "STRING";
    public static final String DATA_TYPE_INTEGER = "INTEGER";
    public static final String DATA_TYPE_FLOAT = "FLOAT";
    public static final String DATA_TYPE_DOUBLE = "DOUBLE";
    public static final String DATA_TYPE_BOOLEAN = "BOOLEAN";
    public static final String DATA_TYPE_LONG = "LONG";

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public SynapseXPath getExpression() {
        return this.expression;
    }

    public void setExpression(SynapseXPath expression) {
        this.expression = expression;
    }

    public String getType() {
        return this.type;
    }

    public AttributeType getDatabridgeAttributeType() throws SynapseException {
        if (DATA_TYPE_STRING.equals(this.type)) {
            return AttributeType.STRING;
        }
        if (DATA_TYPE_INTEGER.equals(this.type)) {
            return AttributeType.INT;
        }
        if (DATA_TYPE_FLOAT.equals(this.type)) {
            return AttributeType.FLOAT;
        }
        if (DATA_TYPE_DOUBLE.equals(this.type)) {
            return AttributeType.DOUBLE;
        }
        if (DATA_TYPE_BOOLEAN.equals(this.type)) {
            return AttributeType.BOOL;
        }
        if (DATA_TYPE_LONG.equals(this.type)) {
            return AttributeType.LONG;
        }
        throw new SynapseException("Invalid attribute type '" + this.type + "' for " + PublishEventMediatorFactory.getTagName() + " mediator attribute");
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object extractPropertyValue(MessageContext messageContext) throws SynapseException {
        String stringProperty = this.expression != null ? this.expression.stringValueOf(messageContext) : this.getValue();
        if (stringProperty == null || "".equals(stringProperty)) {
            stringProperty = this.defaultValue;
        }
        if (DATA_TYPE_STRING.equals(this.getType())) {
            return stringProperty;
        }
        if (DATA_TYPE_INTEGER.equals(this.getType())) {
            return PropertyTypeConverter.convertToInt(stringProperty);
        }
        if (DATA_TYPE_FLOAT.equals(this.getType())) {
            return Float.valueOf(PropertyTypeConverter.convertToFloat(stringProperty));
        }
        if (DATA_TYPE_DOUBLE.equals(this.getType())) {
            return PropertyTypeConverter.convertToDouble(stringProperty);
        }
        if (DATA_TYPE_BOOLEAN.equals(this.getType())) {
            return PropertyTypeConverter.convertToBoolean(stringProperty);
        }
        if (DATA_TYPE_LONG.equals(this.getType())) {
            return PropertyTypeConverter.convertToLong(stringProperty);
        }
        return stringProperty;
    }
}

