/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.publishevent;

import java.util.TreeMap;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.axis2.Axis2MessageContext;

public class ActivityIDSetter {
    private static final String MSG_CONTEXT_ACTIVITY_ID = "activity_id";
    private static final String ACTIVITY_ID = "activityID";
    private static final Log log = LogFactory.getLog(ActivityIDSetter.class);

    public static void setActivityIdInTransportHeader(org.apache.synapse.MessageContext messageContext) throws SynapseException {
        try {
            String idString = ActivityIDSetter.getUniqueId();
            Object idFromContext = messageContext.getProperty(MSG_CONTEXT_ACTIVITY_ID);
            Axis2MessageContext axis2smc = (Axis2MessageContext)messageContext;
            MessageContext axis2MessageContext = axis2smc.getAxis2MessageContext();
            TreeMap<String, String> headers = (TreeMap<String, String>)axis2MessageContext.getProperty("TRANSPORT_HEADERS");
            if (headers != null) {
                String idFromHeader = (String)headers.get(ACTIVITY_ID);
                if (idFromHeader == null || idFromHeader.equals("")) {
                    if (idFromContext != null) {
                        String inID = String.valueOf(idFromContext);
                        if (!inID.equals("")) {
                            idString = inID;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Incoming message had no activity ID, using the ID '" + inID + "' from the Synapse context instead."));
                            }
                        }
                    } else {
                        messageContext.setProperty(MSG_CONTEXT_ACTIVITY_ID, (Object)idString);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"no activity ID present anywhere, but transport headers exist.");
                        }
                    }
                    headers.put(ACTIVITY_ID, idString);
                } else {
                    idString = idFromHeader;
                    messageContext.setProperty(MSG_CONTEXT_ACTIVITY_ID, (Object)idString);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Propagating activity ID found in transport header: " + idFromHeader));
                    }
                }
            } else {
                if (idFromContext != null) {
                    String inID = String.valueOf(idFromContext);
                    if (!inID.equals("")) {
                        idString = inID;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Using activity ID '" + inID + "' from synapse context, transport headers do not exist"));
                        }
                    }
                } else if (log.isDebugEnabled()) {
                    log.info((Object)"Activity ID not found anywhere, creating new.");
                }
                headers = new TreeMap<String, String>();
                headers.put(ACTIVITY_ID, idString);
                axis2MessageContext.setProperty("TRANSPORT_HEADERS", headers);
                messageContext.setProperty(MSG_CONTEXT_ACTIVITY_ID, (Object)idString);
            }
        }
        catch (Exception e) {
            String errorMsg = "Error while setting Activity ID in Header ";
            log.error((Object)errorMsg, (Throwable)e);
            throw new SynapseException(errorMsg, (Throwable)e);
        }
    }

    private static String getUniqueId() {
        return String.valueOf(System.nanoTime()) + Math.round(Math.random() * 1.23456789E8);
    }
}

