/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediators.router.impl.config.xml;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.config.xml.TargetSerializer;
import org.apache.synapse.mediators.eip.Target;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.wso2.carbon.mediators.router.impl.Route;
import org.wso2.carbon.mediators.router.impl.RouterMediator;

public class RouterMediatorSerializer
extends AbstractMediatorSerializer {
    public OMElement serializeSpecificMediator(Mediator mediator) {
        if (!(mediator instanceof RouterMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + mediator.getType());
        }
        RouterMediator m = (RouterMediator)mediator;
        OMElement routerElem = fac.createOMElement("router", synNS);
        RouterMediatorSerializer.saveTracingState((OMElement)routerElem, (Mediator)m);
        if (m.isContinueAfter()) {
            routerElem.addAttribute(fac.createOMAttribute("continueAfter", nullNS, "true"));
        }
        for (Route route : m.getRoutes()) {
            OMElement routeElem = fac.createOMElement("route", synNS);
            if (route.getExpression() != null) {
                SynapseXPathSerializer.serializeXPath((SynapseXPath)route.getExpression(), (OMElement)routeElem, (String)"expression");
            } else {
                this.handleException("Incomplete route has been found in the serialization of the RouterMediator");
            }
            if (route.getMatch() != null) {
                routeElem.addAttribute(fac.createOMAttribute("match", nullNS, route.getMatch().pattern()));
            }
            if (!route.isBreakRouter()) {
                routeElem.addAttribute(fac.createOMAttribute("breakRouter", nullNS, "false"));
            }
            if (route.getTarget() != null) {
                routeElem.addChild((OMNode)TargetSerializer.serializeTarget((Target)route.getTarget()));
            } else {
                this.handleException("Route without a target has been found in the serialization of the RouterMediator");
            }
            routerElem.addChild((OMNode)routeElem);
        }
        this.serializeComments(routerElem, m.getCommentsList());
        return routerElem;
    }

    public String getMediatorClassName() {
        return RouterMediator.class.getName();
    }
}

