/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediators.router.impl;

import java.util.LinkedList;
import java.util.List;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.eip.Target;
import org.wso2.carbon.mediators.router.impl.Route;

public class RouterMediator
extends AbstractMediator
implements ManagedLifecycle {
    private List<Route> routes = new LinkedList<Route>();
    private boolean continueAfter = false;

    public boolean mediate(MessageContext synCtx) {
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)"Start : Router mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        for (Route route : this.routes) {
            int routeState = route.doRoute(synCtx, synLog);
            if (0 == routeState && synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug((Object)("The message does not matches the routing conditions : Expression = '" + route.getExpression() + "'" + (route.getMatch() != null ? " Pattern = '" + route.getMatch().toString() + "'" : "")));
                continue;
            }
            Target routeTarget = route.getTarget();
            String targetString = null;
            if (routeTarget != null) {
                targetString = routeTarget.getSequenceRef() != null ? "Sequence <" + routeTarget.getSequenceRef() + ">" : (routeTarget.getSequence() != null ? "Sequence <annonymous>" : (routeTarget.getEndpointRef() != null ? "Endpoint <" + routeTarget.getEndpointRef() + ">" : (routeTarget.getEndpoint() != null ? "Endpoint <annonymous>" : "without an endpoint or a sequence")));
            }
            if (2 == routeState && synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug((Object)("The message has been routed to the target : " + targetString + ", but further routings are allowed"));
                continue;
            }
            if (1 == routeState) {
                synLog.traceOrDebug((Object)("The message has been routed to the target : " + targetString + ", and no further routes are allowed"));
                break;
            }
            if (3 != routeState) continue;
            synLog.traceOrDebug((Object)("The message has been routed to the target : " + targetString + ", and the message is droped on the route"));
            return false;
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)"End : Router mediator");
        }
        return this.continueAfter;
    }

    public List<Route> getRoutes() {
        return this.routes;
    }

    public void setRoutes(List<Route> routes) {
        this.routes = routes;
    }

    public void addRoute(Route route) {
        this.routes.add(route);
    }

    public boolean isContinueAfter() {
        return this.continueAfter;
    }

    public void setContinueAfter(boolean continueAfter) {
        this.continueAfter = continueAfter;
    }

    public void init(SynapseEnvironment synapseEnvironment) {
        for (Route route : this.routes) {
            Endpoint endpoint;
            Target routingTarget = route.getTarget();
            if (routingTarget == null) continue;
            SequenceMediator synSeqForRoute = routingTarget.getSequence();
            if (synSeqForRoute != null) {
                synSeqForRoute.init(synapseEnvironment);
            }
            if ((endpoint = routingTarget.getEndpoint()) == null) continue;
            endpoint.init(synapseEnvironment);
        }
    }

    public void destroy() {
        for (Route route : this.routes) {
            SequenceMediator synSeqForRoute;
            Target routingTarget = route.getTarget();
            if (routingTarget == null || (synSeqForRoute = routingTarget.getSequence()) == null) continue;
            synSeqForRoute.destroy();
        }
    }
}

