/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.v3.models;

import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.common.ExternalDocumentation;
import io.apicurio.datamodels.core.models.common.IServerParent;
import io.apicurio.datamodels.core.models.common.Server;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.models.OasResponses;
import io.apicurio.datamodels.openapi.models.OasSecurityRequirement;
import io.apicurio.datamodels.openapi.v3.models.Oas30Callback;
import io.apicurio.datamodels.openapi.v3.models.Oas30ExternalDocumentation;
import io.apicurio.datamodels.openapi.v3.models.Oas30Parameter;
import io.apicurio.datamodels.openapi.v3.models.Oas30RequestBody;
import io.apicurio.datamodels.openapi.v3.models.Oas30Responses;
import io.apicurio.datamodels.openapi.v3.models.Oas30SecurityRequirement;
import io.apicurio.datamodels.openapi.v3.models.Oas30Server;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Oas30Operation
extends OasOperation
implements IServerParent {
    public Oas30RequestBody requestBody;
    public Map<String, Oas30Callback> callbacks = new LinkedHashMap<String, Oas30Callback>();
    public List<Server> servers;

    public Oas30Operation(String method) {
        super(method);
    }

    @Override
    public ExternalDocumentation createExternalDocumentation() {
        Oas30ExternalDocumentation externalDocs = new Oas30ExternalDocumentation();
        externalDocs._ownerDocument = this.ownerDocument();
        externalDocs._parent = this;
        return externalDocs;
    }

    @Override
    public OasParameter createParameter() {
        Oas30Parameter param = new Oas30Parameter();
        param._ownerDocument = this.ownerDocument();
        param._parent = this;
        return param;
    }

    @Override
    public OasResponses createResponses() {
        Oas30Responses responses = new Oas30Responses();
        responses._ownerDocument = this.ownerDocument();
        responses._parent = this;
        return responses;
    }

    @Override
    public OasSecurityRequirement createSecurityRequirement() {
        Oas30SecurityRequirement requirement = new Oas30SecurityRequirement();
        requirement._ownerDocument = this.ownerDocument();
        requirement._parent = this;
        return requirement;
    }

    public Oas30Callback createCallback(String name) {
        Oas30Callback rval = new Oas30Callback(name);
        rval._ownerDocument = this.ownerDocument();
        rval._parent = this;
        return rval;
    }

    public void addCallback(String name, Oas30Callback callback) {
        this.callbacks.put(name, callback);
    }

    public Oas30Callback getCallback(String name) {
        return this.callbacks.get(name);
    }

    public Oas30Callback removeCallback(String name) {
        return this.callbacks.remove(name);
    }

    public List<Oas30Callback> getCallbacks() {
        ArrayList<Oas30Callback> rval = new ArrayList<Oas30Callback>();
        rval.addAll(this.callbacks.values());
        return rval;
    }

    public Oas30RequestBody createRequestBody() {
        Oas30RequestBody rval = new Oas30RequestBody();
        rval._ownerDocument = this.ownerDocument();
        rval._parent = this;
        return rval;
    }

    @Override
    public Server createServer() {
        Oas30Server rval = new Oas30Server();
        rval._ownerDocument = this.ownerDocument();
        rval._parent = this;
        return rval;
    }

    @Override
    public void addServer(Server server) {
        if (this.servers == null) {
            this.servers = new ArrayList<Server>();
        }
        this.servers.add((Oas30Server)server);
    }

    @Override
    public Server getServer(String url) {
        if (this.servers != null) {
            for (Server server : this.servers) {
                if (!NodeCompat.equals(server.url, url)) continue;
                return server;
            }
        }
        return null;
    }

    @Override
    public List<Server> getServers() {
        return this.servers;
    }
}

