/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.invalid.value;

import io.apicurio.datamodels.core.util.VisitorUtil;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.core.validation.rules.invalid.value.OasInvalidPropertyValueRule;
import io.apicurio.datamodels.core.visitors.OperationFinder;
import io.apicurio.datamodels.core.visitors.TraverserDirection;
import io.apicurio.datamodels.openapi.v3.models.Oas30Link;
import io.apicurio.datamodels.openapi.v3.models.Oas30LinkDefinition;

public class OasInvalidLinkOperationIdRule
extends OasInvalidPropertyValueRule {
    public OasInvalidLinkOperationIdRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitLink(Oas30Link node) {
        if (this.hasValue(node.operationId)) {
            OperationFinder finder = new OperationFinder(node.operationId);
            VisitorUtil.visitTree(node.ownerDocument(), finder, TraverserDirection.down);
            this.reportIfInvalid(finder.isFound(), node, "operationId", this.map(new String[0]));
        }
    }

    @Override
    public void visitLinkDefinition(Oas30LinkDefinition node) {
        this.visitLink(node);
    }
}

