/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.io;

import io.apicurio.datamodels.core.io.DataModelReader;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.core.models.ValidationProblem;
import io.apicurio.datamodels.core.models.common.Contact;
import io.apicurio.datamodels.core.models.common.ExternalDocumentation;
import io.apicurio.datamodels.core.models.common.IDefinition;
import io.apicurio.datamodels.core.models.common.Info;
import io.apicurio.datamodels.core.models.common.License;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.core.models.common.SecurityRequirement;
import io.apicurio.datamodels.core.models.common.SecurityScheme;
import io.apicurio.datamodels.core.models.common.Tag;
import io.apicurio.datamodels.core.visitors.IVisitor;

public class DataModelReaderDispatcher
implements IVisitor {
    protected DataModelReader reader;
    protected Object json;

    public DataModelReaderDispatcher(Object json, DataModelReader reader) {
        this.reader = reader;
        this.json = json;
    }

    @Override
    public void visitDocument(Document node) {
        this.reader.readDocument(this.json, node);
    }

    @Override
    public void visitInfo(Info node) {
        this.reader.readInfo(this.json, node);
    }

    @Override
    public void visitContact(Contact node) {
        this.reader.readContact(this.json, node);
    }

    @Override
    public void visitLicense(License node) {
        this.reader.readLicense(this.json, node);
    }

    @Override
    public void visitTag(Tag node) {
        this.reader.readTag(this.json, node);
    }

    @Override
    public void visitExternalDocumentation(ExternalDocumentation node) {
        this.reader.readExternalDocumentation(this.json, node);
    }

    @Override
    public void visitExtension(Extension node) {
    }

    @Override
    public void visitSecurityRequirement(SecurityRequirement node) {
        this.reader.readSecurityRequirement(this.json, node);
    }

    @Override
    public void visitValidationProblem(ValidationProblem problem) {
    }

    @Override
    public void visitSchema(Schema node) {
        this.reader.readSchema(this.json, node);
    }

    @Override
    public void visitSchemaDefinition(IDefinition node) {
        this.reader.readSchema(this.json, (Schema)((Object)node));
    }

    @Override
    public void visitParameter(Parameter node) {
        this.reader.readParameter(this.json, node);
    }

    @Override
    public void visitParameterDefinition(IDefinition node) {
        this.reader.readParameter(this.json, (Parameter)((Object)node));
    }

    @Override
    public void visitOperation(Operation node) {
        this.reader.readOperation(this.json, node);
    }

    @Override
    public void visitSecurityScheme(SecurityScheme node) {
        this.reader.readSecurityScheme(this.json, node);
    }
}

