/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.compat;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.JsonNodeDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.SimpleType;
import io.apicurio.datamodels.cmd.ICommand;
import io.apicurio.datamodels.cmd.commands.CommandFactory;
import io.apicurio.datamodels.cmd.models.SimplifiedParameterType;
import io.apicurio.datamodels.cmd.models.SimplifiedPropertyType;
import io.apicurio.datamodels.cmd.models.SimplifiedType;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.NodePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MarshallCompat {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static Object marshallCommand(ICommand command) {
        JsonNode rval = mapper.valueToTree((Object)command);
        JsonCompat.setPropertyString(rval, "__type", command.type());
        return rval;
    }

    public static ICommand unmarshallCommand(Object from) {
        String type = JsonCompat.consumePropertyString(from, "__type");
        if (type == null) {
            throw new RuntimeException("Missing __type from source data.");
        }
        try {
            Class<?> cmdClass = CommandFactory.create(type).getClass();
            ICommand cmd = (ICommand)mapper.treeToValue((TreeNode)from, cmdClass);
            return cmd;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error unmarshalling command: " + type, e);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Missing command from unmarshalling factory: " + type, e);
        }
    }

    private static Object marshallSimplifiedType(SimplifiedType sType) {
        if (NodeCompat.isNullOrUndefined(sType)) {
            return null;
        }
        ObjectNode obj = JsonCompat.objectNode();
        JsonCompat.setPropertyString(obj, "type", sType.type);
        JsonCompat.setPropertyStringArray(obj, "enum", sType.enum_);
        JsonCompat.setProperty(obj, "of", MarshallCompat.marshallSimplifiedType(sType.of));
        JsonCompat.setPropertyString(obj, "as", sType.as);
        return obj;
    }

    private static SimplifiedType unmarshallSimplifiedType(Object from) {
        if (NodeCompat.isNullOrUndefined(from)) {
            return null;
        }
        SimplifiedType type = new SimplifiedType();
        type.type = JsonCompat.getPropertyString(from, "type");
        type.enum_ = JsonCompat.getPropertyStringArray(from, "enum");
        type.of = MarshallCompat.unmarshallSimplifiedType(JsonCompat.getProperty(from, "of"));
        type.as = JsonCompat.getPropertyString(from, "as");
        return type;
    }

    private static Object marshallSimplifiedParameterType(SimplifiedParameterType sType) {
        if (NodeCompat.isNullOrUndefined(sType)) {
            return null;
        }
        Object obj = MarshallCompat.marshallSimplifiedType(sType);
        JsonCompat.setPropertyBoolean(obj, "required", sType.required);
        return obj;
    }

    private static SimplifiedParameterType unmarshallSimplifiedParameterType(Object from) {
        if (NodeCompat.isNullOrUndefined(from)) {
            return null;
        }
        SimplifiedParameterType type = new SimplifiedParameterType();
        type.type = JsonCompat.getPropertyString(from, "type");
        type.enum_ = JsonCompat.getPropertyStringArray(from, "enum");
        type.of = MarshallCompat.unmarshallSimplifiedType(JsonCompat.getProperty(from, "of"));
        type.as = JsonCompat.getPropertyString(from, "as");
        Boolean req = JsonCompat.getPropertyBoolean(from, "required");
        if (req != null) {
            type.required = req;
        }
        return type;
    }

    private static Object marshallSimplifiedPropertyType(SimplifiedPropertyType sType) {
        if (NodeCompat.isNullOrUndefined(sType)) {
            return null;
        }
        Object obj = MarshallCompat.marshallSimplifiedType(sType);
        JsonCompat.setPropertyBoolean(obj, "required", sType.required);
        return obj;
    }

    private static SimplifiedPropertyType unmarshallSimplifiedPropertyType(Object from) {
        if (NodeCompat.isNullOrUndefined(from)) {
            return null;
        }
        SimplifiedPropertyType type = new SimplifiedPropertyType();
        type.type = JsonCompat.getPropertyString(from, "type");
        type.enum_ = JsonCompat.getPropertyStringArray(from, "enum");
        type.of = MarshallCompat.unmarshallSimplifiedType(JsonCompat.getProperty(from, "of"));
        type.as = JsonCompat.getPropertyString(from, "as");
        Boolean req = JsonCompat.getPropertyBoolean(from, "required");
        if (req != null) {
            type.required = req;
        }
        return type;
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer(NodePath.class, (JsonSerializer)new NodePathSerializer());
        module.addSerializer(SimplifiedType.class, new SimplifiedTypeSerializer(SerializerFlavor.base));
        module.addSerializer(SimplifiedParameterType.class, new SimplifiedTypeSerializer(SerializerFlavor.parameter));
        module.addSerializer(SimplifiedPropertyType.class, new SimplifiedTypeSerializer(SerializerFlavor.property));
        module.addDeserializer(NodePath.class, (JsonDeserializer)new NodePathDeserializer());
        module.addDeserializer(SimplifiedType.class, new SimplifiedTypeDeserializer(SerializerFlavor.base));
        module.addDeserializer(SimplifiedParameterType.class, new SimplifiedTypeDeserializer(SerializerFlavor.parameter));
        module.addDeserializer(SimplifiedPropertyType.class, new SimplifiedTypeDeserializer(SerializerFlavor.property));
        mapper.registerModule((Module)module);
    }

    public static class NullableJsonNodeDeserializer
    extends JsonNodeDeserializer {
        private static final long serialVersionUID = -3295567082289568935L;

        public JsonNode getNullValue(DeserializationContext ctxt) {
            return null;
        }
    }

    public static class CommandListDeserializer
    extends JsonDeserializer<List<ICommand>> {
        public List<ICommand> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ArrayList<ICommand> commands = new ArrayList<ICommand>();
            boolean done = false;
            while (!done) {
                JsonToken token = p.nextToken();
                if (token == JsonToken.END_ARRAY) {
                    done = true;
                    continue;
                }
                JsonDeserializer deserializer = ctxt.findNonContextualValueDeserializer((JavaType)SimpleType.constructUnsafe(JsonNode.class));
                TreeNode value = (TreeNode)deserializer.deserialize(p, ctxt);
                ICommand cmd = MarshallCompat.unmarshallCommand(value);
                commands.add(cmd);
            }
            return commands;
        }
    }

    public static class CommandListSerializer
    extends JsonSerializer<List<ICommand>> {
        public void serialize(List<ICommand> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartArray(value.size());
            try {
                for (ICommand command : value) {
                    Object c = MarshallCompat.marshallCommand(command);
                    JsonSerializer cmdSerializer = serializers.findValueSerializer(c.getClass());
                    cmdSerializer.serialize(c, gen, serializers);
                }
            }
            catch (JsonMappingException e) {
                throw new IOException(e);
            }
            gen.writeEndArray();
        }
    }

    public static class SimplifiedTypeDeserializer<T extends SimplifiedType>
    extends JsonDeserializer<T> {
        private SerializerFlavor flavor;

        public SimplifiedTypeDeserializer(SerializerFlavor flavor) {
            this.flavor = flavor;
        }

        public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonDeserializer deserializer = ctxt.findNonContextualValueDeserializer((JavaType)SimpleType.constructUnsafe(JsonNode.class));
            TreeNode value = (TreeNode)deserializer.deserialize(p, ctxt);
            if (this.flavor == SerializerFlavor.property) {
                return (T)MarshallCompat.unmarshallSimplifiedPropertyType(value);
            }
            if (this.flavor == SerializerFlavor.parameter) {
                return (T)MarshallCompat.unmarshallSimplifiedParameterType(value);
            }
            return (T)MarshallCompat.unmarshallSimplifiedType(value);
        }
    }

    public static class SimplifiedTypeSerializer<T extends SimplifiedType>
    extends JsonSerializer<T> {
        private SerializerFlavor flavor;

        public SimplifiedTypeSerializer(SerializerFlavor flavor) {
            this.flavor = flavor;
        }

        public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            Object c = this.flavor == SerializerFlavor.parameter ? MarshallCompat.marshallSimplifiedParameterType((SimplifiedParameterType)value) : (this.flavor == SerializerFlavor.property ? MarshallCompat.marshallSimplifiedPropertyType((SimplifiedPropertyType)value) : MarshallCompat.marshallSimplifiedType(value));
            JsonSerializer cmdSerializer = serializers.findValueSerializer(c.getClass());
            cmdSerializer.serialize(c, gen, serializers);
        }
    }

    public static enum SerializerFlavor {
        base,
        parameter,
        property;

    }

    public static class NodePathDeserializer
    extends JsonDeserializer<NodePath> {
        public NodePath deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            NodePath rval = null;
            String path = p.getText();
            if (path != null) {
                rval = new NodePath(path);
            }
            return rval;
        }
    }

    public static class NodePathSerializer
    extends JsonSerializer<NodePath> {
        public void serialize(NodePath value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.toString());
        }
    }
}

