/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.util;

import io.apicurio.datamodels.asyncapi.models.AaiSchema;
import io.apicurio.datamodels.cmd.models.SimplifiedType;
import io.apicurio.datamodels.cmd.util.SetItemsTypeVisitor;
import io.apicurio.datamodels.core.models.DocumentType;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.core.util.VisitorUtil;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v2.models.Oas20Parameter;
import java.util.ArrayList;

public class SimplifiedTypeUtil {
    public static void setSimplifiedType(Schema node, SimplifiedType type) {
        if (node.ownerDocument().getDocumentType() == DocumentType.asyncapi2) {
            SimplifiedTypeUtil.setSimplifiedType_aai((AaiSchema)node, type);
        } else {
            SimplifiedTypeUtil.setSimplifiedType_oas((OasSchema)node, type);
        }
    }

    private static void setSimplifiedType_oas(OasSchema node, SimplifiedType type) {
        node.$ref = null;
        node.type = null;
        node.enum_ = null;
        node.format = null;
        node.items = null;
        if (type.isSimpleType()) {
            node.type = type.type;
            node.format = type.as;
        }
        if (type.isFileType()) {
            node.type = type.type;
        }
        if (type.isEnum()) {
            node.enum_ = new ArrayList<String>();
            type.enum_.forEach(v -> node.enum_.add(String.valueOf(v)));
        }
        if (type.isRef()) {
            node.$ref = type.type;
        }
        if (type.isArray()) {
            node.type = "array";
            SetItemsTypeVisitor viz = new SetItemsTypeVisitor(type);
            VisitorUtil.visitNode(node, viz);
        }
    }

    private static void setSimplifiedType_aai(AaiSchema node, SimplifiedType type) {
        node.$ref = null;
        node.type = null;
        node.enum_ = null;
        node.format = null;
        node.items = null;
        if (type.isSimpleType()) {
            node.type = type.type;
            node.format = type.as;
        }
        if (type.isFileType()) {
            node.type = type.type;
        }
        if (type.isEnum()) {
            node.enum_ = new ArrayList<Object>();
            type.enum_.forEach(v -> node.enum_.add(String.valueOf(v)));
        }
        if (type.isRef()) {
            node.$ref = type.type;
        }
        if (type.isArray()) {
            node.type = "array";
            SetItemsTypeVisitor viz = new SetItemsTypeVisitor(type);
            VisitorUtil.visitNode(node, viz);
        }
    }

    public static void setSimplifiedTypeOnParam(Oas20Parameter node, SimplifiedType type) {
        node.$ref = null;
        node.type = null;
        node.enum_ = null;
        node.format = null;
        node.items = null;
        if (type.isSimpleType()) {
            node.type = type.type;
            node.format = type.as;
        }
        if (type.isFileType()) {
            node.type = type.type;
        }
        if (type.isEnum()) {
            node.enum_ = new ArrayList<String>();
            type.enum_.forEach(v -> node.enum_.add(String.valueOf(v)));
        }
        if (type.isRef()) {
            node.$ref = type.type;
        }
        if (type.isArray()) {
            node.type = "array";
            SetItemsTypeVisitor viz = new SetItemsTypeVisitor(type);
            VisitorUtil.visitNode(node, viz);
        }
    }
}

