/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.cmd.commands.NewResponseDefinitionCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30ResponseDefinition;

public class NewResponseDefinitionCommand_30
extends NewResponseDefinitionCommand {
    public boolean _nullComponents;

    NewResponseDefinitionCommand_30() {
    }

    NewResponseDefinitionCommand_30(String definitionName, String description) {
        this._newDefinitionName = definitionName;
        this._newDefinitionDescription = description;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[NewResponseDefinitionCommand] Executing.", new Object[0]);
        Oas30Document doc30 = (Oas30Document)document;
        if (this.isNullOrUndefined(doc30.components)) {
            doc30.components = doc30.createComponents();
            this._nullComponents = true;
        }
        this._nullComponents = false;
        if (this.isNullOrUndefined(doc30.components.getResponseDefinition(this._newDefinitionName))) {
            Oas30ResponseDefinition definition = doc30.components.createResponseDefinition(this._newDefinitionName);
            if (ModelUtils.isDefined(this._newDefinitionDescription)) {
                definition.description = this._newDefinitionDescription;
            }
            doc30.components.addResponseDefinition(this._newDefinitionName, definition);
            this._defExisted = false;
        } else {
            this._defExisted = true;
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[NewResponseDefinitionCommand] Reverting.", new Object[0]);
        Oas30Document doc30 = (Oas30Document)document;
        if (this._nullComponents) {
            doc30.components = null;
        }
        if (this._defExisted) {
            return;
        }
        doc30.components.removeResponseDefinition(this._newDefinitionName);
    }
}

