/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.cmd.commands.NewResponseDefinitionCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20ResponseDefinition;

public class NewResponseDefinitionCommand_20
extends NewResponseDefinitionCommand {
    public boolean _nullResponses;

    NewResponseDefinitionCommand_20() {
    }

    NewResponseDefinitionCommand_20(String definitionName, String description) {
        this._newDefinitionName = definitionName;
        this._newDefinitionDescription = description;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[NewResponseDefinitionCommand] Executing.", new Object[0]);
        Oas20Document doc20 = (Oas20Document)document;
        if (this.isNullOrUndefined(doc20.responses)) {
            doc20.responses = doc20.createResponseDefinitions();
            this._nullResponses = true;
        }
        if (this.isNullOrUndefined(doc20.responses.getResponse(this._newDefinitionName))) {
            Oas20ResponseDefinition responseDef = doc20.responses.createResponse(this._newDefinitionName);
            if (ModelUtils.isDefined(this._newDefinitionDescription)) {
                responseDef.description = this._newDefinitionDescription;
            }
            doc20.responses.addResponse(this._newDefinitionName, responseDef);
            this._defExisted = false;
        } else {
            this._defExisted = true;
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[NewResponseDefinitionCommand] Reverting.", new Object[0]);
        Oas20Document doc20 = (Oas20Document)document;
        if (this._nullResponses) {
            doc20.responses = null;
        }
        if (this._defExisted) {
            return;
        }
        doc20.responses.removeResponse(this._newDefinitionName);
    }
}

