/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasPathItem;

public class NewOperationCommand
extends AbstractCommand {
    public String _path;
    public String _method;
    public boolean _created;

    NewOperationCommand() {
    }

    NewOperationCommand(String path, String method) {
        this._path = path;
        this._method = method;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[NewOperationCommand] Executing.", new Object[0]);
        OasDocument odoc = (OasDocument)document;
        this._created = false;
        if (this.isNullOrUndefined(odoc.paths)) {
            return;
        }
        OasPathItem path = odoc.paths.getPathItem(this._path);
        if (this.isNullOrUndefined(path)) {
            return;
        }
        OasOperation operation = path.createOperation(this._method);
        NodeCompat.setProperty(path, this._method, operation);
        this._created = true;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[NewOperationCommand] Reverting.", new Object[0]);
        if (!this._created) {
            return;
        }
        OasDocument odoc = (OasDocument)document;
        if (this.isNullOrUndefined(odoc.paths)) {
            return;
        }
        OasPathItem path = odoc.paths.getPathItem(this._path);
        if (this.isNullOrUndefined(path)) {
            return;
        }
        NodeCompat.setProperty(path, this._method, null);
    }
}

