/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.NodePath;

public abstract class DeleteNodeCommand<T extends Node>
extends AbstractCommand {
    public String _property;
    public NodePath _parentPath;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldValue;

    DeleteNodeCommand() {
    }

    DeleteNodeCommand(String property, Node from) {
        this._property = property;
        this._parentPath = Library.createNodePath(from);
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[" + this.type() + "] Executing.", new Object[0]);
        Node parent = this._parentPath.resolve(document);
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        Node propertyNode = (Node)NodeCompat.getProperty(parent, this._property);
        if (this.isNullOrUndefined(propertyNode)) {
            this._oldValue = null;
            return;
        }
        this._oldValue = Library.writeNode(propertyNode);
        NodeCompat.setProperty(parent, this._property, null);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[" + this.type() + "] Reverting.", new Object[0]);
        Node parent = this._parentPath.resolve(document);
        if (this.isNullOrUndefined(parent) || this.isNullOrUndefined(this._oldValue)) {
            return;
        }
        T restoredNode = this.readNode(document, this._oldValue);
        ((Node)restoredNode)._parent = parent;
        ((Node)restoredNode)._ownerDocument = parent.ownerDocument();
        NodeCompat.setProperty(parent, this._property, restoredNode);
    }

    protected abstract T readNode(Document var1, Object var2);
}

