/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.core.models.Document;

public class ChangeTitleCommand
extends AbstractCommand {
    public String _newTitle;
    public String _oldTitle;
    public boolean _nullInfo;

    ChangeTitleCommand() {
    }

    ChangeTitleCommand(String newTitle) {
        this._newTitle = newTitle;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[ChangeTitleCommand] Executing.", new Object[0]);
        if (ModelUtils.isNullOrUndefined(document.info)) {
            document.info = document.createInfo();
            this._nullInfo = true;
            this._oldTitle = null;
        } else {
            this._oldTitle = document.info.title;
        }
        document.info.title = this._newTitle;
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[ChangeTitleCommand] Reverting.", new Object[0]);
        if (this._nullInfo) {
            document.info = null;
        } else {
            document.info.title = this._oldTitle;
        }
    }
}

