/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.models.SimplifiedType;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.cmd.util.SimplifiedTypeUtil;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.v2.models.Oas20Response;

public class ChangeResponseTypeCommand
extends AbstractCommand {
    public NodePath _responsePath;
    public SimplifiedType _newType;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldSchema;

    ChangeResponseTypeCommand() {
    }

    ChangeResponseTypeCommand(Oas20Response response, SimplifiedType newType) {
        this._responsePath = Library.createNodePath(response);
        this._newType = newType;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[ChangeResponseTypeCommand] Executing.", new Object[0]);
        Oas20Response response = (Oas20Response)this._responsePath.resolve(document);
        if (this.isNullOrUndefined(response)) {
            return;
        }
        this._oldSchema = null;
        if (ModelUtils.isDefined(response.schema)) {
            this._oldSchema = Library.writeNode(response.schema);
        }
        response.schema = response.createSchema();
        SimplifiedTypeUtil.setSimplifiedType(response.schema, this._newType);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[ChangeResponseTypeCommand] Reverting.", new Object[0]);
        Oas20Response response = (Oas20Response)this._responsePath.resolve(document);
        if (this.isNullOrUndefined(response)) {
            return;
        }
        if (ModelUtils.isDefined(this._oldSchema)) {
            response.schema = response.createSchema();
            Library.readNode(this._oldSchema, response.schema);
        } else {
            response.schema = null;
        }
    }
}

