/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.core.websocket;

import java.util.Map;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.jaggeryjs.hostobjects.web.WebSocketHostObject;
import org.jaggeryjs.jaggery.core.websocket.JaggeryBinaryMessageHandler;
import org.jaggeryjs.jaggery.core.websocket.JaggeryStringMessageHandler;

public class JaggeryWSEndpoint
extends Endpoint {
    private WebSocketHostObject webSockHostObject = null;

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        Map userProperties = endpointConfig.getUserProperties();
        this.webSockHostObject = (WebSocketHostObject)userProperties.get("webSocket");
        this.webSockHostObject.setSession(session);
        JaggeryStringMessageHandler stringMsgHandler = new JaggeryStringMessageHandler(this.webSockHostObject, session);
        JaggeryBinaryMessageHandler binaryMsgHandler = new JaggeryBinaryMessageHandler(this.webSockHostObject, session);
        session.addMessageHandler((MessageHandler)stringMsgHandler);
        session.addMessageHandler((MessageHandler)binaryMsgHandler);
        this.webSockHostObject.processOnOpen();
    }

    public final void onClose(Session session, CloseReason closeReason) {
        int status = closeReason.getCloseCode().getCode();
        this.webSockHostObject.processOnClose(status);
    }
}

