/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.core.manager;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import javax.servlet.ServletContext;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.security.RhinoSecurityDomain;

public class JaggerySecurityDomain
implements RhinoSecurityDomain {
    private String scriptPath;
    private CodeSource codeSource;
    private ServletContext servletContext;

    public JaggerySecurityDomain(String scriptPath, ServletContext servletContext) {
        this.scriptPath = scriptPath;
        this.servletContext = servletContext;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    public CodeSource getCodeSource() throws ScriptException {
        if (this.codeSource != null) {
            return this.codeSource;
        }
        try {
            String contextPath = this.servletContext.getRealPath("/");
            if (!contextPath.endsWith(File.separator)) {
                contextPath = contextPath + File.separator;
            }
            URL url = new File(contextPath + this.scriptPath).getCanonicalFile().toURI().toURL();
            this.codeSource = new CodeSource(url, (Certificate[])null);
            return this.codeSource;
        }
        catch (IOException e) {
            throw new ScriptException((Exception)e);
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }
}

