/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.core;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.websocket.server.UpgradeUtil;
import org.apache.tomcat.websocket.server.WsServerContainer;
import org.jaggeryjs.hostobjects.web.WebSocketHostObject;
import org.jaggeryjs.jaggery.core.manager.CommonManager;
import org.jaggeryjs.jaggery.core.manager.WebAppManager;
import org.jaggeryjs.jaggery.core.websocket.JaggeryWSEndpoint;
import org.jaggeryjs.scriptengine.engine.JaggeryContext;
import org.jaggeryjs.scriptengine.engine.RhinoEngine;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JaggeryFilter
implements Filter {
    private static final Log log = LogFactory.getLog(JaggeryFilter.class);
    private transient WsServerContainer sc;
    private static final String SERVER_CONTAINER_SERVLET_CONTEXT_ATTRIBUTE = "javax.websocket.server.ServerContainer";

    public void init(FilterConfig filterConfig) throws ServletException {
        this.sc = (WsServerContainer)filterConfig.getServletContext().getAttribute(SERVER_CONTAINER_SERVLET_CONTEXT_ATTRIBUTE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (WebAppManager.isWebSocket(servletRequest)) {
            WebSocketHostObject webSocketHostObject;
            try {
                CommonManager.getInstance().getEngine().enterContext();
            }
            catch (ScriptException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            HttpServletRequest req = (HttpServletRequest)servletRequest;
            HttpServletResponse resp = (HttpServletResponse)servletResponse;
            try {
                WebAppManager.execute(req, resp);
                JaggeryContext context = CommonManager.getJaggeryContext();
                ScriptableObject scope = context.getScope();
                webSocketHostObject = (WebSocketHostObject)scope.get("webSocket", (Scriptable)scope);
            }
            finally {
                RhinoEngine.exitContext();
            }
            if (webSocketHostObject != null) {
                JaggeryWSEndpoint jaggeryWSEndpoint = new JaggeryWSEndpoint();
                ServerEndpointConfig sec = ServerEndpointConfig.Builder.create(((Object)((Object)jaggeryWSEndpoint)).getClass(), (String)"").build();
                sec.getUserProperties().put("webSocket", webSocketHostObject);
                UpgradeUtil.doUpgrade((WsServerContainer)this.sc, (HttpServletRequest)req, (HttpServletResponse)resp, (ServerEndpointConfig)sec, new HashMap());
            }
        } else {
            servletRequest.getServletContext().getNamedDispatcher("JaggeryServlet").forward(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }
}

