/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.security.ui.client;

import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.sts.common.stub.config.xsd.SecurityConfigData;
import org.wso2.carbon.identity.sts.common.stub.config.xsd.SecurityScenarioData;
import org.wso2.carbon.identity.sts.common.stub.config.xsd.SecurityScenarioDataWrapper;
import org.wso2.carbon.security.mgt.stub.config.ActivateUsernameTokenAuthentication;
import org.wso2.carbon.security.mgt.stub.config.ApplyKerberosSecurityPolicy;
import org.wso2.carbon.security.mgt.stub.config.ApplySecurity;
import org.wso2.carbon.security.mgt.stub.config.DisableSecurityOnService;
import org.wso2.carbon.security.mgt.stub.config.GetScenarios;
import org.wso2.carbon.security.mgt.stub.config.GetScenariosResponse;
import org.wso2.carbon.security.mgt.stub.config.GetSecurityConfigData;
import org.wso2.carbon.security.mgt.stub.config.GetSecurityConfigDataResponse;
import org.wso2.carbon.security.mgt.stub.config.GetSecurityScenario;
import org.wso2.carbon.security.mgt.stub.config.GetSecurityScenarioResponse;
import org.wso2.carbon.security.mgt.stub.config.SecurityAdminServiceStub;

public class SecurityAdminClient {
    private static final Log log = LogFactory.getLog(SecurityAdminClient.class);
    private SecurityAdminServiceStub stub = null;

    public SecurityAdminClient(String cookie, String url, ConfigurationContext configContext) throws Exception {
        try {
            String serviceEndPoint = url + "SecurityAdminService";
            this.stub = new SecurityAdminServiceStub(configContext, serviceEndPoint);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (Exception e) {
            log.error((Object)"Error in creating SecurityAdminClient", (Throwable)e);
            throw e;
        }
    }

    public void activateUsernameTokenAuthentication(String serviceName, String[] userGroups) throws Exception {
        try {
            ActivateUsernameTokenAuthentication request = new ActivateUsernameTokenAuthentication();
            request.setServiceName(serviceName);
            request.setUserGroups(userGroups);
            this.stub.activateUsernameTokenAuthentication(request);
        }
        catch (Exception e) {
            log.error((Object)"Error in activating username token authentication.", (Throwable)e);
            throw e;
        }
    }

    public void disableSecurityOnService(String serviceName) throws Exception {
        try {
            DisableSecurityOnService request = new DisableSecurityOnService();
            request.setServiceName(serviceName);
            this.stub.disableSecurityOnService(request);
        }
        catch (Exception e) {
            log.error((Object)"Error in disabling security on service", (Throwable)e);
            throw e;
        }
    }

    public void applyKerberosSecurity(String serviceName, String scenarioId, String servicePrincipal, String password) throws Exception {
        try {
            ApplyKerberosSecurityPolicy request = new ApplyKerberosSecurityPolicy();
            request.setServiceName(serviceName);
            request.setPolicyId(scenarioId);
            request.setServicePrincipalName(servicePrincipal);
            request.setServicePrincipalPassword(password);
            this.stub.applyKerberosSecurityPolicy(request);
        }
        catch (Exception e) {
            log.error((Object)"Error in applying kerberos security.", (Throwable)e);
            throw e;
        }
    }

    public void applySecurity(String serviceName, String scenarioId, String policyPath, String[] trustedStores, String privateStore, String[] userGroups) throws Exception {
        try {
            ApplySecurity request = new ApplySecurity();
            request.setServiceName(serviceName);
            request.setPolicyId(scenarioId);
            request.setPolicyPath(policyPath);
            request.setTrustedStores(trustedStores);
            request.setPrivateStore(privateStore);
            request.setUserGroupNames(userGroups);
            this.stub.applySecurity(request);
        }
        catch (Exception e) {
            log.error((Object)"Error in applying security.", (Throwable)e);
            throw e;
        }
    }

    public SecurityScenarioDataWrapper getScenarios(String serviceName) throws Exception {
        try {
            GetScenarios request = new GetScenarios();
            request.setServiceName(serviceName);
            GetScenariosResponse response = this.stub.getScenarios(request);
            return response.get_return();
        }
        catch (Exception e) {
            log.error((Object)"Error in getting scenarios", (Throwable)e);
            throw e;
        }
    }

    public SecurityScenarioData getSecurityScenario(String serviceId) throws Exception {
        try {
            GetSecurityScenario request = new GetSecurityScenario();
            request.setSceneId(serviceId);
            GetSecurityScenarioResponse response = this.stub.getSecurityScenario(request);
            return response.get_return();
        }
        catch (Exception e) {
            log.error((Object)"Error in getting security scenarios", (Throwable)e);
            throw e;
        }
    }

    public SecurityConfigData getSecurityConfigData(String serviceName, String scenrioId, String policyPath) throws Exception {
        try {
            GetSecurityConfigData request = new GetSecurityConfigData();
            request.setServiceName(serviceName);
            request.setScenarioId(scenrioId);
            request.setPolicyPath(policyPath);
            GetSecurityConfigDataResponse response = this.stub.getSecurityConfigData(request);
            return response.get_return();
        }
        catch (Exception e) {
            log.error((Object)"Error in getting security config data", (Throwable)e);
            throw e;
        }
    }
}

