/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.security.ui.client;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.Enumeration;
import org.apache.axiom.om.util.Base64;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.util.IdentityIOStreamUtils;
import org.wso2.carbon.security.mgt.stub.keystore.AddKeyStore;
import org.wso2.carbon.security.mgt.stub.keystore.AddTrustStore;
import org.wso2.carbon.security.mgt.stub.keystore.DeleteStore;
import org.wso2.carbon.security.mgt.stub.keystore.GetKeyStoresResponse;
import org.wso2.carbon.security.mgt.stub.keystore.GetKeystoreInfo;
import org.wso2.carbon.security.mgt.stub.keystore.GetKeystoreInfoResponse;
import org.wso2.carbon.security.mgt.stub.keystore.GetPaginatedKeystoreInfo;
import org.wso2.carbon.security.mgt.stub.keystore.GetPaginatedKeystoreInfoResponse;
import org.wso2.carbon.security.mgt.stub.keystore.GetStoreEntries;
import org.wso2.carbon.security.mgt.stub.keystore.GetStoreEntriesResponse;
import org.wso2.carbon.security.mgt.stub.keystore.ImportCertToStore;
import org.wso2.carbon.security.mgt.stub.keystore.KeyStoreAdminServiceStub;
import org.wso2.carbon.security.mgt.stub.keystore.RemoveCertFromStore;
import org.wso2.carbon.security.mgt.stub.keystore.xsd.KeyStoreData;
import org.wso2.carbon.security.mgt.stub.keystore.xsd.PaginatedKeyStoreData;

public class KeyStoreAdminClient {
    private static final Log log = LogFactory.getLog(KeyStoreAdminClient.class);
    private String serviceEndPoint = null;
    private KeyStoreAdminServiceStub stub = null;

    public KeyStoreAdminClient(String cookie, String url, ConfigurationContext configContext) throws Exception {
        try {
            this.serviceEndPoint = url + "KeyStoreAdminService";
            this.stub = new KeyStoreAdminServiceStub(configContext, this.serviceEndPoint);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault e) {
            log.error((Object)"Error in creating KeyStoreAdminClient", (Throwable)e);
            throw e;
        }
    }

    public KeyStoreData[] getKeyStores() throws Exception {
        try {
            GetKeyStoresResponse response = this.stub.getKeyStores();
            return response.get_return();
        }
        catch (Exception e) {
            log.error((Object)"Error in getting keystore data", (Throwable)e);
            throw e;
        }
    }

    public void addKeyStore(byte[] content, String filename, String password, String provider, String type, String pvtkspass) throws Exception {
        try {
            String data = Base64.encode((byte[])content);
            AddKeyStore request = new AddKeyStore();
            request.setFileData(data);
            request.setFilename(filename);
            request.setPassword(password);
            request.setProvider(provider);
            request.setType(type);
            request.setPvtkeyPass(pvtkspass);
            this.stub.addKeyStore(request);
        }
        catch (Exception e) {
            log.error((Object)"Error in adding keystore", (Throwable)e);
            throw e;
        }
    }

    public void addTrustStore(byte[] content, String filename, String password, String provider, String type) {
        try {
            String data = Base64.encode((byte[])content);
            AddTrustStore request = new AddTrustStore();
            request.setFileData(data);
            request.setFilename(filename);
            request.setPassword(password);
            request.setProvider(provider);
            request.setType(type);
            this.stub.addTrustStore(request);
        }
        catch (Exception e) {
            log.error((Object)"Error in adding truststore", (Throwable)e);
        }
    }

    public void deleteStore(String keyStoreName) throws Exception {
        try {
            DeleteStore request = new DeleteStore();
            request.setKeyStoreName(keyStoreName);
            this.stub.deleteStore(request);
        }
        catch (Exception e) {
            log.error((Object)"Error in deleting keystore", (Throwable)e);
            throw e;
        }
    }

    public void importCertToStore(String filename, byte[] content, String keyStoreName) throws Exception {
        try {
            String data = Base64.encode((byte[])content);
            ImportCertToStore request = new ImportCertToStore();
            request.setFileName(filename);
            request.setFileData(data);
            request.setKeyStoreName(keyStoreName);
            this.stub.importCertToStore(request);
        }
        catch (Exception e) {
            log.error((Object)"Error in importing cert to store.", (Throwable)e);
            throw e;
        }
    }

    public String[] getStoreEntries(String keyStoreName) throws Exception {
        try {
            GetStoreEntries request = new GetStoreEntries();
            request.setKeyStoreName(keyStoreName);
            GetStoreEntriesResponse response = this.stub.getStoreEntries(request);
            return response.get_return();
        }
        catch (Exception e) {
            log.error((Object)"Error in getting store entries.", (Throwable)e);
            throw e;
        }
    }

    private byte[] getBytesFromFile(File file) throws Exception {
        FileInputStream is = new FileInputStream(file);
        try {
            int offset;
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                throw new IOException("File is too large");
            }
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception e) {
            log.error((Object)"Error in getting bytes from file.", (Throwable)e);
            throw e;
        }
        finally {
            IdentityIOStreamUtils.closeInputStream((InputStream)is);
        }
    }

    public boolean isPrivateKeyStore(byte[] content, String password, String type) throws Exception {
        try {
            boolean isPrivateStore = false;
            ByteArrayInputStream stream = new ByteArrayInputStream(content);
            KeyStore store = KeyStore.getInstance(type);
            store.load(stream, password.toCharArray());
            Enumeration<String> aliases = store.aliases();
            while (aliases.hasMoreElements()) {
                String value = aliases.nextElement();
                if (!store.isKeyEntry(value)) continue;
                isPrivateStore = true;
                break;
            }
            return isPrivateStore;
        }
        catch (Exception e) {
            log.error((Object)"Error in checking private key store.", (Throwable)e);
            throw e;
        }
    }

    public KeyStoreData getKeystoreInfo(String keyStoreName) throws Exception {
        try {
            GetKeystoreInfo request = new GetKeystoreInfo();
            request.setKeyStoreName(keyStoreName);
            GetKeystoreInfoResponse response = this.stub.getKeystoreInfo(request);
            return response.get_return();
        }
        catch (Exception e) {
            log.error((Object)"Error in getting keystore info.", (Throwable)e);
            throw e;
        }
    }

    public void removeCertificateFromKeyStore(String keySoreName, String certificateAlias) throws Exception {
        RemoveCertFromStore request = new RemoveCertFromStore();
        request.setKeyStoreName(keySoreName);
        request.setAlias(certificateAlias);
        try {
            this.stub.removeCertFromStore(request);
        }
        catch (Exception e) {
            log.error((Object)"Error in removing certificate from keystore.", (Throwable)e);
            throw e;
        }
    }

    public PaginatedKeyStoreData getPaginatedKeystoreInfo(String keyStoreName, int pageNumber) throws Exception {
        try {
            GetPaginatedKeystoreInfo request = new GetPaginatedKeystoreInfo();
            request.setKeyStoreName(keyStoreName);
            request.setPageNumber(pageNumber);
            GetPaginatedKeystoreInfoResponse response = this.stub.getPaginatedKeystoreInfo(request);
            return response.get_return();
        }
        catch (Exception e) {
            log.error((Object)"Error in getting paginated keystore info.", (Throwable)e);
            throw e;
        }
    }
}

