/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.security.ui;

import java.util.ArrayList;
import org.wso2.carbon.security.mgt.stub.keystore.xsd.CertData;
import org.wso2.carbon.security.mgt.stub.keystore.xsd.KeyStoreData;
import org.wso2.carbon.user.mgt.stub.types.carbon.FlaggedName;

public class Util {
    private Util() {
    }

    public static CertData[] doPaging(int pageNumber, CertData[] certDataSet) {
        int itemsPerPageInt = 10;
        int startIndex = pageNumber * itemsPerPageInt;
        int endIndex = (pageNumber + 1) * itemsPerPageInt;
        CertData[] returnedCertDataSet = new CertData[itemsPerPageInt];
        int i = startIndex;
        int j = 0;
        while (i < endIndex && i < certDataSet.length) {
            returnedCertDataSet[j] = certDataSet[i];
            ++i;
            ++j;
        }
        return returnedCertDataSet;
    }

    public static KeyStoreData[] doPaging(int pageNumber, KeyStoreData[] keyStoreDataSet) {
        int itemsPerPageInt = 5;
        int startIndex = pageNumber * itemsPerPageInt;
        int endIndex = (pageNumber + 1) * itemsPerPageInt;
        KeyStoreData[] returnedDataSet = new KeyStoreData[itemsPerPageInt];
        int i = startIndex;
        int j = 0;
        while (i < endIndex && i < keyStoreDataSet.length) {
            returnedDataSet[j] = keyStoreDataSet[i];
            ++i;
            ++j;
        }
        return returnedDataSet;
    }

    public static FlaggedName[] doFlaggedNamePaging(int pageNumber, FlaggedName[] flaggedName) {
        int itemsPerPageInt = 10;
        int startIndex = pageNumber * itemsPerPageInt;
        int endIndex = (pageNumber + 1) * itemsPerPageInt;
        FlaggedName[] returnedFlaggedNameSet = itemsPerPageInt < flaggedName.length - 1 ? new FlaggedName[itemsPerPageInt] : new FlaggedName[flaggedName.length - 1];
        int i = startIndex;
        int j = 0;
        while (i < endIndex && i < flaggedName.length - 1) {
            returnedFlaggedNameSet[j] = flaggedName[i];
            ++i;
            ++j;
        }
        return returnedFlaggedNameSet;
    }

    public static KeyStoreData[] doFilter(String filter, KeyStoreData[] keyStoreDataSet) {
        String regPattern = filter.replace("*", ".*");
        ArrayList<KeyStoreData> list = new ArrayList<KeyStoreData>();
        for (KeyStoreData keyStore : keyStoreDataSet) {
            if (keyStore == null || !keyStore.getKeyStoreName().toLowerCase().matches(regPattern.toLowerCase())) continue;
            list.add(keyStore);
        }
        return list.toArray(new KeyStoreData[list.size()]);
    }

    public static CertData[] doFilter(String filter, CertData[] certDataSet) {
        if (certDataSet == null || certDataSet.length == 0) {
            return new CertData[0];
        }
        String regPattern = filter.replace("*", ".*");
        ArrayList<CertData> list = new ArrayList<CertData>();
        for (CertData cert : certDataSet) {
            if (cert == null || !cert.getAlias().toLowerCase().matches(regPattern.toLowerCase())) continue;
            list.add(cert);
        }
        return list.toArray(new CertData[list.size()]);
    }
}

