/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSMessageReceiver;
import org.apache.axis2.transport.jms.JMSUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceTaskManager {
    private static final Log log = LogFactory.getLog(ServiceTaskManager.class);
    private static final int STATE_STOPPED = 0;
    private static final int STATE_STARTED = 1;
    private static final int STATE_PAUSED = 2;
    private static final int STATE_SHUTTING_DOWN = 3;
    private static final int STATE_FAILURE = 4;
    private String serviceName;
    private String connFactoryJNDIName;
    private String destinationJNDIName;
    private String userTransactionJNDIName = "java:comp/UserTransaction";
    private int destinationType = 0;
    private String messageSelector = null;
    private int transactionality = 0;
    private boolean sessionTransacted = true;
    private int sessionAckMode = 1;
    private boolean subscriptionDurable = false;
    private String durableSubscriberName = null;
    private boolean pubSubNoLocal = false;
    private int concurrentConsumers = 1;
    private int maxConcurrentConsumers = 1;
    private int idleTaskExecutionLimit = 10;
    private int maxMessagesPerTask = -1;
    private int receiveTimeout = 1000;
    private int cacheLevel = 5;
    private boolean cacheUserTransaction = true;
    private UserTransaction sharedUserTransaction = null;
    private String jmsSpec = "1.0.2b";
    private int initialReconnectDuration = 10000;
    private Integer consumeErrorRetryDelay = 100;
    private double reconnectionProgressionFactor = 2.0;
    private Double consumeErrorProgressionFactor = 2.0;
    private Integer maxConsumeErrorRetryBeforeDelay = 20;
    private int consumerRetryCount = 0;
    private Integer maxConsumerErrorRetryCount = -1;
    private long maxReconnectDuration = 60000L;
    private Long reconnectDuration = null;
    private Hashtable<String, String> jmsProperties = new Hashtable();
    private Context context = null;
    private ConnectionFactory conFactory = null;
    private Destination destination = null;
    private final List<MessageListenerTask> pollingTasks = Collections.synchronizedList(new ArrayList());
    private JMSMessageReceiver jmsMessageReceiver = null;
    private volatile int serviceTaskManagerState = 0;
    private AtomicInteger activeTaskCount = new AtomicInteger(0);
    private final AtomicInteger consumerCount = new AtomicInteger();
    private WorkerPool workerPool = null;
    private Connection sharedConnection = null;
    private String durableSubscriberClientId = null;
    private volatile boolean isOnExceptionError = false;
    private volatile boolean isInitalizeFailed = false;
    private boolean sharedSubscription = false;
    private boolean isThrottlingEnabled = false;
    private String throttleMode = "fixed-interval";
    private int throttleLimitPerMin = 60;

    public synchronized void start() {
        if (this.serviceTaskManagerState == 2) {
            log.info((Object)"Attempt to re-start paused TaskManager is ignored. Please use resume instead");
            return;
        }
        if (!this.pollingTasks.isEmpty()) {
            this.stop();
        }
        if (this.cacheLevel == 5) {
            this.cacheLevel = this.transactionality == 0 ? 3 : 0;
        }
        switch (this.cacheLevel) {
            case 0: {
                log.debug((Object)("No JMS resources will be cached/shared between poller worker tasks of service : " + this.serviceName));
                break;
            }
            case 1: {
                log.debug((Object)"Only the JMS Connection will be cached and shared between *all* poller task invocations");
                break;
            }
            case 2: {
                log.debug((Object)"The JMS Connection and Session will be cached and shared between successive poller task invocations");
                break;
            }
            case 3: {
                log.debug((Object)"The JMS Connection, Session and MessageConsumer will be cached and shared between successive poller task invocations");
                break;
            }
            default: {
                this.handleException("Invalid cache level : " + this.cacheLevel + " for service : " + this.serviceName);
            }
        }
        for (int i = 0; i < this.concurrentConsumers; ++i) {
            if (this.jmsMessageReceiver.getJmsListener().getState() == 2) {
                this.workerPool.execute((Runnable)new MessageListenerTask(2));
                continue;
            }
            this.workerPool.execute((Runnable)new MessageListenerTask(1));
        }
        this.serviceTaskManagerState = 1;
        log.info((Object)("Task manager for service : " + this.serviceName + " [re-]initialized"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stopping ServiceTaskManager for service : " + this.serviceName));
        }
        if (this.serviceTaskManagerState != 4) {
            this.serviceTaskManagerState = 3;
        }
        List<MessageListenerTask> list = this.pollingTasks;
        synchronized (list) {
            for (MessageListenerTask lstTask : this.pollingTasks) {
                lstTask.requestShutdown();
            }
        }
        for (int i = 0; i < 5 && this.activeTaskCount.get() != 0; ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.sharedConnection != null) {
            try {
                this.sharedConnection.close();
            }
            catch (JMSException e) {
                this.logError("Error closing shared Connection", (Exception)((Object)e));
            }
            finally {
                this.sharedConnection = null;
            }
        }
        if (this.activeTaskCount.get() > 0) {
            log.warn((Object)("Unable to shutdown all polling tasks of service : " + this.serviceName));
        }
        if (this.serviceTaskManagerState != 4) {
            this.serviceTaskManagerState = 0;
        }
        log.info((Object)("Task manager for service : " + this.serviceName + " shutdown"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void pause() {
        List<MessageListenerTask> list = this.pollingTasks;
        synchronized (list) {
            for (MessageListenerTask lstTask : this.pollingTasks) {
                lstTask.pause();
            }
        }
        if (this.sharedConnection != null) {
            try {
                this.sharedConnection.stop();
            }
            catch (JMSException e) {
                this.logError("Error pausing shared Connection", (Exception)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resume() {
        List<MessageListenerTask> list = this.pollingTasks;
        synchronized (list) {
            for (MessageListenerTask lstTask : this.pollingTasks) {
                lstTask.resume();
            }
        }
        if (this.sharedConnection != null) {
            try {
                this.sharedConnection.start();
            }
            catch (JMSException e) {
                this.logError("Error resuming shared Connection", (Exception)((Object)e));
            }
        }
    }

    public void scheduleNewTaskIfAppropriate() {
        if (this.serviceTaskManagerState == 1 && this.pollingTasks.size() < this.getMaxConcurrentConsumers() && this.getIdleTaskCount() == 0 && this.jmsMessageReceiver.getJmsListener().getState() != 2) {
            this.workerPool.execute((Runnable)new MessageListenerTask(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIdleTaskCount() {
        int count = 0;
        List<MessageListenerTask> list = this.pollingTasks;
        synchronized (list) {
            for (MessageListenerTask lstTask : this.pollingTasks) {
                if (!lstTask.isTaskIdle()) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getConnectedTaskCount() {
        int count = 0;
        List<MessageListenerTask> list = this.pollingTasks;
        synchronized (list) {
            for (MessageListenerTask lstTask : this.pollingTasks) {
                if (!lstTask.isConnected()) continue;
                ++count;
            }
        }
        return count;
    }

    private Context getInitialContext() throws NamingException {
        if (this.context == null) {
            this.context = new InitialContext();
        }
        return this.context;
    }

    private Context getInitialContext(Hashtable jmsProperties) throws NamingException {
        if (this.context == null) {
            this.context = new InitialContext(jmsProperties);
        }
        return new InitialContext(jmsProperties);
    }

    private Destination getDestination(Session session) {
        if (this.destination == null) {
            try {
                this.context = this.getInitialContext();
                this.destination = JMSUtils.lookupDestination(this.context, this.getDestinationJNDIName(), JMSUtils.getDestinationTypeAsString(this.destinationType));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("JMS Destination with JNDI name : " + this.getDestinationJNDIName() + " found for service " + this.serviceName));
                }
            }
            catch (NamingException e) {
                try {
                    switch (this.destinationType) {
                        case 1: {
                            this.destination = session.createQueue(this.getDestinationJNDIName());
                            break;
                        }
                        case 2: {
                            this.destination = session.createTopic(this.getDestinationJNDIName());
                            break;
                        }
                        default: {
                            this.handleException("Error looking up JMS destination : " + this.getDestinationJNDIName() + " using JNDI properties : " + this.jmsProperties, e);
                            break;
                        }
                    }
                }
                catch (JMSException j) {
                    this.handleException("Error looking up JMS destination and auto creating JMS destination : " + this.getDestinationJNDIName() + " using JNDI properties : " + JMSUtils.maskAxis2ConfigSensitiveParameters(this.jmsProperties), e);
                }
            }
        }
        return this.destination;
    }

    private UserTransaction getUserTransaction() {
        if (!this.cacheUserTransaction) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Acquiring a new UserTransaction for service : " + this.serviceName));
            }
            try {
                this.context = this.getInitialContext();
                return JMSUtils.lookup(this.context, UserTransaction.class, this.getUserTransactionJNDIName());
            }
            catch (NamingException e) {
                this.handleException("Error looking up UserTransaction : " + this.getUserTransactionJNDIName() + " using JNDI properties : " + JMSUtils.maskAxis2ConfigSensitiveParameters(this.jmsProperties), e);
            }
        }
        if (this.sharedUserTransaction == null) {
            try {
                this.context = this.getInitialContext();
                this.sharedUserTransaction = JMSUtils.lookup(this.context, UserTransaction.class, this.getUserTransactionJNDIName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Acquired shared UserTransaction for service : " + this.serviceName));
                }
            }
            catch (NamingException e) {
                this.handleException("Error looking up UserTransaction : " + this.getUserTransactionJNDIName() + " using JNDI properties : " + JMSUtils.maskAxis2ConfigSensitiveParameters(this.jmsProperties), e);
            }
        }
        return this.sharedUserTransaction;
    }

    private boolean isSTMActive() {
        return this.serviceTaskManagerState == 1;
    }

    public Boolean isQueue() {
        if (this.destinationType == 0) {
            return null;
        }
        return this.destinationType == 1;
    }

    private void logError(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new AxisJMSException(msg, e);
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new AxisJMSException(msg);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getConnFactoryJNDIName() {
        return this.connFactoryJNDIName;
    }

    public void setConnFactoryJNDIName(String connFactoryJNDIName) {
        this.connFactoryJNDIName = connFactoryJNDIName;
    }

    public String getDestinationJNDIName() {
        return this.destinationJNDIName;
    }

    public void setDestinationJNDIName(String destinationJNDIName) {
        this.destinationJNDIName = destinationJNDIName;
    }

    public int getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(int destinationType) {
        this.destinationType = destinationType;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public int getTransactionality() {
        return this.transactionality;
    }

    public void setTransactionality(int transactionality) {
        this.transactionality = transactionality;
        this.sessionTransacted = transactionality == 1;
    }

    public void setDurableSubscriberClientId(String durableSubscriberClientId) {
        this.durableSubscriberClientId = durableSubscriberClientId;
    }

    public String getDurableSubscriberClientId() {
        return this.durableSubscriberClientId;
    }

    public boolean isSessionTransacted() {
        return this.sessionTransacted;
    }

    public void setSessionTransacted(Boolean sessionTransacted) {
        if (sessionTransacted != null) {
            this.sessionTransacted = sessionTransacted;
        }
    }

    public int getSessionAckMode() {
        return this.sessionAckMode;
    }

    public void setSessionAckMode(int sessionAckMode) {
        this.sessionAckMode = sessionAckMode;
    }

    public boolean isSubscriptionDurable() {
        return this.subscriptionDurable;
    }

    public void setSubscriptionDurable(Boolean subscriptionDurable) {
        if (subscriptionDurable != null) {
            this.subscriptionDurable = subscriptionDurable;
        }
    }

    public String getDurableSubscriberName() {
        return this.durableSubscriberName;
    }

    public void setDurableSubscriberName(String durableSubscriberName) {
        this.durableSubscriberName = durableSubscriberName;
    }

    public boolean isShardSubscription() {
        return this.sharedSubscription;
    }

    public void setSharedSubscription(Boolean sharedSubscription) {
        if (sharedSubscription != null) {
            this.sharedSubscription = sharedSubscription;
        }
    }

    public boolean isPubSubNoLocal() {
        return this.pubSubNoLocal;
    }

    public void setPubSubNoLocal(Boolean pubSubNoLocal) {
        if (pubSubNoLocal != null) {
            this.pubSubNoLocal = pubSubNoLocal;
        }
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public int getMaxConcurrentConsumers() {
        return this.maxConcurrentConsumers;
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.maxConcurrentConsumers = maxConcurrentConsumers;
    }

    public int getIdleTaskExecutionLimit() {
        return this.idleTaskExecutionLimit;
    }

    public void setIdleTaskExecutionLimit(int idleTaskExecutionLimit) {
        this.idleTaskExecutionLimit = idleTaskExecutionLimit;
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(int receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public int getCacheLevel() {
        return this.cacheLevel;
    }

    public void setCacheLevel(int cacheLevel) {
        this.cacheLevel = cacheLevel;
    }

    public int getInitialReconnectDuration() {
        return this.initialReconnectDuration;
    }

    public void setInitialReconnectDuration(int initialReconnectDuration) {
        this.initialReconnectDuration = initialReconnectDuration;
    }

    public double getReconnectionProgressionFactor() {
        return this.reconnectionProgressionFactor;
    }

    public void setReconnectionProgressionFactor(double reconnectionProgressionFactor) {
        this.reconnectionProgressionFactor = reconnectionProgressionFactor;
    }

    public long getMaxReconnectDuration() {
        return this.maxReconnectDuration;
    }

    public void setMaxReconnectDuration(long maxReconnectDuration) {
        this.maxReconnectDuration = maxReconnectDuration;
    }

    public Long getReconnectDuration() {
        return this.reconnectDuration;
    }

    public void setReconnectDuration(Long reconnectDuration) {
        this.reconnectDuration = reconnectDuration;
    }

    public void setMaxConsumeErrorRetryBeforeDelay(Integer maxConsumeErrorRetryBeforeDelay) {
        if (maxConsumeErrorRetryBeforeDelay != null) {
            this.maxConsumeErrorRetryBeforeDelay = maxConsumeErrorRetryBeforeDelay;
        }
    }

    public void setConsumeErrorProgressionFactor(Double consumeErrorProgressionFactor) {
        if (consumeErrorProgressionFactor != null) {
            this.consumeErrorProgressionFactor = consumeErrorProgressionFactor;
        }
    }

    public void setConsumeErrorRetryDelay(Integer consumeErrorRetryDelay) {
        if (consumeErrorRetryDelay != null) {
            this.consumeErrorRetryDelay = consumeErrorRetryDelay;
        }
    }

    public void setMaxConsumerErrorRetryCount(Integer maxConsumerErrorRetryCount) {
        if (maxConsumerErrorRetryCount != null) {
            this.maxConsumerErrorRetryCount = maxConsumerErrorRetryCount;
        }
    }

    public int getMaxMessagesPerTask() {
        return this.maxMessagesPerTask;
    }

    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        this.maxMessagesPerTask = maxMessagesPerTask;
    }

    public String getUserTransactionJNDIName() {
        return this.userTransactionJNDIName;
    }

    public void setUserTransactionJNDIName(String userTransactionJNDIName) {
        if (userTransactionJNDIName != null) {
            this.userTransactionJNDIName = userTransactionJNDIName;
        }
    }

    public boolean isCacheUserTransaction() {
        return this.cacheUserTransaction;
    }

    public void setCacheUserTransaction(Boolean cacheUserTransaction) {
        if (cacheUserTransaction != null) {
            this.cacheUserTransaction = cacheUserTransaction;
        }
    }

    public String getJmsSpec() {
        return this.jmsSpec;
    }

    public void setJmsSpec(String jmsSpec) {
        this.jmsSpec = jmsSpec;
    }

    public Hashtable<String, String> getJmsProperties() {
        return this.jmsProperties;
    }

    public void addJmsProperties(Map<String, String> jmsProperties) {
        this.jmsProperties.putAll(jmsProperties);
    }

    public void removeJmsProperties(String key) {
        this.jmsProperties.remove(key);
    }

    public Context getContext() {
        return this.context;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.conFactory;
    }

    public List<MessageListenerTask> getPollingTasks() {
        return this.pollingTasks;
    }

    public void setJmsMessageReceiver(JMSMessageReceiver jmsMessageReceiver) {
        this.jmsMessageReceiver = jmsMessageReceiver;
    }

    public void setWorkerPool(WorkerPool workerPool) {
        this.workerPool = workerPool;
    }

    public int getActiveTaskCount() {
        return this.activeTaskCount.get();
    }

    public int getConsumerCount() {
        return this.consumerCount.get();
    }

    public void setServiceTaskManagerState(int serviceTaskManagerState) {
        this.serviceTaskManagerState = serviceTaskManagerState;
    }

    public boolean isThrottlingEnabled() {
        return this.isThrottlingEnabled;
    }

    public void setThrottlingEnabled(boolean throttlingEnabled) {
        this.isThrottlingEnabled = throttlingEnabled;
        if (this.isThrottlingEnabled) {
            log.info((Object)("Throttling enabled for the service " + this.serviceName));
        }
    }

    public String getThrottleMode() {
        return this.throttleMode;
    }

    public void setThrottleMode(String throttleMode) {
        this.throttleMode = throttleMode;
    }

    public int getThrottleLimitPerMin() {
        return this.throttleLimitPerMin;
    }

    public void setThrottleLimitPerMin(int throttleLimitPerMin) {
        this.throttleLimitPerMin = throttleLimitPerMin;
        log.info((Object)("Throttle limit per minute for the service " + this.serviceName + " is " + throttleLimitPerMin));
    }

    static /* synthetic */ AtomicInteger access$400(ServiceTaskManager x0) {
        return x0.activeTaskCount;
    }

    static /* synthetic */ Integer access$500(ServiceTaskManager x0) {
        return x0.consumeErrorRetryDelay;
    }

    static /* synthetic */ int access$600(ServiceTaskManager x0) {
        return x0.throttleLimitPerMin;
    }

    static /* synthetic */ int access$700(ServiceTaskManager x0) {
        return x0.transactionality;
    }

    static /* synthetic */ UserTransaction access$800(ServiceTaskManager x0) {
        return x0.getUserTransaction();
    }

    static /* synthetic */ Destination access$1000(ServiceTaskManager x0) {
        return x0.destination;
    }

    static /* synthetic */ Integer access$1100(ServiceTaskManager x0) {
        return x0.maxConsumerErrorRetryCount;
    }

    static /* synthetic */ Double access$1400(ServiceTaskManager x0) {
        return x0.consumeErrorProgressionFactor;
    }

    static /* synthetic */ boolean access$1500(ServiceTaskManager x0) {
        return x0.isThrottlingEnabled;
    }

    static /* synthetic */ String access$1600(ServiceTaskManager x0) {
        return x0.throttleMode;
    }

    static /* synthetic */ boolean access$1700(ServiceTaskManager x0) {
        return x0.isOnExceptionError;
    }

    static /* synthetic */ boolean access$1800(ServiceTaskManager x0) {
        return x0.isInitalizeFailed;
    }

    private static class ErrorRecoverTask
    implements Runnable {
        private MessageListenerTask messageListenerTask;

        public ErrorRecoverTask(MessageListenerTask messageListenerTask) {
            this.messageListenerTask = messageListenerTask;
        }

        @Override
        public void run() {
            JMSException jmsException = new JMSException("FORCED CONNECTION RESTART", "FC_ERROR");
            this.messageListenerTask.onException(jmsException);
        }
    }

    private class MessageListenerTask
    implements Runnable,
    ExceptionListener {
        private Connection connection = null;
        private Session session = null;
        private MessageConsumer consumer = null;
        private volatile int workerState = 0;
        private int idleExecutionCount = 0;
        private volatile boolean idle = false;
        private volatile boolean connected = false;
        private volatile boolean listenerPaused = false;
        private boolean connectionReceivedError = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MessageListenerTask(int listenerState) {
            List list = ServiceTaskManager.this.pollingTasks;
            synchronized (list) {
                ServiceTaskManager.this.pollingTasks.add(this);
                if (listenerState == 2) {
                    this.listenerPaused = true;
                }
            }
        }

        public void pause() {
            if (this.isActive()) {
                if (this.connection != null && ServiceTaskManager.this.cacheLevel < 1) {
                    try {
                        this.connection.stop();
                    }
                    catch (JMSException e) {
                        log.warn((Object)("Error pausing Message Listener task for service : " + ServiceTaskManager.this.serviceName));
                    }
                }
                this.workerState = 2;
                this.listenerPaused = true;
            }
        }

        public void resume() {
            if (this.connection != null && ServiceTaskManager.this.cacheLevel < 1) {
                try {
                    this.connection.start();
                }
                catch (JMSException e) {
                    log.warn((Object)("Error resuming Message Listener task for service : " + ServiceTaskManager.this.serviceName));
                }
            }
            this.workerState = 1;
            this.listenerPaused = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.workerState = 1;
            ServiceTaskManager.access$400(ServiceTaskManager.this).getAndIncrement();
            messageCount = 0;
            retryDurationOnConsumerFailure = ServiceTaskManager.access$500(ServiceTaskManager.this).intValue();
            consumedMessageCountPerMin = 0;
            throttleSleepDelay = 60000L / (long)ServiceTaskManager.access$600(ServiceTaskManager.this);
            consumptionStartedTime = 0L;
            if (ServiceTaskManager.access$300().isDebugEnabled()) {
                ServiceTaskManager.access$300().debug((Object)("New poll task starting : thread id = " + Thread.currentThread().getId()));
            }
            if (this.listenerPaused) {
                this.workerState = 2;
            }
            ServiceTaskManager.access$300().info((Object)("JMS Polling task activated with state: " + this.workerState + " for service " + ServiceTaskManager.access$200(ServiceTaskManager.this)));
lbl14:
            // 3 sources

            try {
                block38: while (this.isActive() != false) {
                    block61: {
                        if (ServiceTaskManager.this.getMaxMessagesPerTask() >= 0) {
                            if (messageCount >= ServiceTaskManager.this.getMaxMessagesPerTask()) return;
                        }
                        if (ServiceTaskManager.this.getConcurrentConsumers() != 1) {
                            if (this.idleExecutionCount >= ServiceTaskManager.this.getIdleTaskExecutionLimit()) return;
                        }
                        ut /* !! */  = null;
                        try {
                            if (ServiceTaskManager.access$700(ServiceTaskManager.this) == 2 && (ut /* !! */  = ServiceTaskManager.access$800(ServiceTaskManager.this)).getStatus() == 6) {
                                ut /* !! */ .begin();
                            }
                        }
                        catch (NotSupportedException e) {
                            ServiceTaskManager.access$900(ServiceTaskManager.this, "Listener Task is already associated with a transaction", (Exception)e);
                        }
                        catch (SystemException e) {
                            ServiceTaskManager.access$900(ServiceTaskManager.this, "Error starting a JTA transaction", (Exception)e);
                        }
                        message = this.receiveMessage();
                        if (ServiceTaskManager.access$300().isTraceEnabled()) {
                            if (message != null) {
                                try {
                                    ServiceTaskManager.access$300().trace((Object)("<<<<<<< READ message with Message ID : " + message.getJMSMessageID() + " from : " + ServiceTaskManager.access$1000(ServiceTaskManager.this) + " by Thread ID : " + Thread.currentThread().getId()));
                                }
                                catch (JMSException var11_18) {}
                            } else {
                                ServiceTaskManager.access$300().trace((Object)("No message received by Thread ID : " + Thread.currentThread().getId() + " for destination : " + ServiceTaskManager.access$1000(ServiceTaskManager.this)));
                            }
                        }
                        if (ServiceTaskManager.access$1100(ServiceTaskManager.this) != -1 && ServiceTaskManager.access$1200(ServiceTaskManager.this) > ServiceTaskManager.access$1100(ServiceTaskManager.this)) {
                            ServiceTaskManager.access$300().warn((Object)("Creating a Forced Error Recovery task for Connection level recovery for the service : " + ServiceTaskManager.access$200(ServiceTaskManager.this)));
                            errorRecoverTask = new ErrorRecoverTask(this);
                            errorRecoverThread = new Thread(errorRecoverTask);
                            errorRecoverThread.setName("JMSForcedErrorRecoveryThread-" + errorRecoverThread.getId());
                            errorRecoverThread.start();
                        }
                        if (this.connectionReceivedError && ServiceTaskManager.access$1300(ServiceTaskManager.this) < ServiceTaskManager.access$1200(ServiceTaskManager.this)) {
                            try {
                                Thread.sleep(retryDurationOnConsumerFailure);
                            }
                            catch (InterruptedException var11_19) {
                                // empty catch block
                            }
                            retryDurationOnConsumerFailure = (long)((double)retryDurationOnConsumerFailure * ServiceTaskManager.access$1400(ServiceTaskManager.this));
                            ServiceTaskManager.access$300().info((Object)("Error while consuming message from service : " + ServiceTaskManager.access$200(ServiceTaskManager.this) + ". Next retry in " + retryDurationOnConsumerFailure / 1000L + " seconds"));
                        } else {
                            retryDurationOnConsumerFailure = ServiceTaskManager.access$500(ServiceTaskManager.this).intValue();
                        }
                        if (message == null) break block61;
                        this.idle = false;
                        this.idleExecutionCount = 0;
                        ++messageCount;
                        ServiceTaskManager.this.scheduleNewTaskIfAppropriate();
                        this.handleMessage(message, ut /* !! */ );
                        if (!ServiceTaskManager.access$1500(ServiceTaskManager.this)) continue;
                        var11_17 = ServiceTaskManager.access$1600(ServiceTaskManager.this);
                        var12_21 = -1;
                        switch (var11_17.hashCode()) {
                            case -900488450: {
                                if (!var11_17.equals("fixed-interval")) break;
                                var12_21 = 0;
                                break;
                            }
                            case 93509434: {
                                if (!var11_17.equals("batch")) break;
                                var12_21 = 1;
                                break;
                            }
                        }
                        switch (var12_21) {
                            case 0: {
                                if (ServiceTaskManager.access$300().isDebugEnabled()) {
                                    ServiceTaskManager.access$300().debug((Object)("Sleeping " + throttleSleepDelay + " ms with Fixed-Interval throttling for service :" + ServiceTaskManager.access$200(ServiceTaskManager.this)));
                                }
                                Thread.sleep(throttleSleepDelay);
                                ** GOTO lbl14
                            }
                            case 1: {
                                if (consumedMessageCountPerMin == 0) {
                                    consumptionStartedTime = System.currentTimeMillis();
                                    if (ServiceTaskManager.access$300().isDebugEnabled()) {
                                        ServiceTaskManager.access$300().debug((Object)("Batch throttling started at " + consumptionStartedTime + " for service :" + ServiceTaskManager.access$200(ServiceTaskManager.this)));
                                    }
                                }
                                if (++consumedMessageCountPerMin >= ServiceTaskManager.access$600(ServiceTaskManager.this)) {
                                    consumptionDuration = System.currentTimeMillis() - consumptionStartedTime;
                                    if (consumptionDuration < 60000L) {
                                        sleepDuration = 60000L - consumptionDuration;
                                        Thread.sleep(sleepDuration);
                                        if (ServiceTaskManager.access$300().isDebugEnabled()) {
                                            ServiceTaskManager.access$300().debug((Object)("After consuming " + consumedMessageCountPerMin + " per minute, Thread is sleeping for " + sleepDuration + " milli seconds"));
                                        }
                                    }
                                    consumedMessageCountPerMin = 0;
                                }
                                if (!ServiceTaskManager.access$300().isDebugEnabled()) continue block38;
                                ServiceTaskManager.access$300().debug((Object)("consumed Message Count per min:  " + consumedMessageCountPerMin));
                                ** GOTO lbl14
                            }
                        }
                        throw new AxisJMSException("Invalid Throttling mode " + ServiceTaskManager.access$1600(ServiceTaskManager.this) + "specified for service : " + ServiceTaskManager.access$200(ServiceTaskManager.this));
                    }
                    this.idle = true;
                    ++this.idleExecutionCount;
                }
                return;
            }
            catch (AxisJMSException e) {
                ServiceTaskManager.access$300().error((Object)"Error receiving the message.", (Throwable)e);
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                ServiceTaskManager.access$300().error((Object)("Error in sleeping with " + ServiceTaskManager.access$1600(ServiceTaskManager.this) + " throttling"), (Throwable)e);
                return;
            }
            finally {
                ServiceTaskManager.access$300().info((Object)("JMS Polling server task stopped for service " + ServiceTaskManager.access$200(ServiceTaskManager.this) + " " + this));
                if (ServiceTaskManager.access$300().isTraceEnabled()) {
                    ServiceTaskManager.access$300().trace((Object)("Listener task with Thread ID : " + Thread.currentThread().getId() + " is stopping after processing : " + messageCount + " messages ::  isActive : " + this.isActive() + " maxMessagesPerTask : " + ServiceTaskManager.this.getMaxMessagesPerTask() + " concurrentConsumers : " + ServiceTaskManager.this.getConcurrentConsumers() + " idleExecutionCount : " + this.idleExecutionCount + " idleTaskExecutionLimit : " + ServiceTaskManager.this.getIdleTaskExecutionLimit()));
                } else if (ServiceTaskManager.access$300().isDebugEnabled()) {
                    ServiceTaskManager.access$300().debug((Object)("Listener task with Thread ID : " + Thread.currentThread().getId() + " is stopping after processing : " + messageCount + " messages"));
                }
                this.closeConsumer(true);
                this.closeSession(true);
                this.closeConnection();
                this.workerState = 0;
                ServiceTaskManager.access$400(ServiceTaskManager.this).getAndDecrement();
                e = ServiceTaskManager.access$000(ServiceTaskManager.this);
                synchronized (e) {
                    ServiceTaskManager.access$000(ServiceTaskManager.this).remove(this);
                    ** if (ServiceTaskManager.access$1700((ServiceTaskManager)ServiceTaskManager.this) && !this.connectionReceivedError) goto lbl133
                }
lbl-1000:
                // 1 sources

                {
                    if (ServiceTaskManager.access$1800(ServiceTaskManager.this) && ServiceTaskManager.access$1900(ServiceTaskManager.this) != null) {
                        try {
                            Thread.sleep(ServiceTaskManager.access$1900(ServiceTaskManager.this));
                        }
                        catch (InterruptedException e) {}
                        ServiceTaskManager.access$300().info((Object)("Retry in " + ServiceTaskManager.access$1900(ServiceTaskManager.this) / 1000L + " Seconds."));
                    }
                    ServiceTaskManager.this.scheduleNewTaskIfAppropriate();
                }
lbl133:
                // 2 sources

            }
        }

        private Message receiveMessage() {
            this.connectionReceivedError = false;
            if (this.consumer == null) {
                this.connection = this.getConnection();
                this.session = this.getSession();
                this.consumer = this.getMessageConsumer();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Preparing a Connection, Session and Consumer to read messages");
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Waiting for a message for service : " + ServiceTaskManager.this.serviceName + " - duration : " + (ServiceTaskManager.this.getReceiveTimeout() < 0 ? "unlimited" : ServiceTaskManager.this.getReceiveTimeout() + "ms")));
            }
            try {
                if (ServiceTaskManager.this.getReceiveTimeout() < 0) {
                    Message msg = this.consumer.receive();
                    ServiceTaskManager.this.consumerRetryCount = 0;
                    return msg;
                }
                Message msg = this.consumer.receive((long)ServiceTaskManager.this.getReceiveTimeout());
                ServiceTaskManager.this.consumerRetryCount = 0;
                return msg;
            }
            catch (IllegalStateException msg) {
            }
            catch (JMSException e) {
                this.connectionReceivedError = true;
                ServiceTaskManager.this.consumerRetryCount++;
                if (ServiceTaskManager.this.consumerRetryCount <= ServiceTaskManager.this.maxConsumeErrorRetryBeforeDelay) {
                    log.warn((Object)("Could not consume message from: " + ServiceTaskManager.this.serviceName + ". Expect " + (ServiceTaskManager.this.maxConsumeErrorRetryBeforeDelay - ServiceTaskManager.this.consumerRetryCount) + " more retries before exponential sleep!"));
                }
                ServiceTaskManager.this.logError("Error receiving message for service : " + ServiceTaskManager.this.serviceName, (Exception)((Object)e));
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMessage(Message message, UserTransaction ut) {
            boolean commitOrAck;
            String messageId;
            block49: {
                block50: {
                    messageId = null;
                    try {
                        messageId = message.getJMSMessageID();
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                    commitOrAck = true;
                    try {
                        commitOrAck = ServiceTaskManager.this.jmsMessageReceiver.onMessage(message, ut);
                        if (ServiceTaskManager.this.getSessionAckMode() != 2) break block49;
                        if (!commitOrAck) break block50;
                    }
                    catch (Throwable throwable) {
                        if (ServiceTaskManager.this.getSessionAckMode() == 2) {
                            if (commitOrAck) {
                                try {
                                    message.acknowledge();
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("Message : " + messageId + " acknowledged"));
                                    }
                                }
                                catch (JMSException e) {
                                    ServiceTaskManager.this.logError("Error acknowledging message : " + messageId, (Exception)((Object)e));
                                }
                            } else if (ServiceTaskManager.this.cacheLevel >= 2) {
                                try {
                                    this.session.recover();
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("Session is recovered due to failure of mediation of message: " + messageId));
                                    }
                                }
                                catch (JMSException e) {
                                    ServiceTaskManager.this.logError("Error recovering the JMS session", (Exception)((Object)e));
                                }
                            }
                        }
                        try {
                            if (this.session.getTransacted()) {
                                if (commitOrAck) {
                                    this.session.commit();
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("Session for message : " + messageId + " committed"));
                                    }
                                } else {
                                    this.session.rollback();
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("Session for message : " + messageId + " rolled back"));
                                    }
                                }
                            }
                        }
                        catch (JMSException e) {
                            ServiceTaskManager.this.logError("Error " + (commitOrAck ? "committing" : "rolling back") + " local session txn for message : " + messageId, (Exception)((Object)e));
                        }
                        try {
                            if (ut != null) {
                                if (commitOrAck) {
                                    ut.commit();
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("JTA txn for message : " + messageId + " committed"));
                                    }
                                } else {
                                    ut.rollback();
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("JTA txn for message : " + messageId + " rolled back"));
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            ServiceTaskManager.this.logError("Error " + (commitOrAck ? "committing" : "rolling back") + " JTA txn for message : " + messageId + " from the session", e);
                        }
                        this.closeConsumer(false);
                        this.closeSession(false);
                        this.closeConnection();
                        throw throwable;
                    }
                    try {
                        message.acknowledge();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Message : " + messageId + " acknowledged"));
                        }
                        break block49;
                    }
                    catch (JMSException e) {
                        ServiceTaskManager.this.logError("Error acknowledging message : " + messageId, (Exception)((Object)e));
                    }
                    break block49;
                }
                if (ServiceTaskManager.this.cacheLevel >= 2) {
                    try {
                        this.session.recover();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Session is recovered due to failure of mediation of message: " + messageId));
                        }
                    }
                    catch (JMSException e) {
                        ServiceTaskManager.this.logError("Error recovering the JMS session", (Exception)((Object)e));
                    }
                }
            }
            try {
                if (this.session.getTransacted()) {
                    if (commitOrAck) {
                        this.session.commit();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Session for message : " + messageId + " committed"));
                        }
                    } else {
                        this.session.rollback();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Session for message : " + messageId + " rolled back"));
                        }
                    }
                }
            }
            catch (JMSException e) {
                ServiceTaskManager.this.logError("Error " + (commitOrAck ? "committing" : "rolling back") + " local session txn for message : " + messageId, (Exception)((Object)e));
            }
            try {
                if (ut != null) {
                    if (commitOrAck) {
                        ut.commit();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("JTA txn for message : " + messageId + " committed"));
                        }
                    } else {
                        ut.rollback();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("JTA txn for message : " + messageId + " rolled back"));
                        }
                    }
                }
            }
            catch (Exception e) {
                ServiceTaskManager.this.logError("Error " + (commitOrAck ? "committing" : "rolling back") + " JTA txn for message : " + messageId + " from the session", e);
            }
            this.closeConsumer(false);
            this.closeSession(false);
            this.closeConnection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onException(JMSException j) {
            ServiceTaskManager.this.isOnExceptionError = true;
            if (!ServiceTaskManager.this.isSTMActive()) {
                this.requestShutdown();
                return;
            }
            this.setConnected(false);
            if (ServiceTaskManager.this.cacheLevel < 1) {
                log.warn((Object)("JMS Connection failure : " + j.getMessage()));
                this.requestShutdown();
                return;
            }
            ServiceTaskManager.this.setServiceTaskManagerState(4);
            log.error((Object)("JMS Connection failed : " + j.getMessage() + " - shutting down worker tasks"));
            int r = 1;
            long retryDuration = ServiceTaskManager.this.initialReconnectDuration;
            boolean connected = false;
            do {
                try {
                    log.info((Object)("Reconnection attempt : " + r + " for service : " + ServiceTaskManager.this.serviceName));
                    ServiceTaskManager.this.start();
                }
                catch (Throwable i) {
                }
                finally {
                    for (int i = 0; i < 5; ++i) {
                        if (ServiceTaskManager.this.getConnectedTaskCount() == ServiceTaskManager.this.concurrentConsumers) {
                            connected = true;
                            break;
                        }
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (!connected) {
                        if (ServiceTaskManager.this.reconnectDuration != null) {
                            retryDuration = ServiceTaskManager.this.reconnectDuration;
                            log.error((Object)("Reconnection attempt : " + r++ + " for service : " + ServiceTaskManager.this.serviceName + " failed. Next retry in " + retryDuration / 1000L + " seconds. (Fixed Interval)"));
                        } else {
                            if ((retryDuration = (long)((double)retryDuration * ServiceTaskManager.this.reconnectionProgressionFactor)) > ServiceTaskManager.this.maxReconnectDuration) {
                                retryDuration = ServiceTaskManager.this.maxReconnectDuration;
                                log.info((Object)"InitialReconnectDuration reached to MaxReconnectDuration.");
                            }
                            log.error((Object)("Reconnection attempt : " + r++ + " for service : " + ServiceTaskManager.this.serviceName + " failed. Next retry in " + retryDuration / 1000L + " seconds"));
                        }
                        try {
                            Thread.sleep(retryDuration);
                            if (ServiceTaskManager.this.getConnectedTaskCount() == ServiceTaskManager.this.concurrentConsumers) {
                                connected = true;
                                ServiceTaskManager.this.isOnExceptionError = false;
                                log.info((Object)("Reconnection attempt: " + r + " for service: " + ServiceTaskManager.this.serviceName + " was successful!"));
                            }
                        }
                        catch (InterruptedException i) {}
                    } else {
                        ServiceTaskManager.this.isOnExceptionError = false;
                        log.info((Object)("Reconnection attempt: " + r + " for service: " + ServiceTaskManager.this.serviceName + " was successful!"));
                    }
                }
            } while (!ServiceTaskManager.this.isSTMActive() || !connected);
        }

        protected void requestShutdown() {
            this.workerState = 3;
        }

        private boolean isActive() {
            return this.workerState == 1;
        }

        protected boolean isTaskIdle() {
            return this.idle;
        }

        public boolean isConnected() {
            return this.connected;
        }

        public void setConnected(boolean connected) {
            this.connected = connected;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Connection getConnection() {
            if (ServiceTaskManager.this.cacheLevel < 1) {
                if (this.connection == null) {
                    this.connection = this.createConnection();
                    this.setConnected(true);
                }
            } else if (this.connection == null) {
                ServiceTaskManager serviceTaskManager = ServiceTaskManager.this;
                synchronized (serviceTaskManager) {
                    if (ServiceTaskManager.this.sharedConnection == null) {
                        ServiceTaskManager.this.sharedConnection = this.createConnection();
                    }
                }
                this.connection = ServiceTaskManager.this.sharedConnection;
                this.setConnected(true);
            }
            return this.connection;
        }

        private Session getSession() {
            if (this.session == null || ServiceTaskManager.this.cacheLevel < 2) {
                this.session = this.createSession();
            }
            return this.session;
        }

        private MessageConsumer getMessageConsumer() {
            if (this.consumer == null || ServiceTaskManager.this.cacheLevel < 3) {
                this.consumer = this.createConsumer();
            }
            return this.consumer;
        }

        private void closeConnection() {
            if (this.connection != null && ServiceTaskManager.this.cacheLevel < 1) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Closing non-shared JMS connection for service : " + ServiceTaskManager.this.serviceName));
                    }
                    this.connection.close();
                }
                catch (JMSException e) {
                    ServiceTaskManager.this.logError("Error closing JMS connection", (Exception)((Object)e));
                }
                finally {
                    this.connection = null;
                }
            }
        }

        private void closeSession(boolean forced) {
            if (this.session != null && (ServiceTaskManager.this.cacheLevel < 2 || forced)) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Closing non-shared JMS session for service : " + ServiceTaskManager.this.serviceName));
                    }
                    this.session.close();
                }
                catch (JMSException e) {
                    ServiceTaskManager.this.logError("Error closing JMS session", (Exception)((Object)e));
                }
                finally {
                    this.session = null;
                }
            }
        }

        private void closeConsumer(boolean forced) {
            if (this.consumer != null && (ServiceTaskManager.this.cacheLevel < 3 || forced)) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Closing non-shared JMS consumer for service : " + ServiceTaskManager.this.serviceName));
                    }
                    ServiceTaskManager.this.consumerCount.decrementAndGet();
                    this.consumer.close();
                }
                catch (JMSException e) {
                    ServiceTaskManager.this.logError("Error closing JMS consumer", (Exception)((Object)e));
                }
                finally {
                    this.consumer = null;
                }
            }
        }

        private Connection createConnection() {
            try {
                ServiceTaskManager.this.conFactory = JMSUtils.lookup(ServiceTaskManager.this.getInitialContext(ServiceTaskManager.this.jmsProperties), ConnectionFactory.class, ServiceTaskManager.this.getConnFactoryJNDIName());
                log.debug((Object)("Connected to the JMS connection factory : " + ServiceTaskManager.this.getConnFactoryJNDIName()));
            }
            catch (NamingException e) {
                ServiceTaskManager.this.handleException("Error looking up connection factory : " + ServiceTaskManager.this.getConnFactoryJNDIName() + " using JNDI properties : " + JMSUtils.maskAxis2ConfigSensitiveParameters(ServiceTaskManager.this.jmsProperties), e);
            }
            Connection connection = null;
            ServiceTaskManager.this.isInitalizeFailed = false;
            try {
                connection = JMSUtils.createConnection(ServiceTaskManager.this.conFactory, (String)ServiceTaskManager.this.jmsProperties.get("transport.jms.UserName"), (String)ServiceTaskManager.this.jmsProperties.get("transport.jms.Password"), ServiceTaskManager.this.getJmsSpec(), ServiceTaskManager.this.isQueue(), ServiceTaskManager.this.isSubscriptionDurable(), ServiceTaskManager.this.durableSubscriberClientId, ServiceTaskManager.this.isShardSubscription());
                connection.setExceptionListener((ExceptionListener)this);
                connection.start();
                log.debug((Object)("JMS Connection for service : " + ServiceTaskManager.this.serviceName + " created and started"));
            }
            catch (JMSException e) {
                ServiceTaskManager.this.isInitalizeFailed = true;
                String msg = "Error acquiring a JMS connection to : " + ServiceTaskManager.this.getConnFactoryJNDIName() + " using JNDI properties : " + JMSUtils.maskAxis2ConfigSensitiveParameters(ServiceTaskManager.this.jmsProperties) + ". " + e.getMessage();
                if (log.isDebugEnabled()) {
                    log.error((Object)msg, (Throwable)e);
                } else {
                    log.error((Object)msg);
                }
                throw new AxisJMSException(msg, (Exception)((Object)e));
            }
            return connection;
        }

        private Session createSession() {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating a new JMS Session for service : " + ServiceTaskManager.this.serviceName));
                }
                return JMSUtils.createSession(this.connection, ServiceTaskManager.this.isSessionTransacted(), ServiceTaskManager.this.getSessionAckMode(), ServiceTaskManager.this.getJmsSpec(), ServiceTaskManager.this.isQueue());
            }
            catch (JMSException e) {
                try {
                    if (this.connection != null) {
                        this.connection.close();
                    }
                    if (ServiceTaskManager.this.sharedConnection != null) {
                        ServiceTaskManager.this.sharedConnection.close();
                    }
                }
                catch (JMSException ex) {
                    log.error((Object)"Error while shutting down the connection : ", (Throwable)ex);
                }
                finally {
                    this.connection = null;
                    ServiceTaskManager.this.sharedConnection = null;
                }
                ServiceTaskManager.this.handleException("Error creating JMS session for service : " + ServiceTaskManager.this.serviceName, (Exception)((Object)e));
                return null;
            }
        }

        private MessageConsumer createConsumer() {
            ServiceTaskManager.this.isInitalizeFailed = false;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating a new JMS MessageConsumer for service : " + ServiceTaskManager.this.serviceName));
                }
                MessageConsumer consumer = JMSUtils.createConsumer(this.session, ServiceTaskManager.this.getDestination(this.session), ServiceTaskManager.this.isQueue(), (ServiceTaskManager.this.isSubscriptionDurable() || ServiceTaskManager.this.isShardSubscription()) && ServiceTaskManager.this.getDurableSubscriberName() != null ? ServiceTaskManager.this.getDurableSubscriberName() : ServiceTaskManager.this.serviceName, ServiceTaskManager.this.getMessageSelector(), ServiceTaskManager.this.isPubSubNoLocal(), ServiceTaskManager.this.isSubscriptionDurable(), ServiceTaskManager.this.getJmsSpec(), ServiceTaskManager.this.isShardSubscription());
                ServiceTaskManager.this.consumerCount.incrementAndGet();
                return consumer;
            }
            catch (JMSException e) {
                ServiceTaskManager.this.isInitalizeFailed = true;
                String msg = "Error creating JMS consumer for service : " + ServiceTaskManager.this.serviceName + ". " + e.getMessage();
                if (log.isDebugEnabled()) {
                    log.error((Object)msg, (Throwable)e);
                } else {
                    log.error((Object)msg);
                }
                throw new AxisJMSException(msg, (Exception)((Object)e));
            }
        }

        public String toString() {
            return "MessageListenerTask{workerState=" + this.workerState + ", idleExecutionCount=" + this.idleExecutionCount + ", idle=" + this.idle + ", connected=" + this.connected + ", listenerPaused=" + this.listenerPaused + ", connectionReceivedError=" + this.connectionReceivedError + '}';
        }
    }
}

