/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import javax.transaction.xa.Xid;
import org.apache.axis2.transport.jms.Base64;

public class JMSXid
implements Xid {
    private static final long serialVersionUID = 407053232840068514L;
    private final byte[] branchQualifier;
    private final int formatId;
    private final byte[] globalTransactionId;
    private int hash;
    private boolean hashCalculated;

    public static String toBase64String(Xid xid) {
        return Base64.encodeBytes(JMSXid.toByteArray(xid));
    }

    private static byte[] toByteArray(Xid xid) {
        byte[] branchQualifier = xid.getBranchQualifier();
        byte[] globalTransactionId = xid.getGlobalTransactionId();
        int formatId = xid.getFormatId();
        byte[] hashBytes = new byte[branchQualifier.length + globalTransactionId.length + 4];
        System.arraycopy(branchQualifier, 0, hashBytes, 0, branchQualifier.length);
        System.arraycopy(globalTransactionId, 0, hashBytes, branchQualifier.length, globalTransactionId.length);
        byte[] intBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            intBytes[i] = (byte)((formatId >> i * 8) % 255);
        }
        System.arraycopy(intBytes, 0, hashBytes, branchQualifier.length + globalTransactionId.length, 4);
        return hashBytes;
    }

    public JMSXid(byte[] branchQualifier, int formatId, byte[] globalTransactionId) {
        this.branchQualifier = branchQualifier;
        this.formatId = formatId;
        this.globalTransactionId = globalTransactionId;
    }

    public JMSXid(Xid other) {
        this.branchQualifier = this.copyBytes(other.getBranchQualifier());
        this.formatId = other.getFormatId();
        this.globalTransactionId = this.copyBytes(other.getGlobalTransactionId());
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    public int hashCode() {
        if (!this.hashCalculated) {
            this.calcHash();
        }
        return this.hash;
    }

    public boolean equals(Object other) {
        int i;
        if (this == other) {
            return true;
        }
        if (!(other instanceof Xid)) {
            return false;
        }
        Xid xother = (Xid)other;
        if (xother.getFormatId() != this.formatId) {
            return false;
        }
        if (xother.getBranchQualifier().length != this.branchQualifier.length) {
            return false;
        }
        if (xother.getGlobalTransactionId().length != this.globalTransactionId.length) {
            return false;
        }
        for (i = 0; i < this.branchQualifier.length; ++i) {
            byte[] otherBQ = xother.getBranchQualifier();
            if (this.branchQualifier[i] == otherBQ[i]) continue;
            return false;
        }
        for (i = 0; i < this.globalTransactionId.length; ++i) {
            byte[] otherGtx = xother.getGlobalTransactionId();
            if (this.globalTransactionId[i] == otherGtx[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "XidImpl (" + System.identityHashCode(this) + " bq:" + this.stringRep(this.branchQualifier) + " formatID:" + this.formatId + " gtxid:" + this.stringRep(this.globalTransactionId);
    }

    private String stringRep(byte[] bytes) {
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            buff.append(b);
            if (i == bytes.length - 1) continue;
            buff.append('.');
        }
        return buff.toString();
    }

    private void calcHash() {
        byte[] hashBytes = JMSXid.toByteArray(this);
        String s = new String(hashBytes);
        this.hash = s.hashCode();
        this.hashCalculated = true;
    }

    private byte[] copyBytes(byte[] other) {
        byte[] bytes = new byte[other.length];
        System.arraycopy(other, 0, bytes, 0, other.length);
        return bytes;
    }
}

