/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.activation.DataHandler;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.base.AbstractTransportSender;
import org.apache.axis2.transport.base.BaseConstants;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.base.ManagementSupport;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSConnectionFactory;
import org.apache.axis2.transport.jms.JMSConnectionFactoryManager;
import org.apache.axis2.transport.jms.JMSConstants;
import org.apache.axis2.transport.jms.JMSMessageSender;
import org.apache.axis2.transport.jms.JMSOutTransportInfo;
import org.apache.axis2.transport.jms.JMSReplyMessage;
import org.apache.axis2.transport.jms.JMSUtils;
import org.apache.axis2.transport.jms.iowrappers.BytesMessageOutputStream;
import org.apache.axis2.util.MessageProcessorSelector;
import org.apache.commons.io.output.WriterOutputStream;
import org.wso2.securevault.SecretResolver;

public class JMSSender
extends AbstractTransportSender
implements ManagementSupport {
    public static final String TRANSPORT_NAME = "jms";
    private static Map<Transaction, ArrayList<JMSMessageSender>> jmsMessageSenderMap = new HashMap<Transaction, ArrayList<JMSMessageSender>>();
    private JMSConnectionFactoryManager connFacManager;

    public void init(ConfigurationContext cfgCtx, TransportOutDescription transportOut) throws AxisFault {
        super.init(cfgCtx, transportOut);
        SecretResolver secretResolver = cfgCtx.getAxisConfiguration().getSecretResolver();
        this.connFacManager = new JMSConnectionFactoryManager((ParameterInclude)transportOut, secretResolver);
        this.log.info((Object)"JMS Transport Sender initialized...");
    }

    public void stop() {
        this.connFacManager.stop();
        super.stop();
    }

    private JMSConnectionFactory getJMSConnectionFactory(JMSOutTransportInfo trpInfo) {
        Hashtable<String, String> props = trpInfo.getProperties();
        if (trpInfo.getProperties() != null) {
            String jmsConnectionFactoryName = (String)props.get("transport.jms.ConnectionFactory");
            this.log.debug((Object)("Using Connection factory:" + jmsConnectionFactoryName));
            if (jmsConnectionFactoryName != null) {
                this.log.debug((Object)"transport.jms.ConnectionFactory is used");
                return this.connFacManager.getJMSConnectionFactory(jmsConnectionFactoryName);
            }
            JMSConnectionFactory fac = this.connFacManager.getJMSConnectionFactory(props);
            if (fac == null) {
                fac = this.connFacManager.getJMSConnectionFactory("default");
                this.log.debug((Object)"Connection factory has been initialized");
            } else {
                this.log.debug((Object)"Connection factory has been re-used");
            }
            return fac;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(MessageContext msgCtx, String targetAddress, OutTransportInfo outTransportInfo) throws AxisFault {
        JMSMessageSender messageSender;
        JMSOutTransportInfo jmsOut;
        JMSConnectionFactory jmsConnectionFactory;
        block30: {
            jmsConnectionFactory = null;
            jmsOut = null;
            messageSender = null;
            if (targetAddress != null) {
                jmsOut = new JMSOutTransportInfo(targetAddress);
                jmsConnectionFactory = this.getJMSConnectionFactory(jmsOut);
                if (jmsConnectionFactory == null) {
                    jmsConnectionFactory = this.connFacManager.getConnectionFactoryFromTargetEndpoint(targetAddress);
                }
                if (targetAddress.contains("transport.jms.TransactionCommand")) {
                    try {
                        ArrayList<Object> list;
                        messageSender = jmsOut.createJMSSender(msgCtx);
                        Transaction transaction = (Transaction)msgCtx.getProperty("distributedTx");
                        if (jmsMessageSenderMap.get(transaction) == null) {
                            list = new ArrayList<JMSMessageSender>();
                            list.add(messageSender);
                            jmsMessageSenderMap.put(transaction, list);
                            break block30;
                        }
                        list = jmsMessageSenderMap.get(transaction);
                        list.add(messageSender);
                        jmsMessageSenderMap.put(transaction, list);
                    }
                    catch (JMSException e) {
                        this.rollbackIfXATransaction(msgCtx);
                        this.handleException("Unable to create a JMSMessageSender for : " + outTransportInfo, (Exception)((Object)e));
                    }
                } else {
                    messageSender = new JMSMessageSender(jmsConnectionFactory, targetAddress);
                }
            } else if (outTransportInfo instanceof JMSOutTransportInfo) {
                jmsOut = (JMSOutTransportInfo)outTransportInfo;
                try {
                    messageSender = jmsOut.createJMSSender(msgCtx);
                }
                catch (JMSException e) {
                    this.handleException("Unable to create a JMSMessageSender for : " + outTransportInfo, (Exception)((Object)e));
                }
            }
        }
        String contentTypeProperty = this.getContentTypeProperty(msgCtx, jmsOut, jmsConnectionFactory);
        String hyphenSupport = "none";
        if (jmsConnectionFactory != null && jmsConnectionFactory.getParameters().get("transport.jms.MessagePropertyHyphens") != null) {
            hyphenSupport = jmsConnectionFactory.getParameters().get("transport.jms.MessagePropertyHyphens");
        } else if (jmsOut.getProperties() != null && jmsOut.getProperties().get("transport.jms.MessagePropertyHyphens") != null) {
            if (jmsOut.getProperties().get("transport.jms.MessagePropertyHyphens").equals("replace")) {
                hyphenSupport = "replace";
            } else if (jmsOut.getProperties().get("transport.jms.MessagePropertyHyphens").equals("delete")) {
                hyphenSupport = "delete";
            }
        }
        msgCtx.setProperty("transport.jms.MessagePropertyHyphens", (Object)hyphenSupport);
        JMSReplyMessage jmsReplyMessage = null;
        Session session = messageSender.getSession();
        synchronized (session) {
            try {
                jmsReplyMessage = this.sendOverJMS(msgCtx, messageSender, contentTypeProperty, jmsConnectionFactory, jmsOut);
            }
            finally {
                if (msgCtx.getProperty("distributedTxMgr") == null) {
                    messageSender.close();
                    if (jmsReplyMessage.getReplyDestination() instanceof TemporaryQueue) {
                        String temporaryQueueName = "";
                        TemporaryQueue temporaryQueue = (TemporaryQueue)jmsReplyMessage.getReplyDestination();
                        try {
                            temporaryQueueName = temporaryQueue.getQueueName();
                            temporaryQueue.delete();
                        }
                        catch (JMSException e) {
                            this.log.error((Object)("Error while deleting the temporary queue " + temporaryQueueName), (Throwable)e);
                        }
                    }
                }
            }
        }
        if (jmsReplyMessage.getMsgctx() != null) {
            this.handleIncomingMessage(jmsReplyMessage.getMsgctx(), jmsReplyMessage.getTransportHeaders(), jmsReplyMessage.getSoapAction(), jmsReplyMessage.getContentType());
        }
    }

    private void rollbackIfXATransaction(MessageContext msgCtx) throws AxisFault {
        Transaction transaction = null;
        try {
            if (msgCtx.getProperty("distributedTxMgr") != null) {
                transaction = ((TransactionManager)msgCtx.getProperty("distributedTxMgr")).getTransaction();
                this.rollbackXATransaction(transaction);
            }
        }
        catch (SystemException e1) {
            this.handleException("Error occurred during obtaining  transaction", (Exception)((Object)e1));
        }
    }

    protected String getContentTypeProperty(MessageContext msgCtx, JMSOutTransportInfo jmsOut, JMSConnectionFactory jmsConnectionFactory) {
        String contentTypeProperty = (String)msgCtx.getProperty("transport.jms.ContentTypeProperty");
        if (contentTypeProperty == null) {
            contentTypeProperty = jmsOut.getContentTypeProperty();
        }
        if (contentTypeProperty == null && jmsConnectionFactory != null) {
            contentTypeProperty = jmsConnectionFactory.getParameters().get("transport.jms.ContentTypeProperty");
        }
        return contentTypeProperty;
    }

    private JMSReplyMessage sendOverJMS(MessageContext msgCtx, JMSMessageSender messageSender, String contentTypeProperty, JMSConnectionFactory jmsConnectionFactory, JMSOutTransportInfo jmsOut) throws AxisFault {
        JMSReplyMessage jmsReplyMessage = null;
        Message message = null;
        String correlationId = null;
        try {
            message = this.createJMSMessage(msgCtx, messageSender.getSession(), contentTypeProperty);
        }
        catch (JMSException e) {
            this.rollbackIfXATransaction(msgCtx);
            jmsConnectionFactory.clearCache();
            this.handleException("Error creating a JMS message from the message context", (Exception)((Object)e));
        }
        boolean waitForResponse = this.waitForSynchronousResponse(msgCtx);
        Destination replyDestination = jmsOut.getReplyDestination();
        if (this.isWaitForResponseOrReplyDestination(waitForResponse, replyDestination, msgCtx)) {
            String replyDestType;
            String replyDestName = (String)msgCtx.getProperty("JMS_REPLY_TO");
            if (replyDestName == null && jmsConnectionFactory != null) {
                replyDestName = jmsOut != null && jmsOut.getReplyDestinationName() != null ? jmsOut.getReplyDestinationName() : jmsConnectionFactory.getReplyToDestination();
            }
            if ((replyDestType = (String)msgCtx.getProperty("JMS_REPLY_TO_TYPE")) == null && jmsConnectionFactory != null) {
                replyDestType = jmsConnectionFactory.getReplyDestinationType();
            }
            if (replyDestName != null) {
                replyDestination = jmsConnectionFactory != null ? jmsConnectionFactory.getDestination(replyDestName, replyDestType) : jmsOut.getReplyDestination(replyDestName);
            }
            replyDestination = JMSUtils.setReplyDestination(replyDestination, messageSender.getSession(), message);
        }
        try {
            if (msgCtx.getProperty("distributedTx") != null) {
                messageSender.send(message, msgCtx);
                Transaction transaction = (Transaction)msgCtx.getProperty("distributedTx");
                if (msgCtx.getTo().toString().contains("transport.jms.TransactionCommand=end")) {
                    this.commitXATransaction(transaction);
                } else if (msgCtx.getTo().toString().contains("transport.jms.TransactionCommand=rollback")) {
                    this.rollbackXATransaction(transaction);
                }
            } else {
                messageSender.transactionallySend(message, msgCtx);
            }
            this.metrics.incrementMessagesSent(msgCtx);
        }
        catch (AxisJMSException e) {
            this.metrics.incrementFaultsSending();
            this.rollbackIfXATransaction(msgCtx);
            jmsConnectionFactory.clearCache();
            this.handleException("Error sending JMS message", e);
        }
        catch (JMSException e) {
            this.handleException("Error sending JMS message to destination", (Exception)((Object)e));
        }
        try {
            this.metrics.incrementBytesSent(msgCtx, JMSUtils.getMessageSize(message));
        }
        catch (JMSException e) {
            this.log.warn((Object)"Error reading JMS message size to update transport metrics", (Throwable)e);
        }
        if (this.isWaitForResponseOrReplyDestination(waitForResponse, replyDestination, msgCtx)) {
            try {
                messageSender.getConnection().start();
            }
            catch (JMSException e) {
                // empty catch block
            }
            try {
                String jmsCorrelationID = message.getJMSCorrelationID();
                correlationId = jmsCorrelationID != null && jmsCorrelationID.length() > 0 ? jmsCorrelationID : message.getJMSMessageID();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            jmsReplyMessage = this.waitForResponseAndProcess(messageSender.getSession(), replyDestination, msgCtx, correlationId, contentTypeProperty);
        }
        if (jmsReplyMessage == null) {
            jmsReplyMessage = new JMSReplyMessage();
        }
        jmsReplyMessage.setReplyDestination(replyDestination);
        return jmsReplyMessage;
    }

    private boolean hasDestinationEPR(MessageContext msgContext) {
        String transportURL = (String)msgContext.getProperty("TransportURL");
        if (transportURL != null) {
            return true;
        }
        return msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress();
    }

    protected boolean isWaitForResponseOrReplyDestination(boolean waitForResponse, Destination replyDestination) {
        return waitForResponse || replyDestination != null;
    }

    protected boolean isWaitForResponseOrReplyDestination(boolean waitForResponse, Destination replyDestination, MessageContext messageContext) {
        return this.isWaitForResponseOrReplyDestination(waitForResponse, replyDestination) && this.hasDestinationEPR(messageContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMSReplyMessage waitForResponseAndProcess(Session session, Destination replyDestination, MessageContext msgCtx, String correlationId, String contentTypeProperty) throws AxisFault {
        JMSReplyMessage jmsReplyMessage;
        block19: {
            jmsReplyMessage = null;
            MessageConsumer consumer = null;
            try {
                Message reply;
                consumer = JMSUtils.createConsumer(session, replyDestination, "JMSCorrelationID = '" + correlationId + "'");
                long timeout = 30000L;
                String waitReply = (String)msgCtx.getProperty("JMS_WAIT_REPLY");
                if (waitReply != null) {
                    timeout = Long.valueOf(waitReply);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Waiting for a maximum of " + timeout + "ms for a response message to destination : " + replyDestination + " with JMS correlation ID : " + correlationId));
                }
                if ((reply = consumer.receive(timeout)) != null) {
                    this.metrics.incrementMessagesReceived();
                    try {
                        this.metrics.incrementBytesReceived(JMSUtils.getMessageSize(reply));
                    }
                    catch (JMSException e) {
                        this.log.warn((Object)"Error reading JMS message size to update transport metrics", (Throwable)e);
                    }
                    try {
                        jmsReplyMessage = this.processSyncResponse(msgCtx, reply, contentTypeProperty);
                        this.metrics.incrementMessagesReceived();
                        break block19;
                    }
                    catch (AxisFault e) {
                        this.metrics.incrementFaultsReceiving();
                        throw e;
                    }
                }
                this.metrics.incrementFaultsReceiving();
                this.handleException("Did not receive a JMS response within " + timeout + " ms to destination : " + replyDestination + " with JMS correlation ID : " + correlationId);
            }
            catch (JMSException e) {
                this.metrics.incrementFaultsReceiving();
                this.handleException("Error creating a consumer, or receiving a synchronous reply for outgoing MessageContext ID : " + msgCtx.getMessageID() + " and reply Destination : " + replyDestination, (Exception)((Object)e));
            }
            finally {
                try {
                    if (consumer != null) {
                        consumer.close();
                    }
                }
                catch (JMSException e) {
                    this.handleException("Unable to close consumer for reply destination: " + replyDestination, (Exception)((Object)e));
                }
            }
        }
        return jmsReplyMessage;
    }

    private Message createJMSMessage(MessageContext msgContext, Session session, String contentTypeProperty) throws JMSException, AxisFault {
        BytesMessage message = null;
        String msgType = this.getProperty(msgContext, "JMS_MESSAGE_TYPE");
        String jmsPayloadType = this.guessMessageType(msgContext);
        if (jmsPayloadType == null) {
            BytesMessageOutputStream out;
            StringWriter sw;
            boolean useBytesMessage;
            OMOutputFormat format = BaseUtils.getOMOutputFormat((MessageContext)msgContext);
            MessageFormatter messageFormatter = null;
            try {
                messageFormatter = MessageProcessorSelector.getMessageFormatter((MessageContext)msgContext);
            }
            catch (AxisFault axisFault) {
                throw new JMSException("Unable to get the message formatter to use");
            }
            String contentType = messageFormatter.getContentType(msgContext, format, msgContext.getSoapAction());
            boolean bl = useBytesMessage = msgType != null && "JMS_BYTE_MESSAGE".equals(msgType) || contentType.indexOf("multipart/related") > -1;
            if (useBytesMessage) {
                BytesMessage bytesMsg = session.createBytesMessage();
                sw = null;
                out = new BytesMessageOutputStream(bytesMsg);
                message = bytesMsg;
            } else {
                sw = new StringWriter();
                try {
                    out = new WriterOutputStream((Writer)sw, format.getCharSetEncoding());
                }
                catch (UnsupportedCharsetException ex) {
                    this.handleException("Unsupported encoding " + format.getCharSetEncoding(), ex);
                    return null;
                }
            }
            try {
                messageFormatter.writeTo(msgContext, format, (OutputStream)out, true);
                out.close();
            }
            catch (IOException e) {
                this.rollbackIfXATransaction(msgContext);
                this.handleException("IO Error while creating BytesMessage", e);
            }
            if (!useBytesMessage) {
                TextMessage txtMsg = session.createTextMessage();
                txtMsg.setText(sw.toString());
                message = txtMsg;
            }
            if (contentTypeProperty != null) {
                message.setStringProperty(contentTypeProperty, contentType);
            }
        } else if ("JMS_BYTE_MESSAGE".equals(jmsPayloadType)) {
            Object dh;
            BytesMessage bytesMsg = message = session.createBytesMessage();
            OMElement wrapper = msgContext.getEnvelope().getBody().getFirstChildWithName(BaseConstants.DEFAULT_BINARY_WRAPPER);
            OMNode omNode = wrapper.getFirstOMChild();
            if (omNode != null && omNode instanceof OMText && (dh = ((OMText)omNode).getDataHandler()) != null && dh instanceof DataHandler) {
                try {
                    ((DataHandler)dh).writeTo((OutputStream)new BytesMessageOutputStream(bytesMsg));
                }
                catch (IOException e) {
                    this.rollbackIfXATransaction(msgContext);
                    this.handleException("Error serializing binary content of element : " + BaseConstants.DEFAULT_BINARY_WRAPPER, e);
                }
            }
        } else if ("JMS_TEXT_MESSAGE".equals(jmsPayloadType)) {
            message = session.createTextMessage();
            TextMessage txtMsg = (TextMessage)message;
            txtMsg.setText(msgContext.getEnvelope().getBody().getFirstChildWithName(BaseConstants.DEFAULT_TEXT_WRAPPER).getText());
        } else if ("JMS_MAP_MESSAGE".equalsIgnoreCase(jmsPayloadType)) {
            message = session.createMapMessage();
            JMSUtils.convertXMLtoJMSMap(msgContext.getEnvelope().getBody().getFirstChildWithName(JMSConstants.JMS_MAP_QNAME), (MapMessage)message);
        }
        String correlationId = this.getProperty(msgContext, "JMS_COORELATION_ID");
        if (correlationId == null && msgContext.getRelatesTo() != null) {
            correlationId = msgContext.getRelatesTo().getValue();
        }
        if (correlationId != null) {
            message.setJMSCorrelationID(correlationId);
        }
        if (msgContext.isServerSide()) {
            this.setProperty((Message)message, msgContext, "SOAPAction");
        } else {
            String action = msgContext.getOptions().getAction();
            if (action != null) {
                message.setStringProperty("SOAPAction", action);
            }
        }
        JMSUtils.setTransportHeaders(msgContext, (Message)message);
        this.setTransactionProperty(msgContext, (Message)message);
        return message;
    }

    private String guessMessageType(MessageContext msgContext) {
        OMElement firstChild = msgContext.getEnvelope().getBody().getFirstElement();
        if (firstChild != null) {
            if (BaseConstants.DEFAULT_BINARY_WRAPPER.equals(firstChild.getQName())) {
                return "JMS_BYTE_MESSAGE";
            }
            if (BaseConstants.DEFAULT_TEXT_WRAPPER.equals(firstChild.getQName())) {
                return "JMS_TEXT_MESSAGE";
            }
            if (JMSConstants.JMS_MAP_QNAME.equals(firstChild.getQName())) {
                return "JMS_MAP_MESSAGE";
            }
        }
        return null;
    }

    private JMSReplyMessage processSyncResponse(MessageContext outMsgCtx, Message message, String contentTypeProperty) throws AxisFault {
        MessageContext responseMsgCtx = this.createResponseMessageContext(outMsgCtx);
        JMSUtils.loadTransportHeaders(message, responseMsgCtx);
        String contentType = contentTypeProperty == null ? (String)outMsgCtx.getProperty("ContentType") : JMSUtils.getProperty(message, contentTypeProperty);
        try {
            JMSUtils.setSOAPEnvelope(message, responseMsgCtx, contentType);
        }
        catch (JMSException ex) {
            throw AxisFault.makeFault((Throwable)ex);
        }
        JMSReplyMessage jmsReplyMessage = new JMSReplyMessage();
        jmsReplyMessage.setMsgctx(responseMsgCtx);
        jmsReplyMessage.setTransportHeaders(JMSUtils.getTransportHeaders(message, responseMsgCtx));
        jmsReplyMessage.setSoapAction(JMSUtils.getProperty(message, "SOAPAction"));
        jmsReplyMessage.setContentType(contentType);
        return jmsReplyMessage;
    }

    private void setTransactionProperty(MessageContext msgContext, Message message) {
        Object transactionProperty = msgContext.getProperty("INTERNAL_TRANSACTION_COUNTED");
        if (transactionProperty instanceof Boolean) {
            try {
                message.setBooleanProperty("INTERNAL_TRANSACTION_COUNTED", ((Boolean)transactionProperty).booleanValue());
            }
            catch (JMSException e) {
                this.log.warn((Object)("Couldn't set message property : INTERNAL_TRANSACTION_COUNTED = " + transactionProperty), (Throwable)e);
            }
        }
    }

    private void setProperty(Message message, MessageContext msgCtx, String key) {
        String value = this.getProperty(msgCtx, key);
        if (value != null) {
            try {
                message.setStringProperty(key, value);
            }
            catch (JMSException e) {
                this.log.warn((Object)("Couldn't set message property : " + key + " = " + value), (Throwable)e);
            }
        }
    }

    private String getProperty(MessageContext mc, String key) {
        return (String)mc.getProperty(key);
    }

    public void clearActiveConnections() {
        this.log.error((Object)"Not Implemented.");
    }

    private void commitXATransaction(Transaction transaction) throws AxisFault {
        ArrayList<JMSMessageSender> msgSenderList = jmsMessageSenderMap.get(transaction);
        if (msgSenderList.size() > 0) {
            for (JMSMessageSender msgSender : msgSenderList) {
                try {
                    msgSender.getJmsXaResource().end(msgSender.getJmsXAXid(), 0x4000000);
                    msgSender.getJmsXaResource().prepare(msgSender.getJmsXAXid());
                    msgSender.getJmsXaResource().commit(msgSender.getJmsXAXid(), false);
                    msgSender.close();
                }
                catch (XAException e) {
                    this.handleException("Error occurred during rolling back transaction", e);
                    msgSender.closeOnException();
                }
            }
            jmsMessageSenderMap.remove(transaction);
        }
    }

    private void rollbackXATransaction(Transaction transaction) throws AxisFault {
        ArrayList<JMSMessageSender> msgSenderList = jmsMessageSenderMap.get(transaction);
        if (msgSenderList.size() > 0) {
            for (JMSMessageSender msgSender : msgSenderList) {
                try {
                    msgSender.getJmsXaResource().end(msgSender.getJmsXAXid(), 0x4000000);
                    msgSender.getJmsXaResource().prepare(msgSender.getJmsXAXid());
                    msgSender.getJmsXaResource().commit(msgSender.getJmsXAXid(), false);
                    msgSender.close();
                }
                catch (XAException e) {
                    this.handleException("Error occurred during rolling back transaction", e);
                    msgSender.closeOnException();
                }
            }
            jmsMessageSenderMap.remove(transaction);
        }
    }
}

