/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.nio.charset.StandardCharsets;
import java.util.Hashtable;
import java.util.UUID;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSConnectionFactory;
import org.apache.axis2.transport.jms.JMSMessageSender;
import org.apache.axis2.transport.jms.JMSUtils;
import org.apache.axis2.transport.jms.JMSXid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSOutTransportInfo
implements OutTransportInfo {
    private static final Log log = LogFactory.getLog(JMSOutTransportInfo.class);
    private ConnectionFactory connectionFactory = null;
    private JMSConnectionFactory jmsConnectionFactory = null;
    private Destination destination = null;
    private String destinationType = "generic";
    private Destination replyDestination = null;
    private String replyDestinationName = null;
    private String replyDestinationType = "generic";
    private Hashtable<String, String> properties = null;
    private String targetEPR = null;
    private String contentTypeProperty;
    private int cacheLevel;
    private String jmsSpecVersion;

    JMSOutTransportInfo(JMSConnectionFactory jmsConnectionFactory, Destination dest, String contentTypeProperty) {
        this.jmsConnectionFactory = jmsConnectionFactory;
        this.destination = dest;
        this.destinationType = dest instanceof Topic ? "topic" : "queue";
        this.contentTypeProperty = contentTypeProperty;
    }

    JMSOutTransportInfo(String targetEPR) {
        String replyDestinationType;
        this.targetEPR = targetEPR;
        this.properties = BaseUtils.getEPRProperties((String)targetEPR);
        String destinationType = this.properties.get("transport.jms.DestinationType");
        if (destinationType != null) {
            this.setDestinationType(destinationType);
        }
        if ((replyDestinationType = this.properties.get("transport.jms.ReplyDestinationType")) != null) {
            this.setReplyDestinationType(replyDestinationType);
        }
        this.replyDestinationName = this.properties.get("transport.jms.ReplyDestination");
        this.contentTypeProperty = this.properties.get("transport.jms.ContentTypeProperty");
        this.cacheLevel = this.getCacheLevel(this.properties.get("transport.jms.CacheLevel"));
        this.jmsSpecVersion = this.properties.get("transport.jms.JMSSpecVersion") != null ? this.properties.get("transport.jms.JMSSpecVersion") : "1.0.2b";
    }

    private void loadConnectionFactoryFromProperties() {
        if (this.properties != null) {
            InitialContext context = null;
            try {
                context = new InitialContext(this.properties);
            }
            catch (NamingException e) {
                this.handleException("Could not get an initial context using " + this.properties, e);
            }
            if (this.destination == null) {
                this.destination = this.getDestination(context, this.targetEPR);
                this.replyDestination = this.getReplyDestination(context, this.targetEPR);
            }
            this.connectionFactory = this.getConnectionFactory(context, this.properties);
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    log.warn((Object)"Error while cleaning up the InitialContext", (Throwable)e);
                }
            }
        }
    }

    private ConnectionFactory getConnectionFactory(Context context, Hashtable<String, String> props) {
        try {
            String conFacJndiName = props.get("transport.jms.ConnectionFactoryJNDIName");
            if (conFacJndiName != null) {
                return JMSUtils.lookup(context, ConnectionFactory.class, conFacJndiName);
            }
            this.handleException("Connection Factory JNDI name cannot be determined");
        }
        catch (NamingException e) {
            this.handleException("Failed to look up connection factory from JNDI", e);
        }
        return null;
    }

    private Destination getDestination(Context context, String url) {
        String destinationName = JMSUtils.getDestination(url);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Lookup the JMS destination " + destinationName + " of type " + this.destinationType + " extracted from the URL " + JMSUtils.maskURLPasswordAndCredentials(url)));
        }
        try {
            return JMSUtils.lookupDestination(context, destinationName, this.destinationType);
        }
        catch (NamingException e) {
            this.handleException("Couldn't locate the JMS destination " + destinationName + " of type " + this.destinationType + " extracted from the URL " + JMSUtils.maskURLPasswordAndCredentials(url), e);
            return null;
        }
    }

    private Destination getReplyDestination(Context context, String url) {
        String replyDestinationName = this.properties.get("transport.jms.ReplyDestination");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Lookup the JMS destination " + replyDestinationName + " of type " + this.replyDestinationType + " extracted from the URL " + JMSUtils.maskURLPasswordAndCredentials(url)));
        }
        try {
            return JMSUtils.lookupDestination(context, replyDestinationName, this.replyDestinationType);
        }
        catch (NamingException e) {
            this.handleException("Couldn't locate the JMS destination " + replyDestinationName + " of type " + this.replyDestinationType + " extracted from the URL " + JMSUtils.maskURLPasswordAndCredentials(url), e);
            return null;
        }
    }

    public Destination getReplyDestination(String replyDest) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Lookup the JMS destination " + replyDest + " of type " + this.replyDestinationType));
        }
        try {
            return JMSUtils.lookupDestination(this.jmsConnectionFactory.getContext(), replyDest, this.replyDestinationType);
        }
        catch (NamingException e) {
            this.handleException("Couldn't locate the JMS destination " + replyDest + " of type " + this.replyDestinationType, e);
            return null;
        }
    }

    private void handleException(String s) {
        log.error((Object)s);
        throw new AxisJMSException(s);
    }

    private void handleException(String s, Exception e) {
        log.error((Object)s, (Throwable)e);
        throw new AxisJMSException(s, e);
    }

    public Destination getDestination() {
        return this.destination;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public JMSConnectionFactory getJmsConnectionFactory() {
        return this.jmsConnectionFactory;
    }

    public void setContentType(String contentType) {
    }

    public Hashtable<String, String> getProperties() {
        return this.properties;
    }

    public String getTargetEPR() {
        return this.targetEPR;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(String destinationType) {
        if (destinationType != null) {
            this.destinationType = destinationType;
        }
    }

    public Destination getReplyDestination() {
        return this.replyDestination;
    }

    public void setReplyDestination(Destination replyDestination) {
        this.replyDestination = replyDestination;
    }

    public String getReplyDestinationType() {
        return this.replyDestinationType;
    }

    public void setReplyDestinationType(String replyDestinationType) {
        this.replyDestinationType = replyDestinationType;
    }

    public String getReplyDestinationName() {
        return this.replyDestinationName;
    }

    public void setReplyDestinationName(String replyDestinationName) {
        this.replyDestinationName = replyDestinationName;
    }

    public String getContentTypeProperty() {
        return this.contentTypeProperty;
    }

    public void setContentTypeProperty(String contentTypeProperty) {
        this.contentTypeProperty = contentTypeProperty;
    }

    public JMSMessageSender createJMSSender(MessageContext msgCtx) throws JMSException {
        this.loadConnectionFactoryFromProperties();
        String user = this.properties != null ? this.properties.get("transport.jms.UserName") : null;
        String pass = this.properties != null ? this.properties.get("transport.jms.Password") : null;
        QueueConnectionFactory qConFac = null;
        TopicConnectionFactory tConFac = null;
        int destType = -1;
        if ("queue".equals(this.destinationType)) {
            destType = 1;
            qConFac = (QueueConnectionFactory)this.connectionFactory;
        } else if ("topic".equals(this.destinationType)) {
            destType = 2;
            tConFac = (TopicConnectionFactory)this.connectionFactory;
        } else {
            destType = 1;
            qConFac = (QueueConnectionFactory)this.connectionFactory;
        }
        if (msgCtx.getProperty("distributedTxMgr") != null) {
            XAConnection connection = null;
            if (user != null && pass != null) {
                if (qConFac != null) {
                    connection = ((XAConnectionFactory)qConFac).createXAConnection(user, pass);
                } else if (tConFac != null) {
                    connection = ((XAConnectionFactory)tConFac).createXAConnection(user, pass);
                }
            } else if (qConFac != null) {
                connection = ((XAConnectionFactory)qConFac).createXAConnection();
            } else if (tConFac != null) {
                connection = ((XAConnectionFactory)tConFac).createXAConnection();
            }
            if (connection == null) {
                connection = ((XAConnectionFactory)qConFac).createXAConnection();
            }
            XASession session = null;
            MessageProducer producer = null;
            if (connection != null) {
                if (destType == 1) {
                    session = connection.createXASession();
                    producer = session.createProducer(this.destination);
                } else {
                    session = connection.createXASession();
                    producer = session.createProducer(this.destination);
                }
            }
            XAResource xaResource = session.getXAResource();
            TransactionManager tx = null;
            JMSXid xid1 = null;
            Transaction transaction = null;
            UUID uuid = UUID.randomUUID();
            try {
                tx = (TransactionManager)msgCtx.getProperty("distributedTxMgr");
                transaction = tx.getTransaction();
                msgCtx.setProperty("distributedTxMgr", (Object)tx);
                msgCtx.setProperty("distributedTx", (Object)transaction);
                xid1 = new JMSXid("wso2-jms-xa-transaction".getBytes(StandardCharsets.UTF_8), 1, uuid.toString().getBytes());
                msgCtx.setProperty("XID", (Object)xid1);
                xaResource.start(xid1, 0);
            }
            catch (SystemException e) {
                this.handleException("Error Occurred during starting getting Transaction.", (Exception)((Object)e));
            }
            catch (XAException e) {
                this.handleException("Error Occurred during starting XA resource.", e);
            }
            if (this.jmsConnectionFactory != null && this.jmsConnectionFactory.jmsSpecVersion() != null) {
                this.jmsSpecVersion = this.jmsConnectionFactory.jmsSpecVersion();
            } else if (this.jmsSpecVersion == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Setting default JMS version :: 1.0.2b");
                }
                this.jmsSpecVersion = "1.0.2b";
            }
            return new JMSMessageSender((Connection)connection, (Session)session, producer, this.destination, this.jmsConnectionFactory == null ? this.cacheLevel : this.jmsConnectionFactory.getCacheLevel(), this.jmsSpecVersion, destType == -1 ? null : (destType == 1 ? Boolean.TRUE : Boolean.FALSE), transaction, xid1, xaResource);
        }
        QueueConnection connection = null;
        if (user != null && pass != null) {
            if (qConFac != null) {
                connection = qConFac.createQueueConnection(user, pass);
            } else if (tConFac != null) {
                connection = tConFac.createTopicConnection(user, pass);
            }
        } else if (qConFac != null) {
            connection = qConFac.createQueueConnection();
        } else if (tConFac != null) {
            connection = tConFac.createTopicConnection();
        }
        if (connection == null) {
            connection = this.jmsConnectionFactory != null ? this.jmsConnectionFactory.getConnection() : null;
        }
        QueueSession session = null;
        QueueSender producer = null;
        if (connection != null) {
            if (destType == 1) {
                session = connection.createQueueSession(false, 1);
                producer = session.createSender((Queue)this.destination);
            } else {
                session = ((TopicConnection)connection).createTopicSession(false, 1);
                producer = ((TopicSession)session).createPublisher((Topic)this.destination);
            }
        }
        if (this.jmsConnectionFactory != null && this.jmsConnectionFactory.jmsSpecVersion() != null) {
            this.jmsSpecVersion = this.jmsConnectionFactory.jmsSpecVersion();
        } else if (this.jmsSpecVersion == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Setting default JMS version :: 1.0.2b");
            }
            this.jmsSpecVersion = "1.0.2b";
        }
        return new JMSMessageSender((Connection)connection, (Session)session, (MessageProducer)producer, this.destination, this.jmsConnectionFactory == null ? this.cacheLevel : this.jmsConnectionFactory.getCacheLevel(), this.jmsSpecVersion, destType == -1 ? null : (destType == 1 ? Boolean.TRUE : Boolean.FALSE));
    }

    private int getCacheLevel(String cacheValue) {
        int cacheLevel = 0;
        if ("none".equalsIgnoreCase(cacheValue)) {
            cacheLevel = 0;
        } else if ("connection".equalsIgnoreCase(cacheValue)) {
            cacheLevel = 1;
        } else if ("session".equals(cacheValue)) {
            cacheLevel = 2;
        } else if ("producer".equals(cacheValue)) {
            cacheLevel = 4;
        } else if ("consumer".equals(cacheValue)) {
            cacheLevel = 3;
        } else if (cacheValue != null) {
            throw new AxisJMSException("Invalid cache level : " + cacheValue + " for JMSOutTransportInfo");
        }
        return cacheLevel;
    }
}

