/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSConnectionFactory;
import org.apache.axis2.transport.jms.JMSUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSMessageSender {
    private static final Log log = LogFactory.getLog(JMSMessageSender.class);
    private Connection connection = null;
    private Session session = null;
    private MessageProducer producer = null;
    private Destination destination = null;
    private int cacheLevel = 1;
    private String jmsSpecVersion = null;
    private Boolean isQueue = null;
    private Boolean jtaCommit;
    private Boolean rollbackOnly;
    private boolean sendingSuccessful;
    private Boolean isProducerCachingHonoured = false;
    private Xid jmsXAXid;
    private XAResource jmsXaResource;
    private Transaction jmsTransaction;

    public JMSMessageSender(Connection connection, Session session, MessageProducer producer, Destination destination, int cacheLevel, String jmsSpecVersion, Boolean isQueue) {
        this.connection = connection;
        this.session = session;
        this.producer = producer;
        this.destination = destination;
        this.cacheLevel = cacheLevel;
        this.jmsSpecVersion = jmsSpecVersion;
        this.isQueue = isQueue;
    }

    public JMSMessageSender(Connection connection, Session session, MessageProducer producer, Destination destination, int cacheLevel, String jmsSpecVersion, Boolean isQueue, Transaction tx, Xid xid, XAResource xaResource) {
        this.connection = connection;
        this.session = session;
        this.producer = producer;
        this.destination = destination;
        this.cacheLevel = cacheLevel;
        this.jmsSpecVersion = jmsSpecVersion;
        this.isQueue = isQueue;
        this.jmsTransaction = tx;
        this.jmsXAXid = xid;
        this.jmsXaResource = xaResource;
    }

    public JMSMessageSender(JMSConnectionFactory jmsConnectionFactory, String targetAddress) {
        try {
            this.cacheLevel = jmsConnectionFactory.getCacheLevel();
            this.isProducerCachingHonoured = this.cacheLevel > 2;
            this.jmsSpecVersion = jmsConnectionFactory.jmsSpecVersion();
            this.connection = jmsConnectionFactory.getConnection();
            this.session = jmsConnectionFactory.getSession(this.connection);
            boolean isQueue = jmsConnectionFactory.isQueue() == null ? true : jmsConnectionFactory.isQueue();
            String destinationFromAddress = JMSUtils.getDestination(targetAddress);
            this.destination = destinationFromAddress != null && !destinationFromAddress.isEmpty() ? jmsConnectionFactory.getDestination(JMSUtils.getDestination(targetAddress), isQueue ? "queue" : "topic") : jmsConnectionFactory.getSharedDestination();
            this.producer = jmsConnectionFactory.getMessageProducer(this.connection, this.session, this.destination);
        }
        catch (Exception e) {
            this.handleException("Error while creating message sender", e);
        }
    }

    public void send(Message message, MessageContext msgCtx) throws JMSException {
        block36: {
            this.jtaCommit = this.getBooleanProperty(msgCtx, "JTA_COMMIT_AFTER_SEND");
            this.rollbackOnly = this.getBooleanProperty(msgCtx, "SET_ROLLBACK_ONLY");
            String deliveryMode = this.getStringProperty(msgCtx, "JMS_DELIVERY_MODE");
            Integer priority = this.getIntegerProperty(msgCtx, "JMS_PRIORITY");
            Integer timeToLive = this.getIntegerProperty(msgCtx, "JMS_TIME_TO_LIVE");
            Integer messageDelay = this.getIntegerProperty(msgCtx, "JMS_MESSAGE_DELAY");
            if (this.rollbackOnly != null && this.rollbackOnly.booleanValue()) {
                this.jtaCommit = Boolean.FALSE;
            }
            if (deliveryMode != null) {
                try {
                    if ("PERSISTENT".equalsIgnoreCase(deliveryMode)) {
                        this.producer.setDeliveryMode(2);
                    } else if ("NON_PERSISTENT".equalsIgnoreCase(deliveryMode)) {
                        this.producer.setDeliveryMode(1);
                    } else {
                        log.warn((Object)("Unknown JMS Delivery mode: " + deliveryMode + " defined as JMS_DELIVERY_MODE property"));
                    }
                }
                catch (JMSException e) {
                    this.handleException("Error setting JMS Producer for PERSISTENT delivery", (Exception)((Object)e));
                }
            }
            if (priority != null) {
                try {
                    this.producer.setPriority(priority.intValue());
                }
                catch (JMSException e) {
                    this.handleException("Error setting JMS Producer priority to : " + priority, (Exception)((Object)e));
                }
            }
            if (timeToLive != null) {
                try {
                    this.producer.setTimeToLive((long)timeToLive.intValue());
                }
                catch (JMSException e) {
                    this.handleException("Error setting JMS Producer TTL to : " + timeToLive, (Exception)((Object)e));
                }
            }
            if ("2.0".equals(this.jmsSpecVersion) && messageDelay != null) {
                try {
                    this.producer.setDeliveryDelay((long)messageDelay.intValue());
                }
                catch (JMSException e) {
                    this.handleException("Error setting JMS Producer Message Delivery Delay : " + messageDelay, (Exception)((Object)e));
                }
            }
            this.sendingSuccessful = false;
            if ("1.1".equals(this.jmsSpecVersion) || "2.0".equals(this.jmsSpecVersion) || this.isQueue == null) {
                if (this.isProducerCachingHonoured.booleanValue()) {
                    this.producer.send(this.destination, message);
                } else {
                    this.producer.send(message);
                }
            } else if (this.isQueue.booleanValue()) {
                try {
                    if (this.isProducerCachingHonoured.booleanValue()) {
                        this.producer.send(this.destination, message);
                        break block36;
                    }
                    this.producer.send(message);
                }
                catch (JMSException e) {
                    log.error((Object)("Error sending message with MessageContext ID : " + msgCtx.getMessageID() + " to destination : " + this.destination + " Hence creating a temporary subscriber" + (Object)((Object)e)));
                    this.createTempQueueConsumer();
                    if (this.isProducerCachingHonoured.booleanValue()) {
                        this.producer.send(this.destination, message);
                        break block36;
                    }
                    this.producer.send(message);
                }
            } else {
                try {
                    if (this.isProducerCachingHonoured.booleanValue()) {
                        ((TopicPublisher)this.producer).publish((Topic)this.destination, message);
                    } else {
                        ((TopicPublisher)this.producer).publish(message);
                    }
                }
                catch (JMSException e) {
                    this.createTempTopicSubscriber();
                    if (this.isProducerCachingHonoured.booleanValue()) {
                        ((TopicPublisher)this.producer).publish((Topic)this.destination, message);
                    }
                    ((TopicPublisher)this.producer).publish(message);
                }
            }
        }
        String msgId = null;
        try {
            msgId = message.getJMSMessageID();
            if (msgId != null) {
                msgCtx.setProperty("JMS_MESSAGE_ID", (Object)msgId);
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.sendingSuccessful = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sent Message Context ID : " + msgCtx.getMessageID() + " with JMS Message ID : " + msgId + " to destination : " + this.destination));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void transactionallySend(Message message, MessageContext msgCtx) {
        block42: {
            block41: {
                this.send(message, msgCtx);
                if (this.jtaCommit == null) break block41;
                UserTransaction ut = (UserTransaction)msgCtx.getProperty("UserTransaction");
                if (ut != null) {
                    try {
                        if (this.sendingSuccessful && this.jtaCommit.booleanValue()) {
                            ut.commit();
                        } else {
                            ut.rollback();
                        }
                        msgCtx.removeProperty("UserTransaction");
                        if (log.isDebugEnabled()) {
                            log.debug((Object)((this.sendingSuccessful ? "Committed" : "Rolled back") + " JTA Transaction"));
                        }
                        break block42;
                    }
                    catch (Exception e) {
                        this.handleException("Error committing/rolling back JTA transaction after sending of message with MessageContext ID : " + msgCtx.getMessageID() + " to destination : " + this.destination, e);
                    }
                }
                break block42;
            }
            try {
                if (this.session.getTransacted()) {
                    if (this.sendingSuccessful && (this.rollbackOnly == null || !this.rollbackOnly.booleanValue())) {
                        this.session.commit();
                    } else {
                        this.session.rollback();
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)((this.sendingSuccessful ? "Committed" : "Rolled back") + " local (JMS Session) Transaction"));
                }
                break block42;
            }
            catch (JMSException e) {
                this.handleException("Error committing/rolling back local (i.e. session) transaction after sending of message with MessageContext ID : " + msgCtx.getMessageID() + " to destination : " + this.destination, (Exception)((Object)e));
            }
            break block42;
            catch (JMSException e) {
                block43: {
                    try {
                        this.handleException("Error sending message with MessageContext ID : " + msgCtx.getMessageID() + " to destination : " + this.destination, (Exception)((Object)e));
                        if (this.jtaCommit == null) break block43;
                    }
                    catch (Throwable throwable) {
                        if (this.jtaCommit != null) {
                            UserTransaction ut = (UserTransaction)msgCtx.getProperty("UserTransaction");
                            if (ut != null) {
                                try {
                                    if (this.sendingSuccessful && this.jtaCommit.booleanValue()) {
                                        ut.commit();
                                    } else {
                                        ut.rollback();
                                    }
                                    msgCtx.removeProperty("UserTransaction");
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)((this.sendingSuccessful ? "Committed" : "Rolled back") + " JTA Transaction"));
                                    }
                                }
                                catch (Exception e2) {
                                    this.handleException("Error committing/rolling back JTA transaction after sending of message with MessageContext ID : " + msgCtx.getMessageID() + " to destination : " + this.destination, e2);
                                }
                            }
                        } else {
                            try {
                                if (this.session.getTransacted()) {
                                    if (this.sendingSuccessful && (this.rollbackOnly == null || !this.rollbackOnly.booleanValue())) {
                                        this.session.commit();
                                    } else {
                                        this.session.rollback();
                                    }
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)((this.sendingSuccessful ? "Committed" : "Rolled back") + " local (JMS Session) Transaction"));
                                }
                            }
                            catch (JMSException e3) {
                                this.handleException("Error committing/rolling back local (i.e. session) transaction after sending of message with MessageContext ID : " + msgCtx.getMessageID() + " to destination : " + this.destination, (Exception)((Object)e3));
                            }
                        }
                        throw throwable;
                    }
                    UserTransaction ut = (UserTransaction)msgCtx.getProperty("UserTransaction");
                    if (ut == null) break block42;
                    try {
                        if (this.sendingSuccessful && this.jtaCommit.booleanValue()) {
                            ut.commit();
                        } else {
                            ut.rollback();
                        }
                        msgCtx.removeProperty("UserTransaction");
                        if (log.isDebugEnabled()) {
                            log.debug((Object)((this.sendingSuccessful ? "Committed" : "Rolled back") + " JTA Transaction"));
                        }
                    }
                    catch (Exception e4) {
                        this.handleException("Error committing/rolling back JTA transaction after sending of message with MessageContext ID : " + msgCtx.getMessageID() + " to destination : " + this.destination, e4);
                    }
                }
                try {
                    if (this.session.getTransacted()) {
                        if (this.sendingSuccessful && (this.rollbackOnly == null || !this.rollbackOnly.booleanValue())) {
                            this.session.commit();
                        } else {
                            this.session.rollback();
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)((this.sendingSuccessful ? "Committed" : "Rolled back") + " local (JMS Session) Transaction"));
                    }
                }
                catch (JMSException e5) {
                    this.handleException("Error committing/rolling back local (i.e. session) transaction after sending of message with MessageContext ID : " + msgCtx.getMessageID() + " to destination : " + this.destination, (Exception)((Object)e5));
                }
            }
        }
    }

    public void createTempQueueConsumer() throws JMSException {
        MessageConsumer consumer = this.session.createConsumer(this.destination);
        consumer.close();
    }

    public void createTempTopicSubscriber() throws JMSException {
        TopicSubscriber subscriber = ((TopicSession)this.session).createSubscriber((Topic)this.destination);
        subscriber.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.producer != null && this.cacheLevel < 4) {
            try {
                this.producer.close();
            }
            catch (JMSException e) {
                log.error((Object)"Error closing JMS MessageProducer after send", (Throwable)e);
            }
            finally {
                this.producer = null;
            }
        }
        if (this.session != null && this.cacheLevel < 2) {
            try {
                this.session.close();
            }
            catch (JMSException e) {
                log.error((Object)"Error closing JMS Session after send", (Throwable)e);
            }
            finally {
                this.session = null;
            }
        }
        if (this.connection != null && this.cacheLevel < 1) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                log.error((Object)"Error closing JMS Connection after send", (Throwable)e);
            }
            finally {
                this.connection = null;
            }
        }
    }

    private void handleException(String message, Exception e) {
        log.error((Object)message, (Throwable)e);
        if (!this.isTransacted()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cleaning up connections on error", (Throwable)e);
            }
            this.closeOnException();
        }
        throw new AxisJMSException(message, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOnException() {
        if (this.producer != null) {
            try {
                this.producer.close();
            }
            catch (JMSException e) {
                log.error((Object)"Error closing JMS MessageProducer after send", (Throwable)e);
            }
            finally {
                this.producer = null;
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException e) {
                log.error((Object)"Error closing JMS Session after send", (Throwable)e);
            }
            finally {
                this.session = null;
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                log.error((Object)"Error closing JMS Connection after send", (Throwable)e);
            }
            finally {
                this.connection = null;
            }
        }
    }

    private boolean isTransacted() {
        return this.jmsXAXid != null || this.jmsXaResource != null || this.jmsTransaction != null;
    }

    private Boolean getBooleanProperty(MessageContext msgCtx, String name) {
        Object o = msgCtx.getProperty(name);
        if (o != null) {
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            if (o instanceof String) {
                return Boolean.valueOf((String)o);
            }
        }
        return null;
    }

    private String getStringProperty(MessageContext msgCtx, String name) {
        Object propObject = msgCtx.getProperty(name);
        if (propObject != null && propObject instanceof String) {
            return (String)propObject;
        }
        return null;
    }

    private Integer getIntegerProperty(MessageContext msgCtx, String name) {
        Object o = msgCtx.getProperty(name);
        if (o != null) {
            if (o instanceof Integer) {
                return (Integer)o;
            }
            if (o instanceof String) {
                return Integer.parseInt((String)o);
            }
        }
        return null;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setProducer(MessageProducer producer) {
        this.producer = producer;
    }

    public void setCacheLevel(int cacheLevel) {
        this.cacheLevel = cacheLevel;
    }

    public int getCacheLevel() {
        return this.cacheLevel;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public MessageProducer getProducer() {
        return this.producer;
    }

    public Session getSession() {
        return this.session;
    }

    public Xid getJmsXAXid() {
        return this.jmsXAXid;
    }

    public void setJmsXAXid(Xid jmsXAXid) {
        this.jmsXAXid = jmsXAXid;
    }

    public XAResource getJmsXaResource() {
        return this.jmsXaResource;
    }

    public void setJmsXaResource(XAResource jmsXaResource) {
        this.jmsXaResource = jmsXaResource;
    }

    public Transaction getJmsTransaction() {
        return this.jmsTransaction;
    }

    public void setJmsTransaction(Transaction jmsTransaction) {
        this.jmsTransaction = jmsTransaction;
    }

    public Destination getDestination() {
        return this.destination;
    }
}

