/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterIncludeImpl;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecureVaultException;
import org.wso2.securevault.commons.MiscellaneousUtil;

public class JMSConnectionFactory {
    private static final Log log = LogFactory.getLog(JMSConnectionFactory.class);
    private String name = null;
    private Hashtable<String, String> parameters = new Hashtable();
    private Context context = null;
    private ConnectionFactory conFactory = null;
    private Connection sharedConnection = null;
    private Session sharedSession = null;
    private MessageProducer sharedProducer = null;
    private Destination sharedDestination = null;
    private int cacheLevel = 1;
    private Map<Integer, Connection> sharedConnectionMap = new ConcurrentHashMap<Integer, Connection>();
    private int maxSharedConnectionCount = 10;
    private int lastReturnedConnectionIndex = 0;

    @Deprecated
    public JMSConnectionFactory(Parameter parameter) {
        this.name = parameter.getName();
        ParameterIncludeImpl pi = new ParameterIncludeImpl();
        try {
            pi.deserializeParameters((OMElement)parameter.getValue());
        }
        catch (AxisFault axisFault) {
            this.handleException("Error reading parameters for JMS connection factory " + JMSUtils.maskURLPasswordAndCredentials(this.name), (Exception)((Object)axisFault));
        }
        for (Object o : pi.getParameters()) {
            Parameter p = (Parameter)o;
            this.parameters.put(p.getName(), (String)p.getValue());
        }
        this.digestCacheLevel();
        try {
            this.context = new InitialContext(this.parameters);
            this.conFactory = JMSUtils.lookup(this.context, ConnectionFactory.class, this.parameters.get("transport.jms.ConnectionFactoryJNDIName"));
            if (this.parameters.get("transport.jms.Destination") != null) {
                this.sharedDestination = JMSUtils.lookup(this.context, Destination.class, this.parameters.get("transport.jms.Destination"));
            }
            log.info((Object)("JMS ConnectionFactory : " + JMSUtils.maskURLPasswordAndCredentials(this.name) + " initialized"));
        }
        catch (NamingException e) {
            throw new AxisJMSException("Cannot acquire JNDI context, JMS Connection factory : " + this.parameters.get("transport.jms.ConnectionFactoryJNDIName") + " or default destination : " + this.parameters.get("transport.jms.Destination") + " for JMS CF : " + JMSUtils.maskURLPasswordAndCredentials(this.name) + " using : " + JMSUtils.maskAxis2ConfigSensitiveParameters(this.parameters), e);
        }
        this.setMaxSharedJMSConnectionsCount();
    }

    public JMSConnectionFactory(Parameter parameter, SecretResolver secretResolver) {
        this.name = parameter.getName();
        ParameterIncludeImpl pi = new ParameterIncludeImpl();
        try {
            pi.deserializeParameters((OMElement)parameter.getValue());
        }
        catch (AxisFault axisFault) {
            this.handleException("Error reading parameters for JMS connection factory " + JMSUtils.maskURLPasswordAndCredentials(this.name), (Exception)((Object)axisFault));
        }
        for (Parameter param : pi.getParameters()) {
            OMElement paramElement = param.getParameterElement();
            String propertyValue = param.getValue().toString();
            if (paramElement != null) {
                if (secretResolver == null) {
                    throw new SecureVaultException("Cannot resolve secret password because axis2 secret resolver is null");
                }
                propertyValue = MiscellaneousUtil.resolve((OMElement)paramElement, (SecretResolver)secretResolver);
            }
            this.parameters.put(param.getName(), propertyValue);
        }
        this.digestCacheLevel();
        this.initJMSConnectionFactory();
        this.setMaxSharedJMSConnectionsCount();
    }

    public JMSConnectionFactory(String targetEndpoint) {
        this.name = targetEndpoint;
        this.parameters.putAll(BaseUtils.getEPRProperties((String)targetEndpoint));
        this.digestCacheLevel();
        this.initJMSConnectionFactory();
        this.setMaxSharedJMSConnectionsCount();
    }

    private void initJMSConnectionFactory() {
        try {
            this.context = new InitialContext(this.parameters);
            this.conFactory = JMSUtils.lookup(this.context, ConnectionFactory.class, this.parameters.get("transport.jms.ConnectionFactoryJNDIName"));
            if (this.parameters.get("transport.jms.Destination") != null) {
                this.sharedDestination = JMSUtils.lookup(this.context, Destination.class, this.parameters.get("transport.jms.Destination"));
            }
            log.info((Object)("JMS ConnectionFactory : " + JMSUtils.maskURLPasswordAndCredentials(this.name) + " initialized"));
        }
        catch (NamingException e) {
            throw new AxisJMSException("Cannot acquire JNDI context, JMS Connection factory : " + this.parameters.get("transport.jms.ConnectionFactoryJNDIName") + " or default destination : " + this.parameters.get("transport.jms.Destination") + " for JMS CF : " + JMSUtils.maskURLPasswordAndCredentials(this.name) + " using : " + JMSUtils.maskAxis2ConfigSensitiveParameters(this.parameters), e);
        }
    }

    private void digestCacheLevel() {
        String key = "transport.jms.CacheLevel";
        String val = this.parameters.get(key);
        if ("none".equalsIgnoreCase(val)) {
            this.cacheLevel = 0;
        } else if ("connection".equalsIgnoreCase(val)) {
            this.cacheLevel = 1;
        } else if ("session".equals(val)) {
            this.cacheLevel = 2;
        } else if ("producer".equals(val)) {
            this.cacheLevel = 4;
        } else if ("consumer".equals(val)) {
            this.cacheLevel = 3;
        } else if (val != null) {
            throw new AxisJMSException("Invalid cache level : " + val + " for JMS CF : " + JMSUtils.maskURLPasswordAndCredentials(this.name));
        }
    }

    private void setMaxSharedJMSConnectionsCount() {
        if (this.parameters.get("transport.jms.MaxJMSConnections") != null) {
            String maxConnectionCount = this.parameters.get("transport.jms.MaxJMSConnections");
            try {
                int maxCount = Integer.parseInt(maxConnectionCount);
                if (maxCount > 0) {
                    this.maxSharedConnectionCount = maxCount;
                    log.info((Object)("---- Max Shared JMS Connection Count Set to " + this.maxSharedConnectionCount));
                }
            }
            catch (NumberFormatException e) {
                this.maxSharedConnectionCount = 10;
                log.error((Object)"Error in setting up the max shared jms connection count. Setting it to default value 10 ", (Throwable)e);
            }
        }
    }

    public synchronized void stop() {
        if (this.sharedConnection != null) {
            try {
                this.sharedConnection.close();
            }
            catch (JMSException e) {
                log.warn((Object)("Error shutting down connection factory : " + JMSUtils.maskURLPasswordAndCredentials(this.name)), (Throwable)e);
            }
        }
        if (this.context != null) {
            try {
                this.context.close();
            }
            catch (NamingException e) {
                log.warn((Object)("Error while closing the InitialContext of factory : " + JMSUtils.maskURLPasswordAndCredentials(this.name)), (Throwable)e);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Hashtable<String, String> getParameters() {
        return this.parameters;
    }

    public Context getContext() {
        return this.context;
    }

    public int getCacheLevel() {
        return this.cacheLevel;
    }

    public Destination getSharedDestination() {
        return this.sharedDestination;
    }

    public Destination getDestination(String destinationName, String destinationType) {
        try {
            return JMSUtils.lookupDestination(this.context, destinationName, destinationType);
        }
        catch (NamingException e) {
            this.handleException("Error looking up the JMS destination with name " + destinationName + " of type " + destinationType, e);
            return null;
        }
    }

    public String getReplyToDestination() {
        return this.parameters.get("transport.jms.ReplyDestination");
    }

    public String getReplyDestinationType() {
        return this.parameters.get("transport.jms.ReplyDestinationType") != null ? this.parameters.get("transport.jms.ReplyDestinationType") : "generic";
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new AxisJMSException(msg, e);
    }

    public boolean isJmsSpec11() {
        return this.parameters.get("transport.jms.JMSSpecVersion") == null || "1.1".equals(this.parameters.get("transport.jms.JMSSpecVersion"));
    }

    public boolean isJmsSpec20() {
        return "2.0".equals(this.parameters.get("transport.jms.JMSSpecVersion"));
    }

    public String jmsSpecVersion() {
        if (this.isJmsSpec11()) {
            return "1.1";
        }
        if (this.isJmsSpec20()) {
            return "2.0";
        }
        return "1.0.2b";
    }

    public Boolean isQueue() {
        if (this.parameters.get("transport.jms.ConnectionFactoryType") == null && this.parameters.get("transport.jms.DestinationType") == null) {
            return null;
        }
        if (this.parameters.get("transport.jms.ConnectionFactoryType") != null) {
            if ("queue".equalsIgnoreCase(this.parameters.get("transport.jms.ConnectionFactoryType"))) {
                return true;
            }
            if ("topic".equalsIgnoreCase(this.parameters.get("transport.jms.ConnectionFactoryType"))) {
                return false;
            }
            throw new AxisJMSException("Invalid transport.jms.ConnectionFactoryType : " + this.parameters.get("transport.jms.ConnectionFactoryType") + " for JMS CF : " + JMSUtils.maskURLPasswordAndCredentials(this.name));
        }
        if ("queue".equalsIgnoreCase(this.parameters.get("transport.jms.DestinationType"))) {
            return true;
        }
        if ("topic".equalsIgnoreCase(this.parameters.get("transport.jms.DestinationType"))) {
            return false;
        }
        throw new AxisJMSException("Invalid transport.jms.DestinationType : " + this.parameters.get("transport.jms.DestinationType") + " for JMS CF : " + JMSUtils.maskURLPasswordAndCredentials(this.name));
    }

    private boolean isSessionTransacted() {
        return this.parameters.get("transport.jms.SessionTransacted") != null && Boolean.valueOf(this.parameters.get("transport.jms.SessionTransacted")) != false;
    }

    private boolean isDurable() {
        if (this.parameters.get("transport.jms.SubscriptionDurable") != null) {
            return Boolean.valueOf(this.parameters.get("transport.jms.SubscriptionDurable"));
        }
        return false;
    }

    private boolean isSharedSubscription() {
        if (this.parameters.get("transport.jms.SharedSubscription") != null) {
            return Boolean.valueOf(this.parameters.get("transport.jms.SharedSubscription"));
        }
        return false;
    }

    private String getClientId() {
        return this.parameters.get("transport.jms.DurableSubscriberClientID");
    }

    private Connection createConnection() {
        Connection connection = null;
        try {
            connection = JMSUtils.createConnection(this.conFactory, this.parameters.get("transport.jms.UserName"), this.parameters.get("transport.jms.Password"), this.jmsSpecVersion(), this.isQueue(), this.isDurable(), this.getClientId(), this.isSharedSubscription());
            if (log.isDebugEnabled()) {
                log.debug((Object)("New JMS Connection from JMS CF : " + JMSUtils.maskURLPasswordAndCredentials(this.name) + " created"));
            }
        }
        catch (JMSException e) {
            this.handleException("Error acquiring a Connection from the JMS CF : " + JMSUtils.maskURLPasswordAndCredentials(this.name) + " using properties : " + JMSUtils.maskAxis2ConfigSensitiveParameters(this.parameters), (Exception)((Object)e));
        }
        return connection;
    }

    private Session createSession(Connection connection) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating a new JMS Session from JMS CF : " + JMSUtils.maskURLPasswordAndCredentials(this.name)));
            }
            return JMSUtils.createSession(connection, this.isSessionTransacted(), 1, this.jmsSpecVersion(), this.isQueue());
        }
        catch (JMSException e) {
            try {
                this.clearSharedConnections();
                return JMSUtils.createSession(this.getConnection(), this.isSessionTransacted(), 1, this.jmsSpecVersion(), this.isQueue());
            }
            catch (JMSException e1) {
                this.handleException("Error creating JMS session from JMS CF : " + JMSUtils.maskURLPasswordAndCredentials(this.name), (Exception)((Object)e));
                log.info((Object)"Detected a stale connection. Hence refreshing the connection cache map.");
                return null;
            }
        }
    }

    private MessageProducer createProducer(Session session, Destination destination) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating a new JMS MessageProducer from JMS CF : " + JMSUtils.maskURLPasswordAndCredentials(this.name)));
            }
            return JMSUtils.createProducer(session, destination, this.isQueue(), this.jmsSpecVersion());
        }
        catch (JMSException e) {
            this.handleException("Error creating JMS producer from JMS CF : " + JMSUtils.maskURLPasswordAndCredentials(this.name), (Exception)((Object)e));
            return null;
        }
    }

    public Connection getConnection() {
        if (this.cacheLevel > 0) {
            return this.getSharedConnection();
        }
        return this.createConnection();
    }

    public Session getSession(Connection connection) {
        if (this.cacheLevel > 1) {
            return this.getSharedSession();
        }
        return this.createSession(connection == null ? this.getConnection() : connection);
    }

    public MessageProducer getMessageProducer(Connection connection, Session session, Destination destination) {
        if (this.cacheLevel > 2) {
            return this.getNullDestinationSharedProducer();
        }
        return this.createProducer(session == null ? this.getSession(connection) : session, destination);
    }

    private synchronized MessageProducer getNullDestinationSharedProducer() {
        if (this.sharedProducer == null) {
            this.sharedProducer = this.createProducer(this.getSharedSession(), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created shared JMS MessageConsumer with no destination specified, for JMS CF : " + JMSUtils.maskURLPasswordAndCredentials(this.name) + " , with producer caching enabled"));
            }
        }
        return this.sharedProducer;
    }

    private synchronized Connection getSharedConnection() {
        Connection connection = this.sharedConnectionMap.get(this.lastReturnedConnectionIndex);
        if (connection == null) {
            connection = this.createConnection();
            this.sharedConnectionMap.put(this.lastReturnedConnectionIndex, connection);
        }
        ++this.lastReturnedConnectionIndex;
        if (this.lastReturnedConnectionIndex >= this.maxSharedConnectionCount) {
            this.lastReturnedConnectionIndex = 0;
        }
        return connection;
    }

    private synchronized Session getSharedSession() {
        if (this.sharedSession == null) {
            this.sharedSession = this.createSession(this.getSharedConnection());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created shared JMS Session for JMS CF : " + JMSUtils.maskURLPasswordAndCredentials(this.name)));
            }
        }
        return this.sharedSession;
    }

    private synchronized MessageProducer getSharedProducer() {
        if (this.sharedProducer == null) {
            this.sharedProducer = this.createProducer(this.getSharedSession(), this.sharedDestination);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created shared JMS MessageConsumer for JMS CF : " + JMSUtils.maskURLPasswordAndCredentials(this.name)));
            }
        }
        return this.sharedProducer;
    }

    private synchronized void clearSharedConnections() {
        for (Map.Entry<Integer, Connection> connectionMap : this.sharedConnectionMap.entrySet()) {
            try {
                if (connectionMap.getValue() == null) continue;
                connectionMap.getValue().close();
            }
            catch (JMSException e) {
                log.warn((Object)"Error while shutting down the connection : ", (Throwable)e);
            }
        }
        this.sharedConnectionMap.clear();
        this.lastReturnedConnectionIndex = 0;
    }

    private synchronized void clearSharedSession() {
        this.sharedSession = null;
    }

    private synchronized void clearSharedProducer() {
        this.sharedProducer = null;
    }

    public void clearCache() {
        this.clearSharedProducer();
        this.clearSharedSession();
        this.clearSharedConnections();
    }
}

