/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.generic.ui.utils;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.registry.common.ui.utils.TreeNode;
import org.wso2.carbon.registry.common.ui.utils.TreeNodeBuilderUtil;
import org.wso2.carbon.registry.common.ui.utils.UIUtil;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class WADLTreeNodeBuilder {
    private OMElement wadlElement;
    private String wadlPath;
    private String wadlNamespace;

    public WADLTreeNodeBuilder(String wadlPath, String wadlContent) throws Exception {
        this.wadlElement = UIUtil.buildOMElement((String)wadlContent);
        this.wadlPath = wadlPath;
    }

    public TreeNode buildTree() throws Exception {
        String wadlName = RegistryUtils.getResourceName((String)this.wadlPath);
        this.wadlNamespace = this.wadlElement.getNamespace().getNamespaceURI();
        TreeNode root = new TreeNode(TreeNodeBuilderUtil.generateKeyName((String)"WADL", (String)wadlName));
        OMElement grammarsElement = this.wadlElement.getFirstChildWithName(new QName(this.wadlNamespace, "grammars"));
        if (grammarsElement != null) {
            TreeNode grammarsNode = new TreeNode("Grammars");
            Iterator grammarElements = grammarsElement.getChildrenWithName(new QName(this.wadlNamespace, "include"));
            while (grammarElements.hasNext()) {
                grammarsNode.addChild((Object)new TreeNode("Include", ((OMElement)grammarElements.next()).getAttributeValue(new QName("href"))));
            }
            root.addChild((Object)grammarsNode);
        }
        TreeNode resourcesNode = new TreeNode("Resources");
        OMElement resourcesElement = this.wadlElement.getFirstChildWithName(new QName(this.wadlNamespace, "resources"));
        resourcesNode.addChild((Object)new TreeNode("Base", resourcesElement.getAttributeValue(new QName("base"))));
        Iterator resourceElements = resourcesElement.getChildrenWithName(new QName(this.wadlNamespace, "resource"));
        while (resourceElements.hasNext()) {
            this.addResourceNodesRecursively((OMElement)resourceElements.next(), resourcesNode);
        }
        root.addChild((Object)resourcesNode);
        return root;
    }

    private void addResourceNodesRecursively(OMElement resourceElement, TreeNode parentNode) {
        String path = resourceElement.getAttributeValue(new QName("path"));
        TreeNode resourceNode = new TreeNode(TreeNodeBuilderUtil.generateKeyName((String)"Resource", (String)path));
        Iterator methodElements = resourceElement.getChildrenWithName(new QName(this.wadlNamespace, "method"));
        while (methodElements.hasNext()) {
            this.addMethodNode((OMElement)methodElements.next(), resourceNode);
        }
        Iterator childResourceElements = resourceElement.getChildrenWithName(new QName(this.wadlNamespace, "resource"));
        while (childResourceElements.hasNext()) {
            this.addResourceNodesRecursively((OMElement)childResourceElements.next(), resourceNode);
        }
        parentNode.addChild((Object)resourceNode);
    }

    private void addMethodNode(OMElement methodElement, TreeNode resourceNode) {
        String methodName = methodElement.getAttributeValue(new QName("name"));
        OMElement requestElement = methodElement.getFirstChildWithName(new QName(this.wadlNamespace, "request"));
        Iterator responseElements = methodElement.getChildrenWithName(new QName(this.wadlNamespace, "response"));
        TreeNode methodNode = requestElement != null || responseElements.hasNext() ? new TreeNode(TreeNodeBuilderUtil.generateKeyName((String)"Method", (String)methodName)) : new TreeNode("Method", methodName);
        if (requestElement != null) {
            this.addRequestNode(requestElement, methodNode);
        }
        while (responseElements.hasNext()) {
            this.addResponseNode((OMElement)responseElements.next(), methodNode);
        }
        resourceNode.addChild((Object)methodNode);
    }

    private void addRequestNode(OMElement requestElement, TreeNode methodNode) {
        TreeNode requestNode = new TreeNode("Request");
        Iterator paramElements = requestElement.getChildrenWithName(new QName(this.wadlNamespace, "param"));
        while (paramElements.hasNext()) {
            String paramStyle;
            OMElement paramElement = (OMElement)paramElements.next();
            String paramName = paramElement.getAttributeValue(new QName("name"));
            TreeNode paramNode = new TreeNode(TreeNodeBuilderUtil.generateKeyName((String)"Parameter", (String)paramName));
            String paramType = paramElement.getAttributeValue(new QName("type"));
            if (paramType != null) {
                paramNode.addChild((Object)new TreeNode("Type", paramType));
            }
            if ((paramStyle = paramElement.getAttributeValue(new QName("style"))) != null) {
                paramNode.addChild((Object)new TreeNode("Style", paramStyle));
            }
            requestNode.addChild((Object)paramNode);
        }
        methodNode.addChild((Object)requestNode);
    }

    private void addResponseNode(OMElement responseElement, TreeNode methodNode) {
        TreeNode responseNode = new TreeNode("Response");
        OMElement representationElement = responseElement.getFirstChildWithName(new QName(this.wadlNamespace, "representation"));
        if (representationElement != null) {
            responseNode.addChild((Object)new TreeNode("Mediatype", representationElement.getAttributeValue(new QName("mediaType"))));
        }
        methodNode.addChild((Object)responseNode);
    }
}

