/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.generic.ui.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.registry.common.ui.utils.TreeNode;
import org.wso2.carbon.registry.common.ui.utils.TreeNodeBuilderUtil;
import org.wso2.carbon.registry.common.ui.utils.UIUtil;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class SchemaTreeNodeBuilder {
    private String schemaPath;
    private OMElement schemaElement;
    private String actualSchemaPath;

    public SchemaTreeNodeBuilder(String path, String content) throws Exception {
        this.schemaPath = path;
        this.schemaElement = UIUtil.buildOMElement((String)content);
    }

    public TreeNode buildTree() throws Exception {
        String schemaName = RegistryUtils.getResourceName((String)this.schemaPath);
        ArrayList<String> attributeList = new ArrayList<String>();
        attributeList.add("name");
        TreeNode root = new TreeNode(TreeNodeBuilderUtil.generateKeyName((String)"Schema", (String)schemaName));
        this.addSchemaDataToTreeWithHyperlink("//xsd:schema/@targetNamespace", "TargetNamespace", root, this.schemaElement, false);
        attributeList.add("ref");
        this.addSchemaDataToTree("//xsd:element", "Elements", root, this.schemaElement, attributeList);
        attributeList.remove("ref");
        this.addSchemaDataToTree("//xsd:attribute", "Attributes", root, this.schemaElement, attributeList);
        this.addSchemaDataToTree("//xsd:group", "Groups", root, this.schemaElement, attributeList);
        this.addSchemaDataToTreeWithHyperlink("//xsd:include/@schemaLocation", "Includes", root, this.schemaElement, true);
        attributeList.clear();
        attributeList.add("schemaLocation");
        attributeList.add("namespace");
        this.addSchemaDataToTreeWithHyperlink("//xsd:import/@schemaLocation", "Imports", root, this.schemaElement, true);
        return root;
    }

    public void addSchemaDataToTree(String xPath, String headingName, TreeNode root, OMElement scope, List<String> attributes) throws Exception {
        List list = TreeNodeBuilderUtil.evaluateXPathToElements((String)xPath, (OMElement)scope);
        TreeNode nodes = new TreeNode(headingName);
        for (OMElement element : list) {
            Iterator<String> attributeIt = attributes.iterator();
            String elementValue = "";
            while (attributeIt.hasNext()) {
                String attributeName = attributeIt.next();
                if (element.getAttributeValue(new QName(attributeName)) == null) continue;
                elementValue = elementValue + attributeName + ":" + element.getAttributeValue(new QName(attributeName));
                TreeNode elementNode = new TreeNode(elementValue);
                nodes.addChild((Object)elementNode);
            }
        }
        if (nodes.getChildNodes() != null) {
            root.addChild((Object)nodes);
        }
    }

    public void addSchemaDataWithAttributesToTree(String xPath, String headingName, TreeNode root, OMElement scope, List<String> attributes) throws Exception {
        List list = TreeNodeBuilderUtil.evaluateXPathToAttributes((String)xPath, (OMElement)scope);
        TreeNode nodes = new TreeNode(headingName);
        for (OMAttribute element : list) {
            Iterator<String> attributeIt = attributes.iterator();
            String elementValue = "";
            while (attributeIt.hasNext()) {
                String attributeName = attributeIt.next();
                if (!element.getQName().equals(new QName(attributeName))) continue;
                elementValue = elementValue + attributeName + ":" + element.getAttributeValue();
                TreeNode elementNode = new TreeNode(elementValue);
                nodes.addChild((Object)elementNode);
            }
        }
        if (nodes.getChildNodes() != null) {
            root.addChild((Object)nodes);
        }
    }

    public void addSchemaDataToTreeWithHyperlink(String xPath, String headingName, TreeNode root, OMElement element, boolean isLink) throws Exception {
        List list = TreeNodeBuilderUtil.evaluateXPathToValues((String)xPath, (OMElement)element);
        TreeNode nodes = new TreeNode(headingName);
        for (String urls : list) {
            String registryUrl;
            if (isLink) {
                registryUrl = TreeNodeBuilderUtil.calculateAbsolutePath((String)this.schemaPath, (String)urls);
                registryUrl = "<a href='resource.jsp?path=" + registryUrl + "'>" + urls + "</a>";
            } else {
                registryUrl = urls;
            }
            TreeNode elementNode = new TreeNode(registryUrl);
            nodes.addChild((Object)elementNode);
        }
        if (nodes.getChildNodes() != null) {
            root.addChild((Object)nodes);
        }
    }

    public void setActualSchemaPath(String actualSchemaPath) {
        this.actualSchemaPath = actualSchemaPath;
    }
}

