/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.generic.ui.utils;

import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.generic.ui.clients.ManageGenericArtifactServiceClient;
import org.wso2.carbon.governance.generic.ui.utils.DropDownDataPopulator;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class LifecycleListPopulator
implements DropDownDataPopulator {
    private static final Log log = LogFactory.getLog(LifecycleListPopulator.class);

    @Override
    public String[] getList(HttpServletRequest request, ServletConfig config) {
        try {
            ManageGenericArtifactServiceClient client = new ManageGenericArtifactServiceClient(config, request.getSession());
            String[] lifeCycleList = client.getAvailableAspects();
            if (lifeCycleList != null) {
                ArrayList<String> output = new ArrayList<String>(Arrays.asList(lifeCycleList));
                output.add(0, "None");
                return output.toArray(new String[output.size()]);
            }
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while obtaining the list of lifecycles.", (Throwable)e);
        }
        return new String[0];
    }

    @Override
    public String[] getList(String uuid, String path, Registry registry) {
        try {
            String[] lifeCycleList = GovernanceUtils.getAvailableAspects();
            if (lifeCycleList != null) {
                ArrayList<String> output = new ArrayList<String>(Arrays.asList(lifeCycleList));
                output.add(0, "None");
                return output.toArray(new String[output.size()]);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"An error occurred while obtaining the list of lifecycles.", (Throwable)e);
        }
        return new String[0];
    }
}

