/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.generic.ui.utils;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.generic.ui.common.dataobjects.AddLink;
import org.wso2.carbon.governance.generic.ui.common.dataobjects.CheckBox;
import org.wso2.carbon.governance.generic.ui.common.dataobjects.CloseAddLink;
import org.wso2.carbon.governance.generic.ui.common.dataobjects.DateField;
import org.wso2.carbon.governance.generic.ui.common.dataobjects.DropDown;
import org.wso2.carbon.governance.generic.ui.common.dataobjects.OptionText;
import org.wso2.carbon.governance.generic.ui.common.dataobjects.TextArea;
import org.wso2.carbon.governance.generic.ui.common.dataobjects.TextField;
import org.wso2.carbon.governance.generic.ui.common.dataobjects.UIComponent;
import org.wso2.carbon.governance.generic.ui.utils.DropDownDataPopulator;
import org.wso2.carbon.governance.generic.ui.utils.GenericUtil;
import org.wso2.carbon.ui.CarbonUIUtil;

public class GenericUIGenerator {
    private static final Log log = LogFactory.getLog(GenericUIGenerator.class);
    private String dataElement;
    private String dataNamespace;

    public GenericUIGenerator() {
        this("serviceMetaData", "http://www.wso2.org/governance/metadata");
    }

    public GenericUIGenerator(String dataElement, String dataNamespace) {
        this.dataElement = dataElement;
        this.dataNamespace = dataNamespace;
    }

    public OMElement getUIConfiguration(String content, HttpServletRequest request, ServletConfig config, HttpSession session) throws Exception {
        OMElement omElement = null;
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(content));
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            omElement = builder.getDocumentElement();
        }
        catch (XMLStreamException e) {
            log.error((Object)"Unable to parse the UI configuration.", (Throwable)e);
        }
        return omElement;
    }

    public String printWidgetWithValues(OMElement widget, OMElement data, boolean isFilterOperation, HttpServletRequest request, ServletConfig config) {
        return this.printWidgetWithValues(widget, data, isFilterOperation, true, true, request, config);
    }

    public String printWidgetWithValues(OMElement widget, OMElement data, boolean isFilterOperation, boolean markReadonly, boolean hasValue, HttpServletRequest request, ServletConfig config) {
        if (isFilterOperation && Boolean.toString(false).equals(widget.getAttributeValue(new QName(null, "filter")))) {
            return "";
        }
        int columns = 2;
        String widgetName = widget.getAttributeValue(new QName(null, "name"));
        boolean collapsed = true;
        String widgetCollapse = widget.getAttributeValue(new QName(null, "collapsed"));
        if (widgetCollapse != null) {
            collapsed = Boolean.valueOf(widgetCollapse);
        }
        String divId = "_collapse_id_" + widgetName.replaceAll(" ", "");
        OMElement dataHead = null;
        if (data != null) {
            dataHead = GenericUtil.getChildWithName(data, widgetName, this.dataNamespace);
        }
        if (widget.getAttributeValue(new QName(null, "columns")) != null) {
            columns = Integer.parseInt(widget.getAttributeValue(new QName(null, "columns")));
        }
        Iterator subHeadingIt = widget.getChildrenWithName(new QName(null, "subheading"));
        StringBuilder table = new StringBuilder();
        table.append("<div id=\"" + divId + "\"  onmouseover='title=\"\"' onmouseout='title=\"" + String.valueOf(collapsed) + "\"' title=\"" + String.valueOf(collapsed) + "\"><table class=\"normal-nopadding\" cellspacing=\"0\">");
        ArrayList<String> subList = new ArrayList<String>();
        OMElement sub = null;
        if (subHeadingIt != null && subHeadingIt.hasNext()) {
            sub = (OMElement)subHeadingIt.next();
        }
        if (sub != null && "subheading".equals(sub.getLocalName())) {
            Iterator headingList = sub.getChildrenWithLocalName("heading");
            while (headingList.hasNext()) {
                OMElement subheading = (OMElement)headingList.next();
                subList.add(subheading.getText());
            }
            if (subList.size() > columns) {
                return "";
            }
        }
        table.append(this.printMainHeader(widgetName, columns));
        String widgetMaxOccurs = widget.getAttributeValue(new QName(null, "maxoccurs"));
        if (subList.size() > 2 && widgetMaxOccurs == null) {
            table.append(GenericUIGenerator.printSubHeaders(subList.toArray(new String[subList.size()])));
        }
        Iterator arguments = widget.getChildrenWithLocalName("field");
        int columnCount = 0;
        int rowCount = 0;
        OMElement inner = null;
        if (widgetMaxOccurs != null) {
            if ("unbounded".equals(widgetMaxOccurs)) {
                this.processElements(widget, data, request, config, widgetName, table, subList);
            }
        } else {
            while (arguments.hasNext()) {
                OMElement arg = (OMElement)arguments.next();
                String maxOccurs = "";
                if (!"field".equals(arg.getLocalName()) || isFilterOperation && Boolean.toString(false).equals(arg.getAttributeValue(new QName(null, "filter")))) continue;
                ++rowCount;
                String elementType = arg.getAttributeValue(new QName(null, "type"));
                String tooltip = arg.getAttributeValue(new QName(null, "tooltip"));
                if (tooltip == null) {
                    tooltip = "";
                }
                tooltip = StringEscapeUtils.escapeHtml((String)tooltip);
                maxOccurs = arg.getAttributeValue(new QName(null, "maxoccurs"));
                if (maxOccurs != null) {
                    if (!"bounded".equals(maxOccurs) && !"unbounded".equals(maxOccurs)) {
                        return "";
                    }
                    if (!"unbounded".equals(maxOccurs) && rowCount == 1) {
                        table.append(GenericUIGenerator.printSubHeaders(subList.toArray(new String[subList.size()])));
                    }
                } else if (subList.size() == 2 && rowCount == 1) {
                    table.append(GenericUIGenerator.printSubHeaders(subList.toArray(new String[subList.size()])));
                }
                if (dataHead != null) {
                    inner = GenericUtil.getChildWithName(dataHead, arg.getFirstChildWithName(new QName(null, "name")).getText().replaceAll(" ", "-"), this.dataNamespace);
                }
                if ("text".equals(elementType)) {
                    columnCount = this.handleTextField(isFilterOperation, markReadonly, hasValue, request, columns, widgetName, table, columnCount, inner, arg, tooltip);
                    continue;
                }
                if ("date".equals(elementType)) {
                    columnCount = this.handleDateField(isFilterOperation, markReadonly, columns, widgetName, table, columnCount, inner, arg, tooltip);
                    continue;
                }
                if ("options".equals(elementType)) {
                    columnCount = this.handleOptionField(isFilterOperation, markReadonly, request, config, columns, widgetName, table, columnCount, inner, arg, tooltip);
                    continue;
                }
                if ("checkbox".equals(elementType)) {
                    columnCount = this.handleCheckBox(columns, widgetName, table, columnCount, inner, arg, tooltip);
                    continue;
                }
                if ("text-area".equals(elementType)) {
                    columnCount = this.handleTextArea(isFilterOperation, markReadonly, columns, widgetName, table, columnCount, inner, arg, tooltip);
                    continue;
                }
                if (!"option-text".equals(elementType)) continue;
                inner = this.handleOptionTextField(request, config, widgetName, dataHead, table, subList, inner, arg, maxOccurs, tooltip);
            }
        }
        table.append("</table></div>");
        return table.toString();
    }

    private void processElements(OMElement widget, OMElement data, HttpServletRequest request, ServletConfig config, String widgetName, StringBuilder table, List<String> subList) {
        ArrayList<OMElement> dataElements = new ArrayList();
        if (data != null) {
            dataElements = GenericUtil.getChildsWithName(data, widgetName, this.dataNamespace);
        }
        ArrayList<Map<String, String>> addedValues = new ArrayList<Map<String, String>>();
        int addedItemsCount = this.addRxtProperties(dataElements, addedValues);
        boolean isDisplay = false;
        if (addedItemsCount != 0) {
            isDisplay = true;
        }
        if (subList.size() == 0) {
            this.addHeaders(widget, subList);
        }
        AddLink addLink = new AddLink(widgetName, widgetName, null, "../admin/images/add.gif", widgetName, subList.toArray(new String[subList.size() + 1]), false, null, isDisplay, false);
        table.append(((UIComponent)addLink).generate());
        for (int i = 0; i < addedItemsCount; ++i) {
            Iterator argument = widget.getChildrenWithLocalName("field");
            int a = 0;
            table.append("<tr>");
            while (argument.hasNext()) {
                OMElement arg = (OMElement)argument.next();
                String elementType = arg.getAttributeValue(new QName(null, "type"));
                if ("field".equals(arg.getLocalName())) {
                    String tooltip;
                    String value;
                    String name = arg.getFirstChildWithName(new QName(null, "name")).getText();
                    String label = null;
                    if (subList.size() == 0 && (label = arg.getAttributeValue(new QName("label"))) == null) {
                        label = name;
                    }
                    if ((value = arg.getAttributeValue(new QName(null, "default"))) == null) {
                        String key = GenericUtil.getDataElementName(name);
                        value = (String)((Map)addedValues.get(i)).get(key);
                    }
                    String elementId = "id_" + widgetName.replaceAll(" ", "") + "_" + name.replaceAll(" ", "") + "_" + (i + 1);
                    name = name.replaceAll(" ", "") + "_" + (i + 1);
                    boolean isReadOnly = false;
                    if ("true".equals(arg.getAttributeValue(new QName(null, "readonly")))) {
                        isReadOnly = true;
                    }
                    if ((tooltip = arg.getAttributeValue(new QName(null, "tooltip"))) == null) {
                        tooltip = "";
                    }
                    tooltip = StringEscapeUtils.escapeHtml((String)tooltip);
                    if ("date".equals(elementType)) {
                        DateField dateField = new DateField(label, name, elementId, null, widgetName, value, isReadOnly, tooltip, false, false);
                        table.append(((UIComponent)dateField).generate());
                    } else if ("checkbox".equals(elementType)) {
                        CheckBox checkBox = new CheckBox(label, name, elementId, widgetName, value, tooltip, false, false);
                        table.append(((UIComponent)checkBox).generate());
                    } else if ("options".equals(elementType)) {
                        List<String> optionValues = this.getOptionValues(arg, request, config);
                        DropDown dropDown = new DropDown(label, isReadOnly, name, elementId, null, optionValues.toArray(new String[optionValues.size()]), widgetName, value, tooltip, false);
                        table.append(dropDown.generate());
                    } else if ("text-area".equals(elementType)) {
                        String widthString;
                        int height = -1;
                        int width = 200;
                        String heightString = arg.getAttributeValue(new QName(null, "height"));
                        if (heightString != null) {
                            try {
                                height = Integer.parseInt(heightString);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if ((widthString = arg.getAttributeValue(new QName(null, "width"))) != null) {
                            try {
                                width = Integer.parseInt(widthString);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        TextArea textArea = new TextArea(label, name, elementId, null, widgetName, value, height, width, isReadOnly, false, tooltip, false, false);
                        table.append(((UIComponent)textArea).generate());
                    } else {
                        boolean isURL = Boolean.toString(true).equals(arg.getAttributeValue(new QName(null, "url")));
                        String urlTemplate = arg.getAttributeValue(new QName(null, "template"));
                        boolean isPath = Boolean.toString(true).equals(arg.getAttributeValue(new QName(null, "path")));
                        String startsWith = arg.getAttributeValue(new QName(null, "startsWith"));
                        TextField textField = new TextField(label, name, elementId, null, widgetName, value, isURL, urlTemplate, isPath, isReadOnly, true, tooltip, startsWith, request, false);
                        table.append(((UIComponent)textField).generate());
                    }
                }
                ++a;
            }
            table.append(this.printDeleteWidget(widgetName));
            table.append("</tr>");
        }
        table.append(this.printCloseAddLink(widgetName, addedItemsCount));
    }

    private OMElement handleOptionTextField(HttpServletRequest request, ServletConfig config, String widgetName, OMElement dataHead, StringBuilder table, List<String> subList, OMElement inner, OMElement arg, String maxOccurs, String tooltip) {
        String optionValue = null;
        if ("unbounded".equals(maxOccurs)) {
            OMElement firstChildWithName = arg.getFirstChildWithName(new QName(null, "name"));
            String name = firstChildWithName.getText();
            String label = firstChildWithName.getAttributeValue(new QName("label"));
            if (label == null) {
                label = name;
            }
            boolean isURL = Boolean.toString(true).equals(arg.getAttributeValue(new QName(null, "url")));
            String urlTemplate = arg.getAttributeValue(new QName(null, "template"));
            boolean isPath = Boolean.toString(true).equals(arg.getAttributeValue(new QName(null, "path")));
            String startsWith = arg.getAttributeValue(new QName(null, "startsWith"));
            ArrayList<String> addedOptionValues = new ArrayList<String>();
            ArrayList<String> addedValues = new ArrayList<String>();
            int addedItemsCount = 0;
            if (dataHead != null) {
                addedItemsCount = this.fillOptionValues(dataHead, addedOptionValues, addedValues);
            }
            boolean isDisplay = false;
            if (addedItemsCount == 0) {
                isDisplay = false;
            } else if (addedItemsCount > 0) {
                isDisplay = true;
            }
            AddLink addLink = new AddLink(label, name, null, "../admin/images/add.gif", widgetName, subList.toArray(new String[subList.size() + 1]), isPath, startsWith, isDisplay, false);
            table.append(((UIComponent)addLink).generate());
            List<String> optionValues = this.getOptionValues(arg, request, config);
            if (addedItemsCount > 0) {
                for (int i = 0; i < addedItemsCount; ++i) {
                    String addedOptionValue = (String)addedOptionValues.get(i);
                    String addedValue = (String)addedValues.get(i);
                    if (addedOptionValue == null || addedValue == null) continue;
                    OptionText optionText = new OptionText(name, i + 1, null, null, null, optionValues.toArray(new String[optionValues.size()]), widgetName, addedOptionValue, addedValue, isURL, urlTemplate, isPath, tooltip, startsWith, request, false);
                    table.append(((UIComponent)optionText).generate());
                }
            }
            CloseAddLink closeAddLink = new CloseAddLink(name, addedItemsCount, false);
            table.append(((UIComponent)closeAddLink).generate());
        } else {
            OMElement firstChildWithName = arg.getFirstChildWithName(new QName(null, "name"));
            String name = firstChildWithName.getText();
            String label = firstChildWithName.getAttributeValue(new QName("label"));
            String value = null;
            String startsWith = arg.getAttributeValue(new QName(null, "startsWith"));
            if (label == null) {
                label = name;
            }
            boolean isURL = Boolean.toString(true).equals(arg.getAttributeValue(new QName(null, "url")));
            String urlTemplate = arg.getAttributeValue(new QName(null, "template"));
            boolean isPath = Boolean.toString(true).equals(arg.getAttributeValue(new QName(null, "path")));
            if (dataHead != null) {
                OMElement optionValueElement;
                inner = GenericUtil.getChildWithName(dataHead, "text" + arg.getFirstChildWithName(new QName(null, "name")).getText(), this.dataNamespace);
                if (inner != null) {
                    value = inner.getText();
                }
                if ((optionValueElement = GenericUtil.getChildWithName(dataHead, arg.getFirstChildWithName(new QName(null, "name")).getText(), this.dataNamespace)) != null) {
                    optionValue = optionValueElement.getText();
                }
            }
            List<String> optionValues = this.getOptionValues(arg, request, config);
            OptionText optionText = new OptionText(null, 0, label, name, null, optionValues.toArray(new String[optionValues.size()]), widgetName, optionValue, value, isURL, urlTemplate, isPath, tooltip, startsWith, request, false);
            table.append(((UIComponent)optionText).generate());
        }
        return inner;
    }

    private int handleOptionField(boolean isFilterOperation, boolean markReadonly, HttpServletRequest request, ServletConfig config, int columns, String widgetName, StringBuilder table, int columnCount, OMElement inner, OMElement arg, String tooltip) {
        OMElement firstChildWithName = arg.getFirstChildWithName(new QName(null, "name"));
        String mandat = arg.getAttributeValue(new QName(null, "required"));
        String name = firstChildWithName.getText();
        String label = firstChildWithName.getAttributeValue(new QName("label"));
        String optionValue = null;
        boolean isReadOnly = false;
        if (markReadonly && "true".equals(arg.getAttributeValue(new QName(null, "readonly")))) {
            isReadOnly = true;
        }
        if (label == null) {
            label = name;
        }
        if (inner != null) {
            optionValue = inner.getText();
        }
        List<String> optionValues = this.getOptionValues(arg, request, config);
        if (isFilterOperation) {
            optionValues.add(0, "");
        }
        if (columns > 2) {
            if (columnCount == 0) {
                table.append("<tr>");
            }
            DropDown dropDown = new DropDown(null, isReadOnly, name, null, null, optionValues.toArray(new String[optionValues.size()]), widgetName, optionValue, tooltip, false);
            table.append(((UIComponent)dropDown).generate());
            if (++columnCount == columns) {
                table.append("</tr>");
                columnCount = 0;
            }
        } else {
            DropDown dropDown = new DropDown(label, isReadOnly, name, null, mandat, optionValues.toArray(new String[optionValues.size()]), widgetName, optionValue, tooltip, false);
            table.append(((UIComponent)dropDown).generate());
        }
        return columnCount;
    }

    private int handleDateField(boolean isFilterOperation, boolean markReadonly, int columns, String widgetName, StringBuilder table, int columnCount, OMElement inner, OMElement arg, String tooltip) {
        String mandet = arg.getAttributeValue(new QName(null, "required"));
        boolean isReadOnly = false;
        String value = null;
        if (markReadonly && "true".equals(arg.getAttributeValue(new QName(null, "readonly")))) {
            isReadOnly = true;
        }
        if (isFilterOperation) {
            mandet = "false";
        }
        if (inner != null) {
            value = inner.getText();
        }
        if (columns > 2) {
            if (columnCount == 0) {
                table.append("<tr>");
            }
            DateField dateField = new DateField(null, arg.getFirstChildWithName(new QName(null, "name")).getText(), null, null, widgetName, value, isReadOnly, tooltip, false, false);
            table.append(((UIComponent)dateField).generate());
            if (++columnCount == columns) {
                table.append("</tr>");
                columnCount = 0;
            }
        } else {
            OMElement firstChildWithName = arg.getFirstChildWithName(new QName(null, "name"));
            String name = firstChildWithName.getText();
            String label = firstChildWithName.getAttributeValue(new QName("label"));
            if (label == null) {
                label = name;
            }
            DateField dateField = new DateField(label, name, null, mandet, widgetName, value, isReadOnly, tooltip, true, false);
            table.append(((UIComponent)dateField).generate());
        }
        return columnCount;
    }

    private int handleTextField(boolean isFilterOperation, boolean markReadonly, boolean hasValue, HttpServletRequest request, int columns, String widgetName, StringBuilder table, int columnCount, OMElement inner, OMElement arg, String tooltip) {
        String mandat = arg.getAttributeValue(new QName(null, "required"));
        boolean isReadOnly = false;
        if (markReadonly && "true".equals(arg.getAttributeValue(new QName(null, "readonly")))) {
            isReadOnly = true;
        }
        if (isFilterOperation) {
            mandat = "false";
        }
        boolean isURL = Boolean.toString(true).equals(arg.getAttributeValue(new QName(null, "url")));
        String urlTemplate = arg.getAttributeValue(new QName(null, "template"));
        boolean isPath = Boolean.toString(true).equals(arg.getAttributeValue(new QName(null, "path")));
        String startsWith = arg.getAttributeValue(new QName(null, "startsWith"));
        String value = inner != null ? inner.getText() : arg.getAttributeValue(new QName(null, "default"));
        if (columns > 2) {
            if (columnCount == 0) {
                table.append("<tr>");
            }
            TextField textField = new TextField(null, arg.getFirstChildWithName(new QName(null, "name")).getText(), null, null, widgetName, value, isURL, urlTemplate, isPath, isReadOnly, hasValue, tooltip, startsWith, request, false);
            table.append(((UIComponent)textField).generate());
            if (++columnCount == columns) {
                table.append("</tr>");
                columnCount = 0;
            }
        } else {
            OMElement firstChildWithName = arg.getFirstChildWithName(new QName(null, "name"));
            String name = firstChildWithName.getText();
            String label = firstChildWithName.getAttributeValue(new QName("label"));
            if (label == null) {
                label = name;
            }
            TextField text = new TextField(label, name, null, mandat, widgetName, value, isURL, urlTemplate, isPath, isReadOnly, hasValue, tooltip, startsWith, request, false);
            table.append(((UIComponent)text).generate());
        }
        return columnCount;
    }

    private int handleTextArea(boolean isFilterOperation, boolean markReadonly, int columns, String widgetName, StringBuilder table, int columnCount, OMElement inner, OMElement arg, String tooltip) {
        String widthString;
        String mandet = arg.getAttributeValue(new QName(null, "required"));
        String richText = arg.getAttributeValue(new QName(null, "isRichText"));
        String value = null;
        boolean isReadOnly = false;
        if (markReadonly && "true".equals(arg.getAttributeValue(new QName(null, "readonly")))) {
            isReadOnly = true;
        }
        boolean isRichText = false;
        if (richText != null) {
            isRichText = Boolean.valueOf(richText);
        }
        if (isFilterOperation) {
            mandet = "false";
        }
        if (inner != null) {
            value = inner.getText();
        }
        int height = -1;
        int width = -1;
        String heightString = arg.getAttributeValue(new QName(null, "height"));
        if (heightString != null) {
            try {
                height = Integer.parseInt(heightString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((widthString = arg.getAttributeValue(new QName(null, "width"))) != null) {
            try {
                width = Integer.parseInt(widthString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (columns > 2) {
            if (columnCount == 0) {
                table.append("<tr>");
            }
            TextArea textArea = new TextArea(null, arg.getFirstChildWithName(new QName(null, "name")).getText(), null, null, widgetName, value, height, width, isReadOnly, false, tooltip, true, false);
            table.append(((UIComponent)textArea).generate());
            if (++columnCount == columns) {
                table.append("</tr>");
                columnCount = 0;
            }
        } else {
            OMElement firstChildWithName = arg.getFirstChildWithName(new QName(null, "name"));
            String name = firstChildWithName.getText();
            String label = firstChildWithName.getAttributeValue(new QName("label"));
            if (label == null) {
                label = name;
            }
            TextArea textArea = new TextArea(label, name, null, mandet, widgetName, value, height, width, isReadOnly, isRichText, tooltip, false, false);
            table.append(((UIComponent)textArea).generate());
        }
        return columnCount;
    }

    private int fillOptionValues(OMElement dataHead, List<String> addedOptionValues, List<String> addedValues) {
        Iterator itemChildIt = dataHead.getChildElements();
        int i = 0;
        while (itemChildIt.hasNext()) {
            OMElement itemChildEle;
            Object itemChildObj = itemChildIt.next();
            if (!(itemChildObj instanceof OMElement) || !(itemChildEle = (OMElement)itemChildObj).getQName().equals(new QName(this.dataNamespace, "entry"))) continue;
            String entryText = itemChildEle.getText();
            String entryKey = null;
            int colonIndex = entryText.indexOf(":");
            if (colonIndex < entryText.length() - 1) {
                entryKey = entryText.substring(0, colonIndex);
                entryText = entryText.substring(colonIndex + 1);
            } else if (colonIndex == entryText.length() - 1) {
                entryKey = entryText.substring(0, colonIndex);
                entryText = "";
            }
            String entryVal = entryText;
            if (entryKey != null && !entryKey.equals("")) {
                addedOptionValues.add(entryKey);
            } else {
                addedOptionValues.add("0");
            }
            if (entryVal != null) {
                addedValues.add(entryVal);
            }
            ++i;
        }
        return i;
    }

    private int handleCheckBox(int columns, String widgetName, StringBuilder table, int columnCount, OMElement inner, OMElement arg, String tooltip) {
        OMElement firstChildWithName = arg.getFirstChildWithName(new QName(null, "name"));
        String name = firstChildWithName.getText();
        String label = firstChildWithName.getAttributeValue(new QName("label"));
        if (label == null) {
            label = name;
        }
        String optionValue = null;
        if (inner != null) {
            optionValue = inner.getText();
        }
        if (columns > 1) {
            if (columnCount == 0) {
                table.append("<tr>");
            }
            CheckBox checkBox = new CheckBox(label, name, null, widgetName, optionValue, tooltip, true, false);
            table.append(((UIComponent)checkBox).generate());
            if (++columnCount == columns) {
                table.append("</tr>");
                columnCount = 0;
            }
        } else {
            CheckBox checkBox = new CheckBox(label, name, null, widgetName, optionValue, tooltip, true, false);
            table.append(((UIComponent)checkBox).generate());
        }
        return columnCount;
    }

    private int addRxtProperties(List<OMElement> dataElements, List<Map<String, String>> addedValues) {
        int addedItemsCount = 0;
        for (int i = 0; i < dataElements.size(); ++i) {
            OMElement dataHeadElements = dataElements.get(i);
            Iterator itemChildIt = dataHeadElements.getChildElements();
            int a = 0;
            HashMap<String, String> values = new HashMap<String, String>();
            while (itemChildIt.hasNext()) {
                Object itemChildObj = itemChildIt.next();
                if (!(itemChildObj instanceof OMElement)) continue;
                OMElement itemChildEle = (OMElement)itemChildObj;
                values.put(itemChildEle.getLocalName(), itemChildEle.getText());
                ++a;
            }
            addedValues.add(values);
            ++addedItemsCount;
        }
        return addedItemsCount;
    }

    private void addHeaders(OMElement widget, List<String> subList) {
        Iterator headerElements = widget.getChildrenWithLocalName("field");
        while (headerElements.hasNext()) {
            OMElement arg = (OMElement)headerElements.next();
            String name = arg.getFirstChildWithName(new QName(null, "name")).getText();
            if (!"field".equals(arg.getLocalName())) continue;
            String label = arg.getAttributeValue(new QName("label"));
            if (label == null) {
                label = name;
            }
            subList.add(label);
        }
    }

    public String printMainHeader(String header, int columns) {
        StringBuilder head = new StringBuilder();
        head.append("<thead><tr><th style=\"border-right:0\" colspan=\"" + columns + "\">");
        head.append(header);
        head.append("</th></tr></thead>");
        return head.toString();
    }

    public static String printSubHeaders(String[] headers) {
        StringBuilder subHeaders = new StringBuilder();
        subHeaders.append("<tr>");
        for (String header : headers) {
            subHeaders.append("<td class=\"sub-header\">");
            subHeaders.append(header == null ? "" : header);
            subHeaders.append("</td>");
        }
        subHeaders.append("<td class=\"sub-header\"></td>");
        subHeaders.append("</tr>");
        return subHeaders.toString();
    }

    public String printCloseAddLink(String name, int count) {
        name = name.replaceAll("-", "");
        name = name.replaceAll(" ", "");
        StringBuilder link = new StringBuilder();
        link.append("</tbody></table>");
        link.append("<input id=\"" + name.replaceAll(" ", "").replaceAll("-", "") + "CountTaker\" type=\"hidden\" value=\"" + count + "\" name=\"");
        link.append(name.replaceAll(" ", "").replaceAll("-", "") + "Count" + "\"/>\n");
        link.append("</td></tr>");
        return link.toString();
    }

    public OMElement getDataFromUI(OMElement head, HttpServletRequest request) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace namespace = fac.createOMNamespace(this.dataNamespace, "");
        OMElement data = fac.createOMElement(this.dataElement, namespace);
        Iterator it = head.getChildrenWithName(new QName("table"));
        while (it.hasNext()) {
            OMElement widget = (OMElement)it.next();
            String widgetName = widget.getAttributeValue(new QName(null, "name"));
            OMElement widgetData = fac.createOMElement(GenericUtil.getDataElementName(widgetName), namespace);
            Iterator arguments = widget.getChildrenWithLocalName("field");
            OMElement arg = null;
            String widgetMaxOccurs = widget.getAttributeValue(new QName(null, "maxoccurs"));
            if (widgetMaxOccurs != null) {
                if (!"unbounded".equals(widgetMaxOccurs)) continue;
                String count = request.getParameter(widgetName.replaceAll(" ", "") + "Count");
                for (int i = 0; i < Integer.parseInt(count); ++i) {
                    arguments = widget.getChildrenWithLocalName("field");
                    int a = 0;
                    OMElement entryElement = fac.createOMElement(GenericUtil.getDataElementName(widgetName), namespace);
                    boolean isAllBlank = true;
                    while (arguments.hasNext()) {
                        arg = (OMElement)arguments.next();
                        String name = arg.getFirstChildWithName(new QName(null, "name")).getText();
                        String elementType = name.replaceAll(" ", "");
                        String webElement = widgetName.replaceAll(" ", "") + "_" + elementType.replaceAll(" ", "") + "_" + (i + 1);
                        String input = request.getParameter(webElement);
                        if (input == null) {
                            input = "";
                        } else {
                            isAllBlank = false;
                        }
                        OMElement innerElemnt = fac.createOMElement(GenericUtil.getDataElementName(name), namespace);
                        innerElemnt.setText(input);
                        entryElement.addChild((OMNode)innerElemnt);
                        ++a;
                    }
                    if (isAllBlank) continue;
                    data.addChild((OMNode)entryElement);
                }
                continue;
            }
            while (arguments.hasNext()) {
                String input;
                arg = (OMElement)arguments.next();
                if (!"field".equals(arg.getLocalName())) continue;
                String elementType = arg.getAttributeValue(new QName(null, "type"));
                String name = arg.getFirstChildWithName(new QName(null, "name")).getText();
                if ("option-text".equals(elementType)) {
                    String inputOption;
                    if ("unbounded".equals(arg.getAttributeValue(new QName(null, "maxoccurs")))) {
                        String count = request.getParameter(name.replaceAll(" ", "") + "Count");
                        for (int i = 0; i < Integer.parseInt(count); ++i) {
                            String entryValue = "";
                            String input2 = request.getParameter(widgetName.replaceAll(" ", "") + "_" + name.replaceAll(" ", "") + (i + 1));
                            if (input2 != null && !"".equals(input2)) {
                                entryValue = entryValue + input2;
                            }
                            entryValue = entryValue + ":";
                            String inputTextValue = request.getParameter(widgetName.replaceAll(" ", "") + "text" + "_" + name.replaceAll(" ", "") + (i + 1));
                            if (inputTextValue != null && !"".equals(inputTextValue)) {
                                entryValue = entryValue + inputTextValue;
                            }
                            if (":".equals(entryValue)) continue;
                            OMElement entryElement = fac.createOMElement("entry", namespace);
                            entryElement.setText(entryValue);
                            widgetData.addChild((OMNode)entryElement);
                        }
                        continue;
                    }
                    input = request.getParameter(widgetName.replaceAll(" ", "") + "_" + name.replaceAll(" ", ""));
                    if (input != null && !"".equals(input)) {
                        OMElement text = fac.createOMElement(GenericUtil.getDataElementName(name), namespace);
                        text.setText(input);
                        widgetData.addChild((OMNode)text);
                    }
                    if ((inputOption = request.getParameter(widgetName.replaceAll(" ", "") + "text" + "_" + name.replaceAll(" ", ""))) == null || "".equals(inputOption)) continue;
                    OMElement value = fac.createOMElement(GenericUtil.getDataElementName("text" + name), namespace);
                    value.setText(inputOption);
                    widgetData.addChild((OMNode)value);
                    continue;
                }
                input = request.getParameter(widgetName.replaceAll(" ", "") + "_" + name.replaceAll(" ", ""));
                if ("checkbox".equals(elementType) && input == null) {
                    input = "false";
                }
                OMElement text = null;
                if (input != null && !"".equals(input)) {
                    text = fac.createOMElement(GenericUtil.getDataElementName(name), namespace);
                    text.setText(input);
                    widgetData.addChild((OMNode)text);
                    continue;
                }
                if (name.equals("Name") && widgetName.equalsIgnoreCase("overview")) {
                    text = fac.createOMElement(GenericUtil.getDataElementName(name), namespace);
                    text.setText("C0E6D4A8-C446-4f01-99DB-70E212685A40");
                    widgetData.addChild((OMNode)text);
                }
                if (!name.equals("Namespace")) continue;
                text = fac.createOMElement(GenericUtil.getDataElementName(name), namespace);
                text.setText(".*");
                widgetData.addChild((OMNode)text);
            }
            data.addChild((OMNode)widgetData);
        }
        return GenericUtil.addExtraElements(data, request);
    }

    public List<Map> getTooltipList(OMElement head) {
        ArrayList<Map> res = new ArrayList<Map>();
        ArrayList id = new ArrayList();
        Iterator it = head.getChildrenWithName(new QName("table"));
        while (it.hasNext()) {
            OMElement widget = (OMElement)it.next();
            String widgetName = widget.getAttributeValue(new QName(null, "name"));
            Iterator arguments = widget.getChildrenWithLocalName("field");
            OMElement arg = null;
            while (arguments.hasNext()) {
                ArrayList<String> ids;
                HashMap<String, Object> map;
                arg = (OMElement)arguments.next();
                if (!"field".equals(arg.getLocalName())) continue;
                String elementType = arg.getAttributeValue(new QName(null, "type"));
                String name = arg.getFirstChildWithName(new QName(null, "name")).getText();
                String value = arg.getAttributeValue(new QName(null, "tooltip"));
                if (value == null || "".equals(value)) continue;
                if ("option-text".equals(elementType)) {
                    if ("unbounded".equals(arg.getAttributeValue(new QName(null, "maxoccurs")))) {
                        map = new HashMap();
                        ids = new ArrayList();
                        ids.add(widgetName.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-"));
                        ids.add(widgetName.replaceAll(" ", "_") + "text" + "_" + name.replaceAll(" ", "-"));
                        map.put("ids", ids);
                        map.put("tooltip", value);
                        map.put("properties", "unbounded");
                        res.add(map);
                        continue;
                    }
                    map = new HashMap();
                    ids = new ArrayList();
                    ids.add(widgetName.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-"));
                    ids.add(widgetName.replaceAll(" ", "_") + "text" + "_" + name.replaceAll(" ", "-"));
                    map.put("ids", ids);
                    map.put("tooltip", value);
                    res.add(map);
                    continue;
                }
                map = new HashMap<String, Object>();
                ids = new ArrayList<String>();
                ids.add(widgetName.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-"));
                map.put("ids", ids);
                map.put("tooltip", value);
                res.add(map);
            }
        }
        return res;
    }

    public OMElement getDataFromUIForBasicFilter(OMElement head, HttpServletRequest request) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace namespace = fac.createOMNamespace(this.dataNamespace, "");
        OMElement data = fac.createOMElement(this.dataElement, namespace);
        Iterator it = head.getChildrenWithName(new QName("table"));
        while (it.hasNext()) {
            OMElement widget = (OMElement)it.next();
            String widgetName = widget.getAttributeValue(new QName(null, "name"));
            OMElement widgetData = fac.createOMElement(GenericUtil.getDataElementName(widgetName), namespace);
            Iterator arguments = widget.getChildrenWithLocalName("field");
            OMElement arg = null;
            while (arguments.hasNext()) {
                OMElement text;
                String input;
                arg = (OMElement)arguments.next();
                if (!"field".equals(arg.getLocalName())) continue;
                String elementType = arg.getAttributeValue(new QName(null, "type"));
                String name = arg.getFirstChildWithName(new QName(null, "name")).getText();
                if ("option-text".equals(elementType)) {
                    String inputOption;
                    if ("unbounded".equals(arg.getAttributeValue(new QName(null, "maxoccurs")))) continue;
                    input = request.getParameter(widgetName.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-"));
                    if (input != null && !"".equals(input)) {
                        text = fac.createOMElement(GenericUtil.getDataElementName(name), namespace);
                        text.setText(input);
                        widgetData.addChild((OMNode)text);
                    }
                    if ((inputOption = request.getParameter(widgetName.replaceAll(" ", "_") + "text" + "_" + name.replaceAll(" ", "-"))) == null || "".equals(inputOption)) continue;
                    OMElement value = fac.createOMElement(GenericUtil.getDataElementName("text" + name), namespace);
                    value.setText(inputOption);
                    widgetData.addChild((OMNode)value);
                    continue;
                }
                input = request.getParameter(widgetName.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-"));
                text = null;
                if (input != null && !"".equals(input)) {
                    text = fac.createOMElement(GenericUtil.getDataElementName(name), namespace);
                    text.setText(input);
                    widgetData.addChild((OMNode)text);
                    continue;
                }
                if (!name.equals("Name")) continue;
                text = fac.createOMElement(GenericUtil.getDataElementName(name), namespace);
                text.setText("C0E6D4A8-C446-4f01-99DB-70E212685A40");
                widgetData.addChild((OMNode)text);
            }
            data.addChild((OMNode)widgetData);
        }
        return GenericUtil.addExtraElements(data, request);
    }

    public List<Map> getValidationAttributes(OMElement head) {
        ArrayList<Map> res = new ArrayList<Map>();
        ArrayList id = new ArrayList();
        Iterator it = head.getChildrenWithName(new QName("table"));
        while (it.hasNext()) {
            OMElement widget = (OMElement)it.next();
            String widgetName = widget.getAttributeValue(new QName(null, "name"));
            boolean isUnboundedTable = "unbounded".equals(widget.getAttributeValue(new QName(null, "maxoccurs")));
            Iterator arguments = widget.getChildrenWithLocalName("field");
            OMElement arg = null;
            while (arguments.hasNext()) {
                ArrayList<String> ids;
                HashMap<String, Object> map;
                arg = (OMElement)arguments.next();
                if (!"field".equals(arg.getLocalName())) continue;
                String elementType = arg.getAttributeValue(new QName(null, "type"));
                String name = arg.getFirstChildWithName(new QName(null, "name")).getText();
                String value = arg.getAttributeValue(new QName(null, "validate"));
                if (value == null || "".equals(value)) continue;
                if ("option-text".equals(elementType)) {
                    if ("unbounded".equals(arg.getAttributeValue(new QName(null, "maxoccurs")))) {
                        map = new HashMap();
                        ids = new ArrayList();
                        ids.add(widgetName.replaceAll(" ", "") + "_" + name.replaceAll(" ", "-"));
                        ids.add(widgetName.replaceAll(" ", "_") + "text" + "_" + name.replaceAll(" ", "-"));
                        map.put("ids", ids);
                        map.put("name", name);
                        map.put("regexp", value);
                        map.put("properties", "unbounded");
                        res.add(map);
                        continue;
                    }
                    map = new HashMap();
                    ids = new ArrayList();
                    ids.add(widgetName.replaceAll(" ", "_") + "_" + name.replaceAll(" ", "-"));
                    ids.add(widgetName.replaceAll(" ", "_") + "text" + "_" + name.replaceAll(" ", "-"));
                    map.put("ids", ids);
                    map.put("name", name);
                    map.put("regexp", value);
                    res.add(map);
                    continue;
                }
                map = new HashMap<String, Object>();
                ids = new ArrayList<String>();
                ids.add(widgetName.replaceAll(" ", "") + "_" + name.replaceAll(" ", "-"));
                map.put("ids", ids);
                map.put("name", name);
                map.put("regexp", value);
                map.put("unboundedTable", isUnboundedTable);
                res.add(map);
            }
        }
        return res;
    }

    public String[] getMandatoryIdList(OMElement head) {
        ArrayList<String> id = new ArrayList<String>();
        Iterator it = head.getChildrenWithName(new QName("table"));
        while (it.hasNext()) {
            OMElement widget = (OMElement)it.next();
            String widgetName = widget.getAttributeValue(new QName(null, "name"));
            Iterator arguments = widget.getChildrenWithLocalName("field");
            OMElement arg = null;
            while (arguments.hasNext()) {
                arg = (OMElement)arguments.next();
                if (!"field".equals(arg.getLocalName())) continue;
                String name = arg.getFirstChildWithName(new QName(null, "name")).getText();
                String mandatory = arg.getAttributeValue(new QName(null, "required"));
                if (mandatory == null || !"true".equals(mandatory)) continue;
                id.add("id_" + widgetName.replaceAll(" ", "") + "_" + name.replaceAll(" ", ""));
            }
        }
        return id.toArray(new String[id.size()]);
    }

    public String[] getKeyList(OMElement head, String[] keys) {
        ArrayList<String> id = new ArrayList<String>();
        Iterator it = head.getChildrenWithName(new QName("table"));
        while (it.hasNext()) {
            OMElement widget = (OMElement)it.next();
            String widgetName = widget.getAttributeValue(new QName(null, "name"));
            Iterator arguments = widget.getChildrenWithLocalName("field");
            OMElement arg = null;
            while (arguments.hasNext()) {
                arg = (OMElement)arguments.next();
                if (!"field".equals(arg.getLocalName())) continue;
                String name = arg.getFirstChildWithName(new QName(null, "name")).getText();
                String key = widgetName.replaceAll(" ", "") + "_" + name.replaceAll(" ", "");
                if (!Arrays.asList(keys).contains(key.toLowerCase())) continue;
                id.add(key);
            }
        }
        return id.toArray(new String[id.size()]);
    }

    public String getLabelValue(OMElement head, String feild) {
        Iterator it = head.getChildrenWithName(new QName("table"));
        while (it.hasNext()) {
            OMElement widget = (OMElement)it.next();
            String widgetName = widget.getAttributeValue(new QName(null, "name"));
            Iterator arguments = widget.getChildrenWithLocalName("field");
            OMElement arg = null;
            while (arguments.hasNext()) {
                arg = (OMElement)arguments.next();
                if (!"field".equals(arg.getLocalName())) continue;
                String name = arg.getFirstChildWithName(new QName(null, "name")).getText();
                String key = widgetName.replaceAll(" ", "") + "_" + name.replaceAll(" ", "");
                if (!feild.toLowerCase().equals(key.toLowerCase())) continue;
                String label = null;
                label = arg.getFirstChildWithName(new QName(null, "name")).getAttributeValue(new QName("label"));
                if (label == null) {
                    label = name;
                }
                return label;
            }
        }
        return null;
    }

    public String[] getMandatoryNameList(OMElement head) {
        ArrayList<String> name = new ArrayList<String>();
        Iterator it = head.getChildrenWithName(new QName("table"));
        while (it.hasNext()) {
            OMElement widget = (OMElement)it.next();
            Iterator arguments = widget.getChildrenWithLocalName("field");
            OMElement arg = null;
            while (arguments.hasNext()) {
                arg = (OMElement)arguments.next();
                if (!"field".equals(arg.getLocalName())) continue;
                String name_element = arg.getFirstChildWithName(new QName(null, "name")).getText();
                String mandatory = arg.getAttributeValue(new QName(null, "required"));
                if (mandatory == null || !"true".equals(mandatory)) continue;
                name.add(name_element);
            }
        }
        return name.toArray(new String[name.size()]);
    }

    public String[] getUnboundedTooltipList(OMElement head) {
        ArrayList<String> tooltips = new ArrayList<String>();
        Iterator it = head.getChildrenWithName(new QName("table"));
        while (it.hasNext()) {
            OMElement widget = (OMElement)it.next();
            Iterator arguments = widget.getChildrenWithLocalName("field");
            OMElement arg = null;
            while (arguments.hasNext()) {
                arg = (OMElement)arguments.next();
                if (!"field".equals(arg.getLocalName()) || !"option-text".equals(arg.getAttributeValue(new QName(null, "type"))) || !"unbounded".equals(arg.getAttributeValue(new QName(null, "maxoccurs")))) continue;
                String tooltip = arg.getAttributeValue(new QName(null, "tooltip"));
                if (tooltip == null) {
                    tooltip = "";
                }
                tooltips.add(tooltip);
            }
        }
        return tooltips.toArray(new String[tooltips.size()]);
    }

    public String[] getUnboundedNameList(OMElement head) {
        ArrayList<String> name = new ArrayList<String>();
        Iterator it = head.getChildrenWithName(new QName("table"));
        while (it.hasNext()) {
            OMElement widget = (OMElement)it.next();
            Iterator arguments = widget.getChildrenWithLocalName("field");
            OMElement arg = null;
            while (arguments.hasNext()) {
                arg = (OMElement)arguments.next();
                if (!"field".equals(arg.getLocalName()) || !"option-text".equals(arg.getAttributeValue(new QName(null, "type"))) || !"unbounded".equals(arg.getAttributeValue(new QName(null, "maxoccurs")))) continue;
                name.add(arg.getFirstChildWithName(new QName(null, "name")).getText());
            }
        }
        return name.toArray(new String[name.size()]);
    }

    public String[] getUnboundedWidgetList(OMElement head) {
        ArrayList<String> widgetList = new ArrayList<String>();
        Iterator it = head.getChildrenWithName(new QName("table"));
        while (it.hasNext()) {
            OMElement widget = (OMElement)it.next();
            Iterator arguments = widget.getChildrenWithLocalName("field");
            OMElement arg = null;
            while (arguments.hasNext()) {
                arg = (OMElement)arguments.next();
                if (!"field".equals(arg.getLocalName()) || !"option-text".equals(arg.getAttributeValue(new QName(null, "type"))) || !"unbounded".equals(arg.getAttributeValue(new QName(null, "maxoccurs")))) continue;
                widgetList.add(widget.getAttributeValue(new QName(null, "name")));
            }
        }
        return widgetList.toArray(new String[widgetList.size()]);
    }

    public String[][] getDateIdAndNameList(OMElement head, OMElement data, boolean markReadOnly) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        Iterator it = head.getChildrenWithName(new QName("table"));
        while (it.hasNext()) {
            OMElement widget = (OMElement)it.next();
            String widgetName = widget.getAttributeValue(new QName(null, "name"));
            String widgetMaxOccurs = widget.getAttributeValue(new QName(null, "maxoccurs"));
            OMElement arg = null;
            if (widgetMaxOccurs != null) {
                int i;
                List<Object> dataElements = new ArrayList();
                if (data != null) {
                    dataElements = GenericUtil.getChildsWithName(data, widgetName, this.dataNamespace);
                }
                ArrayList<String[]> addedValues = new ArrayList<String[]>();
                int addedItemsCount = 0;
                for (i = 0; i < dataElements.size(); ++i) {
                    OMElement dataHeadElements = (OMElement)dataElements.get(i);
                    Iterator itemChildIt = dataHeadElements.getChildElements();
                    int a = 0;
                    ArrayList<String> values = new ArrayList<String>();
                    while (itemChildIt.hasNext()) {
                        Object itemChildObj = itemChildIt.next();
                        if (!(itemChildObj instanceof OMElement)) continue;
                        OMElement itemChildEle = (OMElement)itemChildObj;
                        values.add(itemChildEle.getText());
                        ++a;
                    }
                    addedValues.add(values.toArray(new String[values.size()]));
                    ++addedItemsCount;
                }
                for (i = 0; i < addedItemsCount; ++i) {
                    Iterator arguments = widget.getChildrenWithLocalName("field");
                    while (arguments.hasNext()) {
                        arg = (OMElement)arguments.next();
                        if (!"field".equals(arg.getLocalName()) || !"date".equals(arg.getAttributeValue(new QName(null, "type"))) || markReadOnly && "true".equals(arg.getAttributeValue(new QName(null, "readonly")))) continue;
                        String name = arg.getFirstChildWithName(new QName(null, "name")).getText();
                        String elementId = widgetName.replaceAll(" ", "") + "_" + name.replaceAll(" ", "") + "_" + (i + 1);
                        String[] idAndName = new String[]{"id_" + elementId, name};
                        result.add(idAndName);
                    }
                }
                continue;
            }
            Iterator arguments = widget.getChildrenWithLocalName("field");
            while (arguments.hasNext()) {
                arg = (OMElement)arguments.next();
                if (!"field".equals(arg.getLocalName()) || !"date".equals(arg.getAttributeValue(new QName(null, "type"))) || markReadOnly && "true".equals(arg.getAttributeValue(new QName(null, "readonly")))) continue;
                String name = arg.getFirstChildWithName(new QName(null, "name")).getText();
                String[] idAndName = new String[]{"id_" + widgetName.replaceAll(" ", "") + "_" + name.replaceAll(" ", ""), name};
                result.add(idAndName);
            }
        }
        return (String[][])result.toArray((T[])new String[result.size()][2]);
    }

    public String[][] getUnboundedValues(OMElement head, HttpServletRequest request, ServletConfig config) {
        ArrayList<String[]> values = new ArrayList<String[]>();
        Iterator it = head.getChildrenWithName(new QName("table"));
        while (it.hasNext()) {
            OMElement widget = (OMElement)it.next();
            Iterator arguments = widget.getChildrenWithLocalName("field");
            OMElement arg = null;
            while (arguments.hasNext()) {
                arg = (OMElement)arguments.next();
                if (!"field".equals(arg.getLocalName()) || !"option-text".equals(arg.getAttributeValue(new QName(null, "type"))) || !"unbounded".equals(arg.getAttributeValue(new QName(null, "maxoccurs")))) continue;
                List<String> inner = this.getOptionValues(arg, request, config);
                values.add(inner.toArray(new String[inner.size()]));
            }
        }
        return (String[][])values.toArray((T[])new String[0][0]);
    }

    private List<String> getOptionValues(OMElement arg, HttpServletRequest request, ServletConfig config) {
        OMElement values = arg.getFirstChildWithName(new QName(null, "values"));
        Iterator iterator = values.getChildrenWithLocalName("value");
        ArrayList<String> inner = new ArrayList<String>();
        if (iterator != null && iterator.hasNext()) {
            while (iterator.hasNext()) {
                inner.add(((OMElement)iterator.next()).getText());
            }
            return inner;
        }
        try {
            String className = values.getAttributeValue(new QName(null, "class"));
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> populatorClass = Class.forName(className, true, loader);
            DropDownDataPopulator populator = (DropDownDataPopulator)populatorClass.newInstance();
            String[] list = populator.getList(request, config);
            return new ArrayList<String>(Arrays.asList(list));
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Unable to load populator class", (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)"Unable to load populator class", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Unable to load populator class", (Throwable)e);
        }
        return inner;
    }

    public String getUnboundedWidgets(OMElement head, HttpServletRequest request, ServletConfig config) {
        Iterator it = head.getChildrenWithName(new QName("table"));
        StringBuilder builder = new StringBuilder();
        while (it.hasNext()) {
            OMElement widget = (OMElement)it.next();
            String widgetMaxOccurs = widget.getAttributeValue(new QName(null, "maxoccurs"));
            String widgetName = widget.getAttributeValue(new QName(null, "name"));
            if (widgetMaxOccurs == null || !"unbounded".equals(widgetMaxOccurs)) continue;
            builder.append("function add" + widgetName.replaceAll(" ", "") + "_" + widgetName.replaceAll(" ", "") + "(){");
            widgetName = widgetName.replaceAll(" ", "");
            builder.append("var endpointMgt = document.getElementById('" + widgetName + "Mgt');");
            builder.append("endpointMgt.parentNode.style.display = '';");
            builder.append("var epCountTaker = document.getElementById('" + widgetName + "CountTaker'); ");
            builder.append("var " + widgetName + "Count = parseInt(epCountTaker.value);");
            builder.append("" + widgetName + "Count++;");
            builder.append("epCountTaker.value = " + widgetName + "Count;");
            builder.append("var theTr = document.createElement('TR');");
            Iterator arguments = widget.getChildrenWithLocalName("field");
            OMElement arg = null;
            int a = 0;
            boolean isDateFieldAdded = false;
            while (arguments.hasNext()) {
                String tooltip;
                arg = (OMElement)arguments.next();
                String elementType = arg.getAttributeValue(new QName(null, "type"));
                boolean isReadOnly = false;
                if ("true".equals(arg.getAttributeValue(new QName(null, "readonly")))) {
                    isReadOnly = true;
                }
                if ((tooltip = arg.getAttributeValue(new QName(null, "tooltip"))) == null) {
                    tooltip = "";
                }
                tooltip = StringEscapeUtils.escapeHtml((String)tooltip);
                String name = arg.getFirstChildWithName(new QName(null, "name")).getText();
                if ("field".equals(arg.getLocalName())) {
                    UIComponent textArea;
                    builder.append("var theTd" + a + " = document.createElement('TD');");
                    builder.append("var rowId = '" + widgetName + "Count" + elementType + "_" + a + "_'+(epCountTaker.value -1);");
                    if ("date".equals(elementType)) {
                        DateField dateField = new DateField(null, name, null, null, widgetName, null, false, tooltip, false, true);
                        builder.append("theTd" + a + ".innerHTML = '" + ((UIComponent)dateField).generate() + "';");
                        isDateFieldAdded = true;
                    } else if ("checkbox".equals(elementType)) {
                        CheckBox checkBox = new CheckBox(name, name, null, widgetName, null, tooltip, false, true);
                        builder.append("theTd" + a + ".innerHTML = '" + ((UIComponent)checkBox).generate() + "';");
                    } else if ("options".equals(elementType)) {
                        String startsWith = arg.getAttributeValue(new QName(null, "startsWith"));
                        List<String> optionValues = this.getOptionValues(arg, request, config);
                        DropDown dropDown = new DropDown(null, isReadOnly, name, null, null, optionValues.toArray(new String[optionValues.size()]), widgetName, null, tooltip, true);
                        builder.append("theTd" + a + ".innerHTML = '" + dropDown.generate() + "';");
                    } else if ("text-area".equals(elementType)) {
                        String widthString;
                        int height = -1;
                        int width = 200;
                        String heightString = arg.getAttributeValue(new QName(null, "height"));
                        if (heightString != null) {
                            try {
                                height = Integer.parseInt(heightString);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if ((widthString = arg.getAttributeValue(new QName(null, "width"))) != null) {
                            try {
                                width = Integer.parseInt(widthString);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        textArea = new TextArea(null, name, null, null, widgetName, null, height, width, isReadOnly, false, tooltip, false, true);
                        builder.append("theTd" + a + ".innerHTML = '" + textArea.generate() + "';");
                    } else {
                        boolean isURL = Boolean.toString(true).equals(arg.getAttributeValue(new QName(null, "url")));
                        String urlTemplate = arg.getAttributeValue(new QName(null, "template"));
                        boolean isPath = Boolean.toString(true).equals(arg.getAttributeValue(new QName(null, "path")));
                        String startsWith = arg.getAttributeValue(new QName(null, "startsWith"));
                        textArea = new TextField(null, name, null, null, widgetName, null, isURL, urlTemplate, isPath, isReadOnly, false, tooltip, startsWith, request, true);
                        builder.append("theTd" + a + ".innerHTML = '" + textArea.generate() + "';");
                    }
                    builder.append("theTr.appendChild(theTd" + a + ");");
                }
                ++a;
            }
            builder.append("var theTddelete = document.createElement('TD');");
            builder.append("var td3Inner = '<a class=\"icon-link\" title=\"delete\" onclick=\"delete" + widgetName + "_" + widgetName + "(this.parentNode.parentNode.rowIndex)\" style=\"background-image:url(../admin/images/delete.gif);\">Delete</a>';");
            builder.append("theTddelete.innerHTML = td3Inner;");
            builder.append("theTr.appendChild(theTddelete);");
            builder.append("var dateArr = new Array();");
            builder.append("var dateArrSize = 0;");
            builder.append("jQuery('*',theTr).each(function(){");
            builder.append("var idAttr = jQuery(this).attr('id');");
            builder.append("if (typeof idAttr !== typeof undefined && idAttr !== false && idAttr != \"\") {");
            builder.append("idAttr = jQuery(this).attr('id') + '_' + ");
            builder.append(widgetName);
            builder.append("Count;");
            builder.append("var jdateId = '#' + jQuery(this).id;");
            builder.append("if (theTr.innerHTML.indexOf(jdateId) !== -1) {");
            builder.append("dateArr[dateArrSize] = idAttr;");
            builder.append("dateArrSize++;");
            builder.append("}");
            builder.append("jQuery(this).attr('id',idAttr);");
            builder.append("}");
            builder.append("var nameAttr = jQuery(this).attr('name');");
            builder.append("if (typeof nameAttr !== typeof undefined && ");
            builder.append("nameAttr !== false && nameAttr != \"\") {");
            builder.append("nameAttr = jQuery(this).attr('name') +'_'+ ");
            builder.append(widgetName);
            builder.append("Count;");
            builder.append("jQuery(this).attr('name',nameAttr);");
            builder.append("}");
            builder.append("});");
            builder.append("endpointMgt.appendChild(theTr);");
            if (isDateFieldAdded) {
                builder.append("for (var i = 0; i < dateArr.length; ++i) {var elementId = dateArr[i];var datePickValue = \"#\"+elementId;jQuery(datePickValue).datepicker();}");
            }
            builder.append("}");
            builder.append("function delete" + widgetName + "_" + widgetName + "(index){");
            builder.append("var endpointMgt = document.getElementById('" + widgetName + "Mgt');");
            builder.append("endpointMgt.parentNode.style.display = '';");
            builder.append("endpointMgt.parentNode.deleteRow(index);");
            builder.append("var table = endpointMgt.parentNode;");
            builder.append("var rows = table.getElementsByTagName('input');");
            builder.append("if (rows != null & rows.length == 0) {");
            builder.append("    endpointMgt.parentNode.style.display = 'none';");
            builder.append("}");
            builder.append("}");
        }
        return builder.toString();
    }

    public String printWidget(String widget, String values, String id) {
        StringBuilder content = new StringBuilder();
        if ("date".equals(widget)) {
            content.append("<td><a class=\"icon-link\" style=\"background-image: url( ../admin/images/calendar.gif);\" onclick=\"jQuery('#" + id + "').datepicker( 'show' );\" href=\"javascript:void(0)\"></a>");
            content.append("<input type=\"text\" name=\"" + id + "\" value=\"" + values + "\" id=\"" + id + "\" style=\"width:200px\"/></td>");
        } else if ("text-area".equals(widget)) {
            content.append("<td><textarea type=\"text\" name=\"" + id + "\" id=\"" + id + "\" style=\"width:200px\">" + values + "</textarea></td>");
        } else if ("text".equals(widget)) {
            content.append("<td><input type=\"text\" name=\"" + id + "\" value=\"" + values + "\" id=\"" + id + "\" style=\"width:200px\"/></td>");
        } else if ("checkbox".equals(widget)) {
            content.append("<td><input type=\"checkbox\" name=\"" + id + "\" value=\"" + values + "\" id=\"" + id + "\" style=\"width:200px\"/></td>");
        } else {
            content.append("<td><input type=\"text\" name=\"" + id + "\" value=\"" + values + "\" id=\"" + id + "\" style=\"width:200px\"/></td>");
        }
        return content.toString();
    }

    public String printTextFieldX(String id, String mandatory, boolean isPath, boolean isReadOnly, String tooltip, String startsWith, String value, HttpServletRequest request) {
        StringBuilder element = new StringBuilder();
        String selectResource = "";
        if (isPath) {
            selectResource = startsWith != null ? " <input type=\"button\" class=\"button\" value=\"..\" title=\"" + CarbonUIUtil.geti18nString((String)"select.path", (String)"org.wso2.carbon.governance.services.ui.i18n.Resources", (Locale)request.getLocale()) + "\" onclick=\"showGovernanceResourceTreeWithCustomPath('" + id + "' ,'" + startsWith + "');\"/>" : " <input type=\"button\" class=\"button\" value=\"..\" title=\"" + CarbonUIUtil.geti18nString((String)"select.path", (String)"org.wso2.carbon.governance.services.ui.i18n.Resources", (Locale)request.getLocale()) + "\" onclick=\"showGovernanceResourceTree('" + id + "');\"/>";
        }
        if ("true".equals(mandatory)) {
            element.append("<td><span class=\"required\">*</span><input type=\"text\" name=\"" + id + "\" title=\"" + tooltip + "\" id=\"" + id + "\" " + (value != null ? "value=\"" + value + "\"" : "") + " style=\"width:" + "400" + "px\"" + (isReadOnly ? " readonly" : "") + "/>" + (isPath ? selectResource : "") + "</td>");
        } else {
            element.append("<td><input type=\"text\" name=\"" + id + "\" title=\"" + tooltip + "\" id=\"" + id + "\" " + (value != null ? "value=\"" + value + "\"" : "") + " style=\"width:" + (value != null ? "value=\"" + value + "\"" : "") + "400" + "px\"" + (isReadOnly ? " readonly" : "") + "/>" + (isPath ? selectResource : "") + "</td>");
        }
        return element.toString();
    }

    public String printDateFeild(String id, String value, boolean isReadOnly, String tooltip) {
        StringBuilder element = new StringBuilder();
        value = StringEscapeUtils.escapeHtml((String)value);
        element.append("<td>");
        if (!isReadOnly) {
            element.append("<a class=\"icon-link\" style=\"background-image: url( ../admin/images/calendar.gif);\" onclick=\"jQuery('#" + id + "').datepicker( 'show' );\" href=\"javascript:void(0)\"></a>");
        }
        element.append("<input type=\"text\" name=\"" + id + "\" title=\"" + tooltip + "\" style=\"width:" + "100" + "px\"" + (isReadOnly ? " readonly" : "") + " id=\"" + id + "\" value=\"" + value + "\" /></td>");
        return element.toString();
    }

    public String printDropDownFeild(String id, String[] values, String value, String tooltip) {
        StringBuilder dropDown = new StringBuilder();
        dropDown.append("<td><select id=\"id_" + id + "\" name=\"" + id + "\" title=\"" + tooltip + "\">");
        for (int i = 0; i < values.length; ++i) {
            dropDown.append("<option value=\"" + StringEscapeUtils.escapeHtml((String)values[i]) + "\"");
            if (values[i].equals(value)) {
                dropDown.append(" selected>");
            } else {
                dropDown.append(">");
            }
            dropDown.append(StringEscapeUtils.escapeHtml((String)values[i]));
            dropDown.append("</option>");
        }
        dropDown.append("</select></td>");
        return dropDown.toString();
    }

    public String printCheckboxFeild(String id, String value, String tooltip) {
        if (Boolean.toString(true).equals(value)) {
            return "<td><input type=\"checkbox\" checked=\"checked\" name=\"" + id + "\" value=\"true\" title=\"" + tooltip + "\"/></td>";
        }
        return "<td><input type=\"checkbox\" name=\"" + id + "\" value=\"true\" title=\"" + tooltip + "\"/></td>";
    }

    public String printDeleteWidget(String widget) {
        StringBuilder content = new StringBuilder();
        content.append("<td><a class=\"icon-link\" title=\"delete\" onclick=\"delete" + widget.replaceAll(" ", "") + "_" + widget.replaceAll(" ", "") + "(this.parentNode.parentNode.rowIndex)\" style=\"background-image:url(../admin/images/delete.gif);\">Delete</a></td>");
        return content.toString();
    }
}

