/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.email.mgt.util;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.email.mgt.exceptions.I18nEmailMgtException;
import org.wso2.carbon.email.mgt.exceptions.I18nEmailMgtServerException;
import org.wso2.carbon.email.mgt.exceptions.I18nMgtEmailConfigException;
import org.wso2.carbon.email.mgt.model.EmailTemplate;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.utils.CarbonUtils;

public class I18nEmailUtil {
    private static final Log log = LogFactory.getLog(I18nEmailUtil.class);
    public static final String CHARSET_CONSTANT = "charset";
    public static final String CHARSET_UTF_8 = "charset=" + StandardCharsets.UTF_8;

    private I18nEmailUtil() {
    }

    public static String getNormalizedName(String templateTypeName) {
        if (StringUtils.isNotBlank((String)templateTypeName)) {
            return templateTypeName.replaceAll("\\s+", "").toLowerCase();
        }
        throw new IllegalArgumentException("Invalid template type name provided : " + templateTypeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<EmailTemplate> getDefaultEmailTemplates() {
        String configFilePath = CarbonUtils.getCarbonConfigDirPath() + File.separator + "email" + File.separator + "email-admin-config.xml";
        ArrayList<EmailTemplate> defaultTemplates = new ArrayList<EmailTemplate>();
        File configFile = new File(configFilePath);
        if (!configFile.exists()) {
            log.error((Object)("Email Configuration File is not present at: " + configFilePath));
        }
        XMLStreamReader xmlStreamReader = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(configFile);
            xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(xmlStreamReader);
            OMElement documentElement = builder.getDocumentElement();
            Iterator iterator = documentElement.getChildElements();
            while (iterator.hasNext()) {
                OMElement omElement = (OMElement)iterator.next();
                String type = omElement.getAttributeValue(new QName("type"));
                String displayName = omElement.getAttributeValue(new QName("display"));
                String locale = omElement.getAttributeValue(new QName("locale"));
                String contentType = omElement.getAttributeValue(new QName("emailContentType"));
                Map<String, String> emailContentMap = I18nEmailUtil.getEmailContent(omElement);
                String subject = emailContentMap.get("subject");
                String body = emailContentMap.get("body");
                String footer = emailContentMap.get("footer");
                EmailTemplate emailTemplateDTO = new EmailTemplate();
                emailTemplateDTO.setTemplateType(type);
                emailTemplateDTO.setTemplateDisplayName(displayName);
                emailTemplateDTO.setLocale(locale);
                emailTemplateDTO.setEmailContentType(contentType);
                emailTemplateDTO.setSubject(subject);
                emailTemplateDTO.setBody(body);
                emailTemplateDTO.setFooter(footer);
                defaultTemplates.add(emailTemplateDTO);
            }
        }
        catch (FileNotFoundException | XMLStreamException e) {
            log.warn((Object)"Error while loading default templates to the registry.", (Throwable)e);
        }
        finally {
            try {
                if (xmlStreamReader != null) {
                    xmlStreamReader.close();
                }
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (XMLStreamException e) {
                log.error((Object)"Error while closing XML stream", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"Error while closing input stream", (Throwable)e);
            }
        }
        return defaultTemplates;
    }

    private static Map<String, String> getEmailContent(OMElement templateElement) {
        HashMap<String, String> emailContentMap = new HashMap<String, String>();
        Iterator it = templateElement.getChildElements();
        while (it.hasNext()) {
            OMElement element = (OMElement)it.next();
            String elementName = element.getLocalName();
            String elementText = element.getText();
            if (StringUtils.equalsIgnoreCase((String)"subject", (String)elementName)) {
                emailContentMap.put("subject", elementText);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"body", (String)elementName)) {
                emailContentMap.put("body", elementText);
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((String)"footer", (String)elementName)) continue;
            emailContentMap.put("footer", elementText);
        }
        return emailContentMap;
    }

    public static Resource createTemplateResource(EmailTemplate emailTemplate) throws I18nEmailMgtException {
        ResourceImpl templateResource = new ResourceImpl();
        String templateDisplayName = emailTemplate.getTemplateDisplayName();
        String templateType = I18nEmailUtil.getNormalizedName(templateDisplayName);
        String locale = emailTemplate.getLocale();
        String contentType = emailTemplate.getEmailContentType();
        String subject = emailTemplate.getSubject();
        String body = emailTemplate.getBody();
        String footer = emailTemplate.getFooter();
        templateResource.setProperty("display", templateDisplayName);
        templateResource.setProperty("type", templateType);
        templateResource.setProperty("locale", locale);
        templateResource.setProperty("emailContentType", contentType);
        templateResource.setMediaType("tag");
        String[] contentArray = new String[]{subject, body, footer};
        String content = new Gson().toJson((Object)contentArray);
        try {
            byte[] contentByteArray = content.getBytes("UTF-8");
            templateResource.setContent((Object)contentByteArray);
        }
        catch (UnsupportedEncodingException | RegistryException e) {
            String error = "Error creating a registry resource from contents of %s email template type in %s locale.";
            throw new I18nEmailMgtServerException(String.format(error, templateDisplayName, locale), e);
        }
        return templateResource;
    }

    public static EmailTemplate getEmailTemplate(Resource templateResource) throws I18nEmailMgtException {
        EmailTemplate emailTemplate;
        block7: {
            emailTemplate = new EmailTemplate();
            try {
                String templateDisplayName = templateResource.getProperty("display");
                String templateType = templateResource.getProperty("type");
                String contentType = templateResource.getProperty("emailContentType");
                if (contentType != null && !contentType.toLowerCase().contains(CHARSET_CONSTANT)) {
                    contentType = contentType + "; " + CHARSET_UTF_8;
                }
                String locale = templateResource.getProperty("locale");
                emailTemplate.setTemplateDisplayName(templateDisplayName);
                emailTemplate.setTemplateType(templateType);
                emailTemplate.setEmailContentType(contentType);
                emailTemplate.setLocale(locale);
                Object content = templateResource.getContent();
                if (content != null) {
                    String[] templateContentElements;
                    byte[] templateContentArray = (byte[])content;
                    String templateContent = new String(templateContentArray, Charset.forName("UTF-8"));
                    try {
                        templateContentElements = (String[])new Gson().fromJson(templateContent, String[].class);
                    }
                    catch (JsonSyntaxException ex) {
                        String error = "Error deserializing '%s:%s' template from tenant registry.";
                        throw new I18nEmailMgtServerException(String.format(error, templateDisplayName, locale), ex);
                    }
                    if (templateContentElements == null || templateContentElements.length != 3) {
                        String errorMsg = "Template %s:%s body is in invalid format. Missing subject,body or footer.";
                        throw new I18nMgtEmailConfigException(String.format(errorMsg, templateDisplayName, locale));
                    }
                    emailTemplate.setSubject(templateContentElements[0]);
                    emailTemplate.setBody(templateContentElements[1]);
                    emailTemplate.setFooter(templateContentElements[2]);
                    break block7;
                }
                String error = String.format("Unable to find any content in %s:%s email template.", templateDisplayName, locale);
                log.error((Object)error);
            }
            catch (RegistryException e) {
                String error = "Error retrieving a template object from the registry resource";
                throw new I18nEmailMgtServerException(error, e);
            }
        }
        return emailTemplate;
    }

    public static Collection createTemplateType(String normalizedTemplateName, String templateDisplayName) {
        CollectionImpl collection = new CollectionImpl();
        collection.addProperty("templateName", normalizedTemplateName);
        collection.addProperty("templateDisplayName", templateDisplayName);
        return collection;
    }

    public static String prependOperationScenarioToErrorCode(String exceptionErrorCode, String scenario) {
        if (StringUtils.isNotEmpty((String)exceptionErrorCode)) {
            if (exceptionErrorCode.contains("-")) {
                return exceptionErrorCode;
            }
            if (StringUtils.isNotEmpty((String)scenario)) {
                exceptionErrorCode = scenario + "-" + exceptionErrorCode;
            }
        }
        return exceptionErrorCode;
    }
}

