/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.email.mgt.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.email.mgt.EmailTemplateManagerImpl;
import org.wso2.carbon.email.mgt.exceptions.I18nEmailMgtException;
import org.wso2.carbon.identity.governance.exceptions.notiification.NotificationTemplateManagerException;
import org.wso2.carbon.identity.governance.service.notification.NotificationChannels;
import org.wso2.carbon.stratos.common.beans.TenantInfoBean;
import org.wso2.carbon.stratos.common.exception.StratosException;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;

public class TenantManagementListener
implements TenantMgtListener {
    private static final int EXEC_ORDER = 21;
    private static final Log log = LogFactory.getLog(TenantManagementListener.class);

    public void onTenantCreate(TenantInfoBean tenantInfo) throws StratosException {
        String tenantDomain = tenantInfo.getTenantDomain();
        EmailTemplateManagerImpl templateManager = new EmailTemplateManagerImpl();
        try {
            templateManager.addDefaultEmailTemplates(tenantDomain);
        }
        catch (I18nEmailMgtException e) {
            String message = "Error occurred while loading default email templates for the tenant : " + tenantDomain;
            log.error((Object)message);
            throw new StratosException(message, (Throwable)e);
        }
        try {
            EmailTemplateManagerImpl notificationTemplateManager = new EmailTemplateManagerImpl();
            notificationTemplateManager.addDefaultNotificationTemplates(NotificationChannels.SMS_CHANNEL.getChannelType(), tenantDomain);
        }
        catch (NotificationTemplateManagerException e) {
            String message = "Error occurred while loading default SMS notification templates for the tenant : " + tenantDomain;
            log.error((Object)message);
            throw new StratosException(message, (Throwable)e);
        }
    }

    public void onTenantUpdate(TenantInfoBean tenantInfo) throws StratosException {
    }

    public void onPreDelete(int tenantId) throws StratosException {
    }

    public void onTenantDelete(int i) {
    }

    public void onTenantRename(int tenantId, String oldDomainName, String newDomainName) throws StratosException {
    }

    public int getListenerOrder() {
        return 21;
    }

    public void onTenantInitialActivation(int tenantId) throws StratosException {
    }

    public void onTenantActivation(int tenantId) throws StratosException {
    }

    public void onTenantDeactivation(int tenantId) throws StratosException {
    }

    public void onSubscriptionPlanChange(int tenentId, String oldPlan, String newPlan) throws StratosException {
    }
}

