/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.email.mgt.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.email.mgt.EmailTemplateManager;
import org.wso2.carbon.email.mgt.EmailTemplateManagerImpl;
import org.wso2.carbon.email.mgt.exceptions.I18nEmailMgtException;
import org.wso2.carbon.email.mgt.internal.I18nMgtDataHolder;
import org.wso2.carbon.email.mgt.internal.TenantManagementListener;
import org.wso2.carbon.identity.core.persistence.registry.RegistryResourceMgtService;
import org.wso2.carbon.identity.governance.exceptions.notiification.NotificationTemplateManagerException;
import org.wso2.carbon.identity.governance.service.notification.NotificationChannels;
import org.wso2.carbon.identity.governance.service.notification.NotificationTemplateManager;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="I18nMgtServiceComponent", immediate=true)
public class I18nMgtServiceComponent {
    private static final Log log = LogFactory.getLog(I18nMgtServiceComponent.class);
    private I18nMgtDataHolder dataHolder = I18nMgtDataHolder.getInstance();

    @Activate
    protected void activate(ComponentContext context) {
        try {
            ServiceRegistration notificationManagerSR;
            BundleContext bundleCtx = context.getBundleContext();
            EmailTemplateManagerImpl emailTemplateManager = new EmailTemplateManagerImpl();
            ServiceRegistration emailTemplateSR = bundleCtx.registerService(EmailTemplateManager.class.getName(), (Object)emailTemplateManager, null);
            if (emailTemplateSR != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Email Template Mgt Service registered.");
                }
            } else {
                log.error((Object)"Error registering Email Template Mgt Service.");
            }
            if ((notificationManagerSR = bundleCtx.registerService(NotificationTemplateManager.class.getName(), (Object)emailTemplateManager, null)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Notification Template Mgt Service registered.");
                }
            } else {
                log.error((Object)"Error registering Notification Template Mgt Service.");
            }
            TenantManagementListener emailMgtTenantListener = new TenantManagementListener();
            ServiceRegistration tenantMgtListenerSR = bundleCtx.registerService(TenantMgtListener.class.getName(), (Object)emailMgtTenantListener, null);
            if (tenantMgtListenerSR != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"I18n Management - TenantMgtListener registered");
                }
            } else {
                log.error((Object)"I18n Management - TenantMgtListener could not be registered");
            }
            this.loadDefaultEmailTemplates();
            this.loadDefaultSMSTemplates();
            log.debug((Object)"I18n Management is activated");
        }
        catch (Throwable e) {
            log.error((Object)"Error while activating I18n Management bundle", e);
        }
    }

    private void loadDefaultEmailTemplates() {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        EmailTemplateManagerImpl emailTemplateManager = new EmailTemplateManagerImpl();
        try {
            emailTemplateManager.addDefaultEmailTemplates(tenantDomain);
        }
        catch (I18nEmailMgtException e) {
            log.error((Object)"Error occurred while loading default email templates", (Throwable)e);
        }
    }

    private void loadDefaultSMSTemplates() {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        EmailTemplateManagerImpl notificationTemplateManager = new EmailTemplateManagerImpl();
        try {
            notificationTemplateManager.addDefaultNotificationTemplates(NotificationChannels.SMS_CHANNEL.getChannelType(), tenantDomain);
        }
        catch (NotificationTemplateManagerException e) {
            log.error((Object)"Error occurred while loading default SMS templates", (Throwable)e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"I18n Management bundle is de-activated");
        }
    }

    @Reference(name="realm.service", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Realm Service");
        }
        this.dataHolder.setRealmService(realmService);
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Registry Service");
        }
        this.dataHolder.setRegistryService(registryService);
    }

    @Reference(name="RegistryResourceMgtService", service=RegistryResourceMgtService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryResourceMgtService")
    protected void setRegistryResourceMgtService(RegistryResourceMgtService registryResourceMgtService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting Registry Resource Mgt Service.");
        }
        this.dataHolder.setRegistryResourceMgtService(registryResourceMgtService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UnSetting the Registry Service");
        }
        this.dataHolder.setRegistryService(null);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UnSetting the Realm Service");
        }
        this.dataHolder.setRealmService(null);
    }

    protected void unsetRegistryResourceMgtService(RegistryResourceMgtService registryResourceMgtService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UnSetting Registry Resource Mgt Service.");
        }
        this.dataHolder.setRegistryResourceMgtService(null);
    }
}

