/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.email.mgt;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.email.mgt.EmailTemplateManagerImpl;
import org.wso2.carbon.email.mgt.exceptions.I18nEmailMgtException;
import org.wso2.carbon.email.mgt.exceptions.I18nEmailMgtServerException;
import org.wso2.carbon.email.mgt.model.EmailTemplate;

public class I18nEmailMgtConfigService {
    private static final Log log = LogFactory.getLog(I18nEmailMgtConfigService.class);
    private EmailTemplateManagerImpl templateManager = new EmailTemplateManagerImpl();

    public void addEmailTemplateType(String emailTemplateDisplayName) throws I18nEmailMgtServerException {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        try {
            this.templateManager.addEmailTemplateType(emailTemplateDisplayName, tenantDomain);
        }
        catch (I18nEmailMgtException e) {
            String errorMsg = String.format("Error while adding email template type to %s tenant.", tenantDomain);
            this.handleException(errorMsg, e);
        }
    }

    public void deleteEmailTemplateType(String emailTemplateDisplayName) throws I18nEmailMgtServerException {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        try {
            this.templateManager.deleteEmailTemplateType(emailTemplateDisplayName, tenantDomain);
        }
        catch (I18nEmailMgtException e) {
            String errorMsg = "Error occurred while deleting email template type '%s' of %s tenant.";
            this.handleException(String.format(errorMsg, emailTemplateDisplayName, tenantDomain), e);
        }
    }

    public String[] getEmailTemplateTypes() throws I18nEmailMgtServerException {
        String[] emailTemplateTypes = null;
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        try {
            List<String> emailTemplateTypesList = this.templateManager.getAvailableTemplateTypes(tenantDomain);
            emailTemplateTypes = emailTemplateTypesList.toArray(new String[emailTemplateTypesList.size()]);
        }
        catch (I18nEmailMgtException e) {
            String errorMsg = String.format("Error while retrieving email template types of %s tenant.", tenantDomain);
            this.handleException(errorMsg, e);
        }
        return emailTemplateTypes;
    }

    public void saveEmailTemplate(EmailTemplate emailTemplate) throws I18nEmailMgtServerException {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        try {
            this.templateManager.addEmailTemplate(emailTemplate, tenantDomain);
        }
        catch (I18nEmailMgtException e) {
            String error = "Error occurred while updating email template in " + tenantDomain + " tenant registry.";
            this.handleException(error, e);
        }
    }

    public void addEmailTemplate(EmailTemplate emailTemplate) throws I18nEmailMgtServerException {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        try {
            this.templateManager.addEmailTemplate(emailTemplate, tenantDomain);
        }
        catch (I18nEmailMgtException e) {
            String errorMsg = "Error occurred while adding email template to " + tenantDomain + " tenant registry";
            this.handleException(errorMsg, e);
        }
    }

    public void deleteEmailTemplate(String emailTemplateDisplayName, String locale) throws I18nEmailMgtServerException {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        try {
            this.templateManager.deleteEmailTemplate(emailTemplateDisplayName, locale, tenantDomain);
        }
        catch (I18nEmailMgtException e) {
            String errorMsg = "Error occurred while deleting email template type '" + emailTemplateDisplayName + "' of locale '" + locale + "' in " + tenantDomain + " tenant registry.";
            this.handleException(errorMsg, e);
        }
    }

    public EmailTemplate[] getAllTemplatesForTenant() throws I18nEmailMgtServerException {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        EmailTemplate[] templates = null;
        try {
            List<EmailTemplate> templateDTOs = this.templateManager.getAllEmailTemplates(tenantDomain);
            templates = templateDTOs.toArray(new EmailTemplate[templateDTOs.size()]);
        }
        catch (I18nEmailMgtException e) {
            String errorMsg = "Error occurred while retrieving email templates of " + tenantDomain + " tenant.";
            this.handleException(errorMsg, e);
        }
        return templates;
    }

    private void handleException(String errorMessage, I18nEmailMgtException e) throws I18nEmailMgtServerException {
        log.error((Object)errorMessage, (Throwable)e);
        throw new I18nEmailMgtServerException(errorMessage, e);
    }
}

