/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.email.mgt;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.email.mgt.EmailTemplateManager;
import org.wso2.carbon.email.mgt.constants.I18nMgtConstants;
import org.wso2.carbon.email.mgt.exceptions.DuplicateEmailTemplateException;
import org.wso2.carbon.email.mgt.exceptions.I18nEmailMgtClientException;
import org.wso2.carbon.email.mgt.exceptions.I18nEmailMgtException;
import org.wso2.carbon.email.mgt.exceptions.I18nEmailMgtInternalException;
import org.wso2.carbon.email.mgt.exceptions.I18nEmailMgtServerException;
import org.wso2.carbon.email.mgt.exceptions.I18nMgtEmailConfigException;
import org.wso2.carbon.email.mgt.internal.I18nMgtDataHolder;
import org.wso2.carbon.email.mgt.model.EmailTemplate;
import org.wso2.carbon.email.mgt.util.I18nEmailUtil;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.base.IdentityValidationUtil;
import org.wso2.carbon.identity.core.persistence.registry.RegistryResourceMgtService;
import org.wso2.carbon.identity.governance.IdentityGovernanceUtil;
import org.wso2.carbon.identity.governance.IdentityMgtConstants;
import org.wso2.carbon.identity.governance.exceptions.notiification.NotificationTemplateManagerClientException;
import org.wso2.carbon.identity.governance.exceptions.notiification.NotificationTemplateManagerException;
import org.wso2.carbon.identity.governance.exceptions.notiification.NotificationTemplateManagerInternalException;
import org.wso2.carbon.identity.governance.exceptions.notiification.NotificationTemplateManagerServerException;
import org.wso2.carbon.identity.governance.model.NotificationTemplate;
import org.wso2.carbon.identity.governance.service.notification.NotificationChannels;
import org.wso2.carbon.identity.governance.service.notification.NotificationTemplateManager;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.utils.CarbonUtils;

public class EmailTemplateManagerImpl
implements EmailTemplateManager,
NotificationTemplateManager {
    private I18nMgtDataHolder dataHolder = I18nMgtDataHolder.getInstance();
    private RegistryResourceMgtService resourceMgtService = this.dataHolder.getRegistryResourceMgtService();
    private static final Log log = LogFactory.getLog(EmailTemplateManagerImpl.class);
    private static final String TEMPLATE_REGEX_KEY = I18nMgtConstants.class.getName() + "_" + "templateName";
    private static final String REGISTRY_INVALID_CHARS = I18nMgtConstants.class.getName() + "_registryInvalidChar";

    @Override
    public void addEmailTemplateType(String emailTemplateDisplayName, String tenantDomain) throws I18nEmailMgtException {
        try {
            this.addNotificationTemplateType(emailTemplateDisplayName, NotificationChannels.EMAIL_CHANNEL.getChannelType(), tenantDomain);
        }
        catch (NotificationTemplateManagerClientException e) {
            throw new I18nEmailMgtClientException(e.getMessage(), e);
        }
        catch (NotificationTemplateManagerInternalException e) {
            String errorCode;
            if (StringUtils.isNotBlank((String)e.getErrorCode()) && (errorCode = e.getErrorCode()).contains(I18nMgtConstants.ErrorMessages.ERROR_CODE_DUPLICATE_TEMPLATE_TYPE.getCode())) {
                throw new I18nEmailMgtInternalException("10002", e.getMessage(), e);
            }
            throw new I18nEmailMgtInternalException(e.getMessage(), e);
        }
        catch (NotificationTemplateManagerException e) {
            throw new I18nEmailMgtServerException(e.getMessage(), e);
        }
    }

    public void addNotificationTemplateType(String displayName, String notificationChannel, String tenantDomain) throws NotificationTemplateManagerException {
        this.validateDisplayNameOfTemplateType(displayName);
        String normalizedDisplayName = I18nEmailUtil.getNormalizedName(displayName);
        String path = this.buildTemplateRootDirectoryPath(normalizedDisplayName, notificationChannel);
        try {
            if (this.resourceMgtService.isResourceExists(path, tenantDomain)) {
                String code = I18nEmailUtil.prependOperationScenarioToErrorCode(I18nMgtConstants.ErrorMessages.ERROR_CODE_DUPLICATE_TEMPLATE_TYPE.getCode(), "ETM");
                String message = String.format(I18nMgtConstants.ErrorMessages.ERROR_CODE_DUPLICATE_TEMPLATE_TYPE.getMessage(), displayName, tenantDomain);
                throw new NotificationTemplateManagerInternalException(code, message);
            }
            Collection collection = I18nEmailUtil.createTemplateType(normalizedDisplayName, displayName);
            this.resourceMgtService.putIdentityResource((Resource)collection, path, tenantDomain);
        }
        catch (IdentityRuntimeException ex) {
            String code = I18nEmailUtil.prependOperationScenarioToErrorCode(I18nMgtConstants.ErrorMessages.ERROR_CODE_ERROR_ADDING_TEMPLATE.getCode(), "ETM");
            String message = String.format(I18nMgtConstants.ErrorMessages.ERROR_CODE_ERROR_ADDING_TEMPLATE.getMessage(), displayName, tenantDomain);
            throw new NotificationTemplateManagerServerException(code, message);
        }
    }

    @Override
    public void deleteEmailTemplateType(String emailTemplateDisplayName, String tenantDomain) throws I18nEmailMgtException {
        this.validateTemplateType(emailTemplateDisplayName, tenantDomain);
        String templateType = I18nEmailUtil.getNormalizedName(emailTemplateDisplayName);
        String path = "/identity/email/" + templateType;
        try {
            this.resourceMgtService.deleteIdentityResource(path, tenantDomain);
        }
        catch (IdentityRuntimeException ex) {
            String errorMsg = String.format("Error deleting email template type %s from %s tenant.", emailTemplateDisplayName, tenantDomain);
            this.handleServerException(errorMsg, ex);
        }
    }

    @Override
    public List<String> getAvailableTemplateTypes(String tenantDomain) throws I18nEmailMgtServerException {
        try {
            ArrayList<String> templateTypeList = new ArrayList<String>();
            Collection collection = (Collection)this.resourceMgtService.getIdentityResource("/identity/email", tenantDomain);
            for (String templatePath : collection.getChildren()) {
                Resource templateTypeResource = this.resourceMgtService.getIdentityResource(templatePath, tenantDomain);
                if (templateTypeResource == null) continue;
                String emailTemplateType = templateTypeResource.getProperty("templateDisplayName");
                templateTypeList.add(emailTemplateType);
            }
            return templateTypeList;
        }
        catch (IdentityRuntimeException | RegistryException ex) {
            String errorMsg = String.format("Error when retrieving email template types of %s tenant.", tenantDomain);
            throw new I18nEmailMgtServerException(errorMsg, ex);
        }
    }

    @Override
    public List<EmailTemplate> getAllEmailTemplates(String tenantDomain) throws I18nEmailMgtException {
        ArrayList<EmailTemplate> templateList = new ArrayList<EmailTemplate>();
        try {
            Collection baseDirectory = (Collection)this.resourceMgtService.getIdentityResource("/identity/email", tenantDomain);
            if (baseDirectory != null) {
                for (String templateTypeDirectory : baseDirectory.getChildren()) {
                    templateList.addAll(this.getAllTemplatesOfTemplateTypeFromRegistry(templateTypeDirectory, tenantDomain));
                }
            }
        }
        catch (IdentityRuntimeException | RegistryException e) {
            String error = String.format("Error when retrieving email templates of %s tenant.", tenantDomain);
            throw new I18nEmailMgtServerException(error, e);
        }
        return templateList;
    }

    @Override
    public EmailTemplate getEmailTemplate(String templateDisplayName, String locale, String tenantDomain) throws I18nEmailMgtException {
        try {
            NotificationTemplate notificationTemplate = this.getNotificationTemplate(NotificationChannels.EMAIL_CHANNEL.getChannelType(), templateDisplayName, locale, tenantDomain);
            return this.buildEmailTemplate(notificationTemplate);
        }
        catch (NotificationTemplateManagerException exception) {
            String errorCode = exception.getErrorCode();
            String errorMsg = exception.getMessage();
            Throwable throwable = exception.getCause();
            if (StringUtils.isNotEmpty((String)exception.getErrorCode())) {
                if (IdentityMgtConstants.ErrorMessages.ERROR_CODE_INVALID_NOTIFICATION_TEMPLATE.getCode().equals(errorCode) || IdentityMgtConstants.ErrorMessages.ERROR_CODE_NO_CONTENT_IN_TEMPLATE.getCode().equals(errorCode) || I18nMgtConstants.ErrorMessages.ERROR_CODE_INVALID_CHARACTERS_IN_TEMPLATE_NAME.getCode().equals(errorCode) || I18nMgtConstants.ErrorMessages.ERROR_CODE_INVALID_CHARACTERS_IN_LOCALE.getCode().equals(errorCode)) {
                    throw new I18nEmailMgtClientException(errorMsg, throwable);
                }
                if (IdentityMgtConstants.ErrorMessages.ERROR_CODE_INVALID_EMAIL_TEMPLATE_CONTENT.getCode().equals(errorCode)) {
                    throw new I18nMgtEmailConfigException(errorMsg, throwable);
                }
                if (IdentityMgtConstants.ErrorMessages.ERROR_CODE_NO_TEMPLATE_FOUND.getCode().equals(errorCode)) {
                    throw new I18nEmailMgtInternalException("10001", errorMsg, throwable);
                }
            }
            throw new I18nEmailMgtServerException(exception.getMessage(), exception.getCause());
        }
    }

    @Override
    public List<EmailTemplate> getEmailTemplateType(String templateDisplayName, String tenantDomain) throws I18nEmailMgtException {
        this.validateTemplateType(templateDisplayName, tenantDomain);
        String templateDirectory = I18nEmailUtil.getNormalizedName(templateDisplayName);
        String templateTypeRegistryPath = "/identity/email/" + templateDirectory;
        try {
            return this.getAllTemplatesOfTemplateTypeFromRegistry(templateTypeRegistryPath, tenantDomain);
        }
        catch (RegistryException ex) {
            String error = "Error when retrieving '%s' template type from %s tenant registry.";
            throw new I18nEmailMgtServerException(String.format(error, templateDisplayName, tenantDomain), ex);
        }
    }

    private EmailTemplate buildEmailTemplate(NotificationTemplate notificationTemplate) {
        EmailTemplate emailTemplate = new EmailTemplate();
        emailTemplate.setTemplateDisplayName(notificationTemplate.getDisplayName());
        emailTemplate.setTemplateType(notificationTemplate.getType());
        emailTemplate.setLocale(notificationTemplate.getLocale());
        emailTemplate.setBody(notificationTemplate.getBody());
        emailTemplate.setSubject(notificationTemplate.getSubject());
        emailTemplate.setFooter(notificationTemplate.getFooter());
        emailTemplate.setEmailContentType(notificationTemplate.getContentType());
        return emailTemplate;
    }

    private String getDefaultNotificationLocale(String notificationChannel) {
        if (NotificationChannels.SMS_CHANNEL.getChannelType().equals(notificationChannel)) {
            return "en_us";
        }
        return "en_us";
    }

    public NotificationTemplate getNotificationTemplate(String notificationChannel, String templateType, String locale, String tenantDomain) throws NotificationTemplateManagerException {
        notificationChannel = this.resolveNotificationChannel(notificationChannel);
        this.validateTemplateLocale(locale);
        this.validateDisplayNameOfTemplateType(templateType);
        NotificationTemplate notificationTemplate = null;
        String path = NotificationChannels.SMS_CHANNEL.getChannelType().equals(notificationChannel) ? "/identity/sms/" + I18nEmailUtil.getNormalizedName(templateType) : "/identity/email/" + I18nEmailUtil.getNormalizedName(templateType);
        try {
            Resource registryResource = this.resourceMgtService.getIdentityResource(path, tenantDomain, locale);
            if (registryResource != null) {
                notificationTemplate = this.getNotificationTemplate(registryResource, notificationChannel);
            }
        }
        catch (IdentityRuntimeException exception) {
            String error = String.format(IdentityMgtConstants.ErrorMessages.ERROR_CODE_ERROR_RETRIEVING_TEMPLATE_FROM_REGISTRY.getMessage(), templateType, locale, tenantDomain);
            throw new NotificationTemplateManagerServerException(IdentityMgtConstants.ErrorMessages.ERROR_CODE_ERROR_RETRIEVING_TEMPLATE_FROM_REGISTRY.getCode(), error, (Throwable)exception);
        }
        if (notificationTemplate == null) {
            String defaultLocale = this.getDefaultNotificationLocale(notificationChannel);
            if (StringUtils.equalsIgnoreCase((String)defaultLocale, (String)locale)) {
                String error = String.format(IdentityMgtConstants.ErrorMessages.ERROR_CODE_NO_TEMPLATE_FOUND.getMessage(), templateType, locale, tenantDomain);
                throw new NotificationTemplateManagerServerException(IdentityMgtConstants.ErrorMessages.ERROR_CODE_NO_TEMPLATE_FOUND.getCode(), error);
            }
            if (log.isDebugEnabled()) {
                String message = String.format("'%s' template in '%s' locale was not found in '%s' tenant. Trying to return the template in default locale : '%s'", templateType, locale, tenantDomain, "en_us");
                log.debug((Object)message);
            }
            return this.getNotificationTemplate(notificationChannel, templateType, defaultLocale, tenantDomain);
        }
        return notificationTemplate;
    }

    private NotificationTemplate getNotificationTemplate(Resource templateResource, String notificationChannel) throws NotificationTemplateManagerException {
        NotificationTemplate notificationTemplate = new NotificationTemplate();
        String displayName = templateResource.getProperty("display");
        String type = templateResource.getProperty("type");
        String locale = templateResource.getProperty("locale");
        if (NotificationChannels.EMAIL_CHANNEL.getChannelType().equals(notificationChannel)) {
            String contentType = templateResource.getProperty("emailContentType");
            if (contentType != null && !contentType.toLowerCase().contains("charset")) {
                contentType = contentType + "; " + I18nEmailUtil.CHARSET_UTF_8;
            }
            notificationTemplate.setContentType(contentType);
        }
        notificationTemplate.setDisplayName(displayName);
        notificationTemplate.setType(type);
        notificationTemplate.setLocale(locale);
        String[] templateContentElements = this.getTemplateElements(templateResource, notificationChannel, displayName, locale);
        if (NotificationChannels.SMS_CHANNEL.getChannelType().equals(notificationChannel)) {
            notificationTemplate.setBody(templateContentElements[0]);
        } else {
            notificationTemplate.setSubject(templateContentElements[0]);
            notificationTemplate.setBody(templateContentElements[1]);
            notificationTemplate.setFooter(templateContentElements[2]);
        }
        notificationTemplate.setNotificationChannel(notificationChannel);
        return notificationTemplate;
    }

    private String[] getTemplateElements(Resource templateResource, String notificationChannel, String displayName, String locale) throws NotificationTemplateManagerException {
        try {
            Object content = templateResource.getContent();
            if (content != null) {
                String[] templateContentElements;
                byte[] templateContentArray = (byte[])content;
                String templateContent = new String(templateContentArray, Charset.forName("UTF-8"));
                try {
                    templateContentElements = (String[])new Gson().fromJson(templateContent, String[].class);
                }
                catch (JsonSyntaxException exception) {
                    String error = String.format(IdentityMgtConstants.ErrorMessages.ERROR_CODE_DESERIALIZING_TEMPLATE_FROM_TENANT_REGISTRY.getMessage(), displayName, locale);
                    throw new NotificationTemplateManagerServerException(IdentityMgtConstants.ErrorMessages.ERROR_CODE_DESERIALIZING_TEMPLATE_FROM_TENANT_REGISTRY.getCode(), error, (Throwable)exception);
                }
                if (NotificationChannels.SMS_CHANNEL.getChannelType().equals(notificationChannel)) {
                    if (templateContentElements == null || templateContentElements.length != 1) {
                        String errorMsg = String.format(IdentityMgtConstants.ErrorMessages.ERROR_CODE_INVALID_SMS_TEMPLATE_CONTENT.getMessage(), displayName, locale);
                        throw new NotificationTemplateManagerServerException(IdentityMgtConstants.ErrorMessages.ERROR_CODE_INVALID_SMS_TEMPLATE_CONTENT.getCode(), errorMsg);
                    }
                } else if (templateContentElements == null || templateContentElements.length != 3) {
                    String errorMsg = String.format(IdentityMgtConstants.ErrorMessages.ERROR_CODE_INVALID_EMAIL_TEMPLATE_CONTENT.getMessage(), displayName, locale);
                    throw new NotificationTemplateManagerServerException(IdentityMgtConstants.ErrorMessages.ERROR_CODE_INVALID_EMAIL_TEMPLATE_CONTENT.getCode(), errorMsg);
                }
                return templateContentElements;
            }
            String error = String.format(IdentityMgtConstants.ErrorMessages.ERROR_CODE_NO_CONTENT_IN_TEMPLATE.getMessage(), displayName, locale);
            throw new NotificationTemplateManagerClientException(IdentityMgtConstants.ErrorMessages.ERROR_CODE_NO_CONTENT_IN_TEMPLATE.getCode(), error);
        }
        catch (RegistryException exception) {
            String error = IdentityMgtConstants.ErrorMessages.ERROR_CODE_ERROR_RETRIEVING_TEMPLATE_OBJECT_FROM_REGISTRY.getMessage();
            throw new NotificationTemplateManagerServerException(IdentityMgtConstants.ErrorMessages.ERROR_CODE_ERROR_RETRIEVING_TEMPLATE_OBJECT_FROM_REGISTRY.getCode(), error, (Throwable)exception);
        }
    }

    private String resolveNotificationChannel(String notificationChannel) {
        if (NotificationChannels.EMAIL_CHANNEL.getChannelType().equals(notificationChannel)) {
            return notificationChannel;
        }
        if (NotificationChannels.SMS_CHANNEL.getChannelType().equals(notificationChannel)) {
            return notificationChannel;
        }
        if (log.isDebugEnabled()) {
            String message = String.format("Notification channel : %s is not supported by the server. Notification channel changed to : %s", notificationChannel, IdentityGovernanceUtil.getDefaultNotificationChannel());
            log.debug((Object)message);
        }
        return IdentityGovernanceUtil.getDefaultNotificationChannel();
    }

    private Resource createTemplateRegistryResource(NotificationTemplate notificationTemplate) throws NotificationTemplateManagerServerException {
        String[] templateContent;
        String displayName = notificationTemplate.getDisplayName();
        String type = I18nEmailUtil.getNormalizedName(displayName);
        String locale = notificationTemplate.getLocale();
        String body = notificationTemplate.getBody();
        ResourceImpl templateResource = new ResourceImpl();
        templateResource.setProperty("display", displayName);
        templateResource.setProperty("type", type);
        templateResource.setProperty("locale", locale);
        if (NotificationChannels.EMAIL_CHANNEL.getChannelType().equals(notificationTemplate.getNotificationChannel())) {
            templateContent = new String[]{notificationTemplate.getSubject(), body, notificationTemplate.getFooter()};
            templateResource.setProperty("emailContentType", notificationTemplate.getContentType());
        } else {
            templateContent = new String[]{body};
        }
        templateResource.setMediaType("tag");
        String content = new Gson().toJson((Object)templateContent);
        try {
            byte[] contentByteArray = content.getBytes(StandardCharsets.UTF_8);
            templateResource.setContent((Object)contentByteArray);
        }
        catch (RegistryException e) {
            String code = I18nEmailUtil.prependOperationScenarioToErrorCode(I18nMgtConstants.ErrorMessages.ERROR_CODE_ERROR_CREATING_REGISTRY_RESOURCE.getCode(), "ETM");
            String message = String.format(I18nMgtConstants.ErrorMessages.ERROR_CODE_ERROR_CREATING_REGISTRY_RESOURCE.getMessage(), displayName, locale);
            throw new NotificationTemplateManagerServerException(code, message, (Throwable)e);
        }
        return templateResource;
    }

    public void addNotificationTemplate(NotificationTemplate notificationTemplate, String tenantDomain) throws NotificationTemplateManagerException {
        this.validateNotificationTemplate(notificationTemplate);
        String notificationChannel = notificationTemplate.getNotificationChannel();
        Resource templateResource = this.createTemplateRegistryResource(notificationTemplate);
        String displayName = notificationTemplate.getDisplayName();
        String type = I18nEmailUtil.getNormalizedName(displayName);
        String locale = notificationTemplate.getLocale();
        String path = this.buildTemplateRootDirectoryPath(type, notificationChannel);
        try {
            if (!this.resourceMgtService.isResourceExists(path, tenantDomain)) {
                this.addNotificationTemplateType(displayName, notificationChannel, tenantDomain);
                if (log.isDebugEnabled()) {
                    String msg = "Creating template type : %s in tenant registry : %s";
                    log.debug((Object)String.format(msg, displayName, tenantDomain));
                }
            }
            this.resourceMgtService.putIdentityResource(templateResource, path, tenantDomain, locale);
        }
        catch (IdentityRuntimeException e) {
            String code = I18nEmailUtil.prependOperationScenarioToErrorCode(I18nMgtConstants.ErrorMessages.ERROR_CODE_ERROR_ERROR_ADDING_TEMPLATE.getCode(), "ETM");
            String message = String.format(I18nMgtConstants.ErrorMessages.ERROR_CODE_ERROR_ERROR_ADDING_TEMPLATE.getMessage(), displayName, locale, tenantDomain);
            throw new NotificationTemplateManagerServerException(code, message);
        }
    }

    @Override
    public void addEmailTemplate(EmailTemplate emailTemplate, String tenantDomain) throws I18nEmailMgtException {
        NotificationTemplate notificationTemplate = this.buildNotificationTemplateFromEmailTemplate(emailTemplate);
        try {
            this.addNotificationTemplate(notificationTemplate, tenantDomain);
        }
        catch (NotificationTemplateManagerClientException e) {
            throw new I18nEmailMgtClientException(e.getMessage(), e);
        }
        catch (NotificationTemplateManagerInternalException e) {
            String errorCode;
            if (StringUtils.isNotBlank((String)e.getErrorCode()) && (errorCode = e.getErrorCode()).contains(I18nMgtConstants.ErrorMessages.ERROR_CODE_DUPLICATE_TEMPLATE_TYPE.getCode())) {
                throw new I18nEmailMgtInternalException("10002", e.getMessage(), e);
            }
            throw new I18nEmailMgtInternalException(e.getMessage(), e);
        }
        catch (NotificationTemplateManagerException e) {
            throw new I18nEmailMgtServerException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteEmailTemplate(String templateTypeName, String localeCode, String tenantDomain) throws I18nEmailMgtException {
        if (StringUtils.isBlank((String)templateTypeName)) {
            throw new I18nEmailMgtClientException("Cannot Delete template. Email displayName cannot be null.");
        }
        if (StringUtils.isBlank((String)localeCode)) {
            throw new I18nEmailMgtClientException("Cannot Delete template. Email locale cannot be null.");
        }
        String templateType = I18nEmailUtil.getNormalizedName(templateTypeName);
        String path = "/identity/email/" + templateType;
        try {
            this.resourceMgtService.deleteIdentityResource(path, tenantDomain, localeCode);
        }
        catch (IdentityRuntimeException ex) {
            String msg = String.format("Error deleting %s:%s template from %s tenant registry.", templateTypeName, localeCode, tenantDomain);
            this.handleServerException(msg, ex);
        }
    }

    @Override
    public void addDefaultEmailTemplates(String tenantDomain) throws I18nEmailMgtException {
        try {
            this.addDefaultNotificationTemplates(NotificationChannels.EMAIL_CHANNEL.getChannelType(), tenantDomain);
        }
        catch (NotificationTemplateManagerClientException e) {
            throw new I18nEmailMgtClientException(e.getMessage(), e);
        }
        catch (NotificationTemplateManagerInternalException e) {
            String errorCode;
            if (StringUtils.isNotBlank((String)e.getErrorCode()) && (errorCode = e.getErrorCode()).contains(I18nMgtConstants.ErrorMessages.ERROR_CODE_DUPLICATE_TEMPLATE_TYPE.getCode())) {
                throw new I18nEmailMgtInternalException("10002", e.getMessage(), e);
            }
            throw new I18nEmailMgtInternalException(e.getMessage(), e);
        }
        catch (NotificationTemplateManagerException e) {
            throw new I18nEmailMgtServerException(e.getMessage(), e);
        }
        try {
            List<EmailTemplate> defaultTemplates = I18nEmailUtil.getDefaultEmailTemplates();
            for (EmailTemplate emailTemplateDTO : defaultTemplates) {
                String templateTypeDisplayName = emailTemplateDTO.getTemplateDisplayName();
                String templateType = I18nEmailUtil.getNormalizedName(templateTypeDisplayName);
                String path = "/identity/email/" + templateType;
                if (this.resourceMgtService.isResourceExists(path, tenantDomain)) continue;
                try {
                    this.addEmailTemplate(emailTemplateDTO, tenantDomain);
                }
                catch (DuplicateEmailTemplateException e) {
                    log.warn((Object)("Template" + templateTypeDisplayName + "already exists in the registry,Hence ignoring addition"));
                }
                if (!log.isDebugEnabled()) continue;
                String msg = "Default template added to %s tenant registry : %n%s";
                log.debug((Object)String.format(msg, tenantDomain, emailTemplateDTO.toString()));
            }
            if (log.isDebugEnabled()) {
                String msg = "Added %d default email templates to %s tenant registry";
                log.debug((Object)String.format(msg, defaultTemplates.size(), tenantDomain));
            }
        }
        catch (IdentityRuntimeException ex) {
            String error = "Error when tried to check for default email templates in %s tenant registry";
            log.error((Object)String.format(error, tenantDomain), (Throwable)ex);
        }
    }

    public void addDefaultNotificationTemplates(String notificationChannel, String tenantDomain) throws NotificationTemplateManagerException {
        List<NotificationTemplate> notificationTemplates = this.getDefaultNotificationTemplates(notificationChannel);
        int numberOfAddedTemplates = 0;
        try {
            for (NotificationTemplate template : notificationTemplates) {
                String displayName = template.getDisplayName();
                String type = I18nEmailUtil.getNormalizedName(displayName);
                String locale = template.getLocale();
                String path = this.buildTemplateRootDirectoryPath(type, notificationChannel);
                if (this.resourceMgtService.isResourceExists(this.addLocaleToTemplateTypeResourcePath(path, locale), tenantDomain)) continue;
                try {
                    this.addNotificationTemplate(template, tenantDomain);
                    if (log.isDebugEnabled()) {
                        String msg = "Default template added to %s tenant registry : %n%s";
                        log.debug((Object)String.format(msg, tenantDomain, template.toString()));
                    }
                    ++numberOfAddedTemplates;
                }
                catch (NotificationTemplateManagerInternalException e) {
                    log.warn((Object)("Template : " + displayName + "already exists in the registry. Hence ignoring addition"));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Added %d default %s templates to the tenant registry : %s", numberOfAddedTemplates, notificationChannel, tenantDomain));
            }
        }
        catch (IdentityRuntimeException ex) {
            String error = "Error when tried to check for default email templates in tenant registry : %s";
            log.error((Object)String.format(error, tenantDomain), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NotificationTemplate> getDefaultNotificationTemplates(String notificationChannel) {
        String configFilePath = this.buildNotificationTemplateConfigPath(notificationChannel);
        File configFile = new File(configFilePath);
        if (!configFile.exists()) {
            log.error((Object)("Email Configuration File is not present at: " + configFilePath));
        }
        ArrayList<NotificationTemplate> defaultNotificationTemplates = new ArrayList<NotificationTemplate>();
        XMLStreamReader xmlStreamReader = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(configFile);
            xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(xmlStreamReader);
            OMElement documentElement = builder.getDocumentElement();
            Iterator iterator = documentElement.getChildElements();
            while (iterator.hasNext()) {
                OMElement omElement = (OMElement)iterator.next();
                Map<String, String> templateContentMap = EmailTemplateManagerImpl.getNotificationTemplateContent(omElement);
                NotificationTemplate notificationTemplate = new NotificationTemplate();
                notificationTemplate.setType(omElement.getAttributeValue(new QName("type")));
                notificationTemplate.setDisplayName(omElement.getAttributeValue(new QName("display")));
                notificationTemplate.setLocale(omElement.getAttributeValue(new QName("locale")));
                notificationTemplate.setBody(templateContentMap.get("body"));
                notificationTemplate.setNotificationChannel(notificationChannel);
                if (NotificationChannels.EMAIL_CHANNEL.getChannelType().equals(notificationChannel)) {
                    notificationTemplate.setContentType(omElement.getAttributeValue(new QName("emailContentType")));
                    notificationTemplate.setFooter(templateContentMap.get("footer"));
                    notificationTemplate.setSubject(templateContentMap.get("subject"));
                }
                defaultNotificationTemplates.add(notificationTemplate);
            }
        }
        catch (FileNotFoundException | XMLStreamException e) {
            log.warn((Object)"Error while loading default templates to the registry.", (Throwable)e);
        }
        finally {
            try {
                if (xmlStreamReader != null) {
                    xmlStreamReader.close();
                }
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (XMLStreamException e) {
                log.error((Object)"Error while closing XML stream", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"Error while closing input stream", (Throwable)e);
            }
        }
        return defaultNotificationTemplates;
    }

    private static Map<String, String> getNotificationTemplateContent(OMElement templateElement) {
        HashMap<String, String> notificationTemplateContent = new HashMap<String, String>();
        Iterator it = templateElement.getChildElements();
        while (it.hasNext()) {
            OMElement element = (OMElement)it.next();
            String elementName = element.getLocalName();
            String elementText = element.getText();
            if (StringUtils.equalsIgnoreCase((String)"subject", (String)elementName)) {
                notificationTemplateContent.put("subject", elementText);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"body", (String)elementName)) {
                notificationTemplateContent.put("body", elementText);
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((String)"footer", (String)elementName)) continue;
            notificationTemplateContent.put("footer", elementText);
        }
        return notificationTemplateContent;
    }

    private String buildNotificationTemplateConfigPath(String notificationChannel) {
        if (NotificationChannels.SMS_CHANNEL.getChannelType().equals(notificationChannel)) {
            return CarbonUtils.getCarbonConfigDirPath() + File.separator + "sms" + File.separator + "sms-templates-admin-config.xml";
        }
        return CarbonUtils.getCarbonConfigDirPath() + File.separator + "email" + File.separator + "email-admin-config.xml";
    }

    @Override
    public boolean isEmailTemplateExists(String templateTypeDisplayName, String locale, String tenantDomain) throws I18nEmailMgtException {
        String normalizedTemplateName = I18nEmailUtil.getNormalizedName(templateTypeDisplayName);
        String path = "/identity/email/" + normalizedTemplateName + "/" + locale.toLowerCase();
        try {
            Resource template = this.resourceMgtService.getIdentityResource(path, tenantDomain);
            return template != null;
        }
        catch (IdentityRuntimeException e) {
            String error = String.format("Error when retrieving email templates of %s tenant.", tenantDomain);
            throw new I18nEmailMgtServerException(error, e);
        }
    }

    @Override
    public boolean isEmailTemplateTypeExists(String templateTypeDisplayName, String tenantDomain) throws I18nEmailMgtException {
        String normalizedTemplateName = I18nEmailUtil.getNormalizedName(templateTypeDisplayName);
        String path = "/identity/email/" + normalizedTemplateName;
        try {
            Resource templateType = this.resourceMgtService.getIdentityResource(path, tenantDomain);
            return templateType != null;
        }
        catch (IdentityRuntimeException e) {
            String error = String.format("Error when retrieving email templates of %s tenant.", tenantDomain);
            throw new I18nEmailMgtServerException(error, e);
        }
    }

    private void validateNotificationTemplate(NotificationTemplate notificationTemplate) throws NotificationTemplateManagerClientException {
        if (notificationTemplate == null) {
            String errorCode = I18nEmailUtil.prependOperationScenarioToErrorCode(I18nMgtConstants.ErrorMessages.ERROR_CODE_NULL_TEMPLATE_OBJECT.getCode(), "ETM");
            throw new NotificationTemplateManagerClientException(errorCode, I18nMgtConstants.ErrorMessages.ERROR_CODE_NULL_TEMPLATE_OBJECT.getMessage());
        }
        String displayName = notificationTemplate.getDisplayName();
        this.validateDisplayNameOfTemplateType(displayName);
        String normalizedDisplayName = I18nEmailUtil.getNormalizedName(displayName);
        if (!StringUtils.equalsIgnoreCase((String)normalizedDisplayName, (String)notificationTemplate.getType())) {
            if (log.isDebugEnabled()) {
                String message = String.format("In the template normalizedDisplayName : %s is not equal to the template type : %s. Therefore template type is sent to : %s", normalizedDisplayName, notificationTemplate.getType(), normalizedDisplayName);
                log.debug((Object)message);
            }
            notificationTemplate.setType(normalizedDisplayName);
        }
        this.validateTemplateLocale(notificationTemplate.getLocale());
        String body = notificationTemplate.getBody();
        String subject = notificationTemplate.getSubject();
        String footer = notificationTemplate.getFooter();
        if (StringUtils.isBlank((String)notificationTemplate.getNotificationChannel())) {
            String errorCode = I18nEmailUtil.prependOperationScenarioToErrorCode(I18nMgtConstants.ErrorMessages.ERROR_CODE_EMPTY_TEMPLATE_CHANNEL.getCode(), "ETM");
            throw new NotificationTemplateManagerClientException(errorCode, I18nMgtConstants.ErrorMessages.ERROR_CODE_EMPTY_TEMPLATE_CHANNEL.getMessage());
        }
        if (NotificationChannels.SMS_CHANNEL.getChannelType().equals(notificationTemplate.getNotificationChannel())) {
            if (StringUtils.isBlank((String)body)) {
                String errorCode = I18nEmailUtil.prependOperationScenarioToErrorCode(I18nMgtConstants.ErrorMessages.ERROR_CODE_INVALID_SMS_TEMPLATE.getCode(), "ETM");
                throw new NotificationTemplateManagerClientException(errorCode, I18nMgtConstants.ErrorMessages.ERROR_CODE_INVALID_SMS_TEMPLATE.getMessage());
            }
            if (StringUtils.isNotBlank((String)subject) || StringUtils.isNotBlank((String)footer)) {
                String errorCode = I18nEmailUtil.prependOperationScenarioToErrorCode(I18nMgtConstants.ErrorMessages.ERROR_CODE_INVALID_SMS_TEMPLATE_CONTENT.getCode(), "ETM");
                throw new NotificationTemplateManagerClientException(errorCode, I18nMgtConstants.ErrorMessages.ERROR_CODE_INVALID_SMS_TEMPLATE_CONTENT.getMessage());
            }
        } else if (StringUtils.isBlank((String)subject) || StringUtils.isBlank((String)body) || StringUtils.isBlank((String)footer)) {
            String errorCode = I18nEmailUtil.prependOperationScenarioToErrorCode(I18nMgtConstants.ErrorMessages.ERROR_CODE_INVALID_EMAIL_TEMPLATE.getCode(), "ETM");
            throw new NotificationTemplateManagerClientException(errorCode, I18nMgtConstants.ErrorMessages.ERROR_CODE_INVALID_EMAIL_TEMPLATE.getMessage());
        }
    }

    private void validateTemplateType(String templateDisplayName, String tenantDomain) throws I18nEmailMgtClientException {
        try {
            this.validateDisplayNameOfTemplateType(templateDisplayName);
        }
        catch (NotificationTemplateManagerClientException e) {
            if (StringUtils.isNotBlank((String)e.getErrorCode())) {
                String errorCode = e.getErrorCode();
                if (errorCode.contains(I18nMgtConstants.ErrorMessages.ERROR_CODE_EMPTY_TEMPLATE_NAME.getCode())) {
                    throw new I18nEmailMgtClientException("Template Type display name cannot be null", e);
                }
                if (errorCode.contains(I18nMgtConstants.ErrorMessages.ERROR_CODE_INVALID_CHARACTERS_IN_TEMPLATE_NAME.getCode())) {
                    throw new I18nEmailMgtClientException(e.getMessage(), e);
                }
            }
            throw new I18nEmailMgtClientException("Invalid notification template", e);
        }
    }

    private List<EmailTemplate> getAllTemplatesOfTemplateTypeFromRegistry(String templateTypeRegistryPath, String tenantDomain) throws RegistryException, I18nEmailMgtClientException {
        ArrayList<EmailTemplate> templateList = new ArrayList<EmailTemplate>();
        Collection templateType = (Collection)this.resourceMgtService.getIdentityResource(templateTypeRegistryPath, tenantDomain);
        if (templateType == null) {
            String type = templateTypeRegistryPath.split("/")[templateTypeRegistryPath.split("/").length - 1];
            String message = String.format("Email Template Type: %s not found in %s tenant registry.", type, tenantDomain);
            throw new I18nEmailMgtClientException("10003", message);
        }
        for (String template : templateType.getChildren()) {
            Resource templateResource = this.resourceMgtService.getIdentityResource(template, tenantDomain);
            if (templateResource == null) continue;
            try {
                EmailTemplate templateDTO = I18nEmailUtil.getEmailTemplate(templateResource);
                templateList.add(templateDTO);
            }
            catch (I18nEmailMgtException ex) {
                log.error((Object)"Failed retrieving a template object from the registry resource", (Throwable)ex);
            }
        }
        return templateList;
    }

    private void handleServerException(String errorMsg, Throwable ex) throws I18nEmailMgtServerException {
        log.error((Object)errorMsg);
        throw new I18nEmailMgtServerException(errorMsg, ex);
    }

    private void validateDisplayNameOfTemplateType(String displayName) throws NotificationTemplateManagerClientException {
        if (StringUtils.isBlank((String)displayName)) {
            String errorCode = I18nEmailUtil.prependOperationScenarioToErrorCode(I18nMgtConstants.ErrorMessages.ERROR_CODE_EMPTY_TEMPLATE_NAME.getCode(), "ETM");
            throw new NotificationTemplateManagerClientException(errorCode, I18nMgtConstants.ErrorMessages.ERROR_CODE_EMPTY_TEMPLATE_NAME.getMessage());
        }
        String[] whiteListPatterns = new String[]{TEMPLATE_REGEX_KEY};
        String[] blackListPatterns = new String[]{REGISTRY_INVALID_CHARS};
        if (!IdentityValidationUtil.isValid((String)displayName, (String[])whiteListPatterns, (String[])blackListPatterns)) {
            String errorCode = I18nEmailUtil.prependOperationScenarioToErrorCode(I18nMgtConstants.ErrorMessages.ERROR_CODE_INVALID_CHARACTERS_IN_TEMPLATE_NAME.getCode(), "ETM");
            String message = String.format(I18nMgtConstants.ErrorMessages.ERROR_CODE_INVALID_CHARACTERS_IN_TEMPLATE_NAME.getMessage(), displayName);
            throw new NotificationTemplateManagerClientException(errorCode, message);
        }
    }

    private void validateTemplateLocale(String locale) throws NotificationTemplateManagerClientException {
        if (StringUtils.isBlank((String)locale)) {
            String errorCode = I18nEmailUtil.prependOperationScenarioToErrorCode(I18nMgtConstants.ErrorMessages.ERROR_CODE_EMPTY_LOCALE.getCode(), "ETM");
            throw new NotificationTemplateManagerClientException(errorCode, I18nMgtConstants.ErrorMessages.ERROR_CODE_EMPTY_LOCALE.getMessage());
        }
        if (!IdentityValidationUtil.isValidOverBlackListPatterns((String)locale, (String[])new String[]{REGISTRY_INVALID_CHARS})) {
            String errorCode = I18nEmailUtil.prependOperationScenarioToErrorCode(I18nMgtConstants.ErrorMessages.ERROR_CODE_INVALID_CHARACTERS_IN_LOCALE.getCode(), "ETM");
            String message = String.format(I18nMgtConstants.ErrorMessages.ERROR_CODE_INVALID_CHARACTERS_IN_LOCALE.getMessage(), locale);
            throw new NotificationTemplateManagerClientException(errorCode, message);
        }
    }

    private String addLocaleToTemplateTypeResourcePath(String path, String locale) {
        if (StringUtils.isNotBlank((String)locale)) {
            return path + "/" + locale.toLowerCase();
        }
        return path;
    }

    private String buildTemplateRootDirectoryPath(String type, String notificationChannel) {
        if (NotificationChannels.SMS_CHANNEL.getChannelType().equals(notificationChannel)) {
            return "/identity/sms/" + type;
        }
        return "/identity/email/" + type;
    }

    private NotificationTemplate buildNotificationTemplateFromEmailTemplate(EmailTemplate emailTemplate) {
        NotificationTemplate notificationTemplate = new NotificationTemplate();
        notificationTemplate.setNotificationChannel(NotificationChannels.EMAIL_CHANNEL.getChannelType());
        notificationTemplate.setSubject(emailTemplate.getSubject());
        notificationTemplate.setBody(emailTemplate.getBody());
        notificationTemplate.setFooter(emailTemplate.getFooter());
        notificationTemplate.setType(emailTemplate.getTemplateType());
        notificationTemplate.setDisplayName(emailTemplate.getTemplateDisplayName());
        notificationTemplate.setLocale(emailTemplate.getLocale());
        notificationTemplate.setContentType(emailTemplate.getEmailContentType());
        return notificationTemplate;
    }

    static {
        IdentityValidationUtil.addPattern((String)TEMPLATE_REGEX_KEY, (String)"[a-zA-Z0-9\\s]+");
        IdentityValidationUtil.addPattern((String)REGISTRY_INVALID_CHARS, (String)IdentityValidationUtil.ValidatorPattern.REGISTRY_INVALID_CHARS_EXISTS.getRegex());
    }
}

