/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.common.ui.utils;

import java.io.IOException;
import java.io.StringReader;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.context.ConfigurationContext;
import org.wso2.carbon.registry.common.ui.utils.TreeNode;
import org.wso2.carbon.server.admin.common.IServerAdmin;
import org.wso2.carbon.server.admin.ui.ServerAdminClient;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.ui.clients.RegistryAdminServiceClient;

public class UIUtil {
    private static final String[] hexamap = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0A", "%0B", "%0C", "%0D", "%0E", "%0F", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1A", "%1B", "%1C", "%1D", "%1E", "%1F", "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "%2A", "%2B", "%2C", "%2D", "%2E", "%2F", "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37", "%38", "%39", "%3A", "%3B", "%3C", "%3D", "%3E", "%3F", "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47", "%48", "%49", "%4A", "%4B", "%4C", "%4D", "%4E", "%4F", "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57", "%58", "%59", "%5A", "%5B", "%5C", "%5D", "%5E", "%5F", "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67", "%68", "%69", "%6A", "%6B", "%6C", "%6D", "%6E", "%6F", "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77", "%78", "%79", "%7A", "%7B", "%7C", "%7D", "%7E", "%7F", "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", "%88", "%89", "%8A", "%8B", "%8C", "%8D", "%8E", "%8F", "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", "%98", "%99", "%9A", "%9B", "%9C", "%9D", "%9E", "%9F", "%A0", "%A1", "%A2", "%A3", "%A4", "%A5", "%A6", "%A7", "%A8", "%A9", "%AA", "%AB", "%AC", "%AD", "%AE", "%AF", "%B0", "%B1", "%B2", "%B3", "%B4", "%B5", "%B6", "%B7", "%B8", "%B9", "%BA", "%BB", "%BC", "%BD", "%BE", "%BF", "%C0", "%C1", "%C2", "%C3", "%C4", "%C5", "%C6", "%C7", "%C8", "%C9", "%CA", "%CB", "%CC", "%CD", "%CE", "%CF", "%D0", "%D1", "%D2", "%D3", "%D4", "%D5", "%D6", "%D7", "%D8", "%D9", "%DA", "%DB", "%DC", "%DD", "%DE", "%DF", "%E0", "%E1", "%E2", "%E3", "%E4", "%E5", "%E6", "%E7", "%E8", "%E9", "%EA", "%EB", "%EC", "%ED", "%EE", "%EF", "%F0", "%F1", "%F2", "%F3", "%F4", "%F5", "%F6", "%F7", "%F8", "%F9", "%FA", "%FB", "%FC", "%FD", "%FE", "%FF"};

    public static String getContextRoot(HttpServletRequest request) {
        String tenantDomain;
        String contextRoot = request.getContextPath();
        if (contextRoot.startsWith("//")) {
            contextRoot = contextRoot.substring(1);
        }
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        if (!contextRoot.endsWith("/")) {
            contextRoot = contextRoot + "/";
        }
        if (contextRoot.endsWith("carbon/") && !request.getServletPath().startsWith("/carbon")) {
            contextRoot = contextRoot.substring(0, contextRoot.length() - "carbon/".length());
        }
        if ((tenantDomain = (String)request.getSession().getAttribute("tenantDomain")) != null && !tenantDomain.equals("carbon.super")) {
            contextRoot = "/t/" + tenantDomain + contextRoot;
        }
        return contextRoot;
    }

    public static String getAtomURL(ServletConfig config, HttpServletRequest request, String resourcePath) {
        String remoteRegistryURL;
        String serverURL;
        ServletContext context = request.getSession().getServletContext();
        HttpSession session = request.getSession();
        String chroot = "";
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        try {
            serverURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
            ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
            IServerAdmin client = (IServerAdmin)CarbonUIUtil.getServerProxy((Object)new ServerAdminClient(configContext, serverURL, cookie, session), IServerAdmin.class, (HttpSession)session);
            RegistryAdminServiceClient registryAdminServiceClient = new RegistryAdminServiceClient(cookie, config, session);
            remoteRegistryURL = registryAdminServiceClient.getRegistryHTTPSURL();
            remoteRegistryURL = remoteRegistryURL.equals("#") ? null : remoteRegistryURL.substring(0, remoteRegistryURL.indexOf("/resource"));
        }
        catch (Exception e) {
            remoteRegistryURL = null;
        }
        if (remoteRegistryURL == null) {
            serverURL = CarbonUIUtil.getServerURL((ServletContext)context, (HttpSession)session);
            String serverRoot = serverURL.substring(0, serverURL.length() - "services/".length());
            String tenantDomain = null;
            tenantDomain = request.getSession().getAttribute("tenantDomain") != null ? (String)request.getSession().getAttribute("tenantDomain") : (String)request.getAttribute("tenantDomain");
            if (tenantDomain != null && !tenantDomain.equals("carbon.super")) {
                return serverRoot + "t" + "/" + tenantDomain + "/registry/atom" + UIUtil.encodeRegistryPath(resourcePath).replaceAll(" ", "+");
            }
            return serverRoot + "registry/atom" + UIUtil.encodeRegistryPath(resourcePath).replaceAll(" ", "+");
        }
        if (remoteRegistryURL.endsWith("/")) {
            remoteRegistryURL = remoteRegistryURL.substring(0, remoteRegistryURL.length() - "/".length());
        }
        String serverRoot = remoteRegistryURL.substring(0, remoteRegistryURL.length() - "registry".length());
        return serverRoot + "registry/atom" + UIUtil.encodeRegistryPath(chroot + resourcePath).replaceAll(" ", "+");
    }

    private static String encodeRegistryPath(String path) {
        if (path == null) {
            return null;
        }
        StringBuffer sbuf = new StringBuffer();
        int len = path.length();
        for (int i = 0; i < len; ++i) {
            char ch = path.charAt(i);
            if ('A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z' || '0' <= ch && ch <= '9') {
                sbuf.append(ch);
                continue;
            }
            if (ch == '-' || ch == '_' || ch == '.' || ch == '/' || ch == ' ' || ch == ';') {
                sbuf.append(ch);
                continue;
            }
            if (ch <= '\u007f') {
                sbuf.append(hexamap[ch]);
                continue;
            }
            if (ch <= '\u07ff') {
                sbuf.append(hexamap[0xC0 | ch >> 6]);
                sbuf.append(hexamap[0x80 | ch & 0x3F]);
                continue;
            }
            sbuf.append(hexamap[0xE0 | ch >> 12]);
            sbuf.append(hexamap[0x80 | ch >> 6 & 0x3F]);
            sbuf.append(hexamap[0x80 | ch & 0x3F]);
        }
        return sbuf.toString();
    }

    public static String getFirstPage(int pageNumber, int pageLength, String[] allNodes) {
        if (allNodes == null || allNodes.length == 0) {
            return "";
        }
        int start = (pageNumber - 1) * pageLength;
        if (start < 0 || allNodes.length <= start) {
            return "";
        }
        String startName = allNodes[start];
        if (startName.indexOf("/") != -1) {
            startName = startName.substring(startName.lastIndexOf("/") + 1);
        }
        return startName;
    }

    public static String getLastPage(int pageNumber, int pageLength, String[] allNodes) {
        if (allNodes == null || allNodes.length == 0) {
            return "";
        }
        int end = (pageNumber - 1) * pageLength + pageLength - 1;
        if (end >= allNodes.length) {
            end = allNodes.length - 1;
        }
        if (end < 0) {
            return "";
        }
        String endName = allNodes[end];
        if (endName.indexOf("/") != -1) {
            endName = endName.substring(endName.lastIndexOf("/") + 1);
        }
        return endName;
    }

    public static String[] getChildren(int start, int pageLength, String[] childPaths) {
        int availableLength = 0;
        if (childPaths != null && childPaths.length > 0) {
            availableLength = childPaths.length - start;
        }
        if (availableLength < pageLength) {
            pageLength = availableLength;
        }
        String[] resultChildPaths = new String[pageLength];
        System.arraycopy(childPaths, start, resultChildPaths, 0, pageLength);
        return resultChildPaths;
    }

    public static OMElement buildOMElement(String content) throws Exception {
        XMLStreamReader parser;
        try {
            parser = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(content));
        }
        catch (XMLStreamException e) {
            String msg = "Error in initializing the parser to build the OMElement.";
            throw new Exception(msg, e);
        }
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        return builder.getDocumentElement();
    }

    public static void printNodesOfTree(TreeNode parentNode, String parentNodeName, int count, JspWriter out) throws IOException {
        try {
            TreeNode[] children = parentNode.getChildNodes();
            String displayName = parentNode.getKey();
            String thisNodeName = "tempNode" + count;
            boolean isNodeValue = false;
            if (children != null && children.length == 1 && children[0].getChildNodes() == null && children[0].getKey() != null) {
                displayName = displayName + ": <strong>" + children[0].getKey() + "</strong>";
                isNodeValue = true;
            } else if (children == null) {
                displayName = "<strong>" + displayName + "</strong>";
            }
            out.write("var " + thisNodeName + " = new YAHOO.widget.TextNode(\"" + displayName + "\", " + parentNodeName + ", true);");
            if (children != null && !isNodeValue) {
                for (TreeNode child : children) {
                    UIUtil.printNodesOfTree(child, thisNodeName, ++count, out);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }
}

