/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.store.count.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.user.store.count.AbstractUserStoreCountRetriever;
import org.wso2.carbon.identity.user.store.count.UserStoreCountRetriever;
import org.wso2.carbon.identity.user.store.count.dto.PairDTO;
import org.wso2.carbon.identity.user.store.count.exception.UserStoreCounterException;
import org.wso2.carbon.identity.user.store.count.internal.UserStoreCountDataHolder;
import org.wso2.carbon.identity.user.store.count.jdbc.internal.InternalCountRetriever;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.UserStoreException;

public class UserStoreCountUtils {
    public static final String COUNT_RETRIEVER_CLASS = "CountRetrieverClass";
    private static final Log log = LogFactory.getLog(UserStoreCountUtils.class);
    public static final String USERNAME_CLAIM = "http://wso2.org/claims/username";

    public static Map<String, RealmConfiguration> getUserStoreList() throws UserStoreCounterException {
        HashMap<String, RealmConfiguration> userStoreList = new HashMap<String, RealmConfiguration>();
        try {
            RealmConfiguration realmConfiguration = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getRealmConfiguration();
            String domain = IdentityUtil.getPrimaryDomainName();
            userStoreList.put(domain, realmConfiguration);
            while (realmConfiguration != null && (realmConfiguration = realmConfiguration.getSecondaryRealmConfig()) != null) {
                domain = realmConfiguration.getUserStoreProperty("DomainName");
                userStoreList.put(domain, realmConfiguration);
            }
        }
        catch (UserStoreException e) {
            throw new UserStoreCounterException("Error while listing user stores for count functionality", e);
        }
        return userStoreList;
    }

    public static Set<String> getCountEnabledUserStores() throws UserStoreCounterException {
        HashSet<String> userStoreList = new HashSet<String>();
        try {
            for (RealmConfiguration realmConfiguration = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getRealmConfiguration(); realmConfiguration != null; realmConfiguration = realmConfiguration.getSecondaryRealmConfig()) {
                if (Boolean.valueOf(realmConfiguration.getUserStoreProperty("Disabled")).booleanValue() || !StringUtils.isNotEmpty((String)realmConfiguration.getUserStoreProperty(COUNT_RETRIEVER_CLASS))) continue;
                userStoreList.add(realmConfiguration.getUserStoreProperty("DomainName"));
            }
        }
        catch (UserStoreException e) {
            throw new UserStoreCounterException("Error while getting the count enabled user stores", e);
        }
        return userStoreList;
    }

    public static Set<String> getUserStoreDomains() throws UserStoreCounterException {
        return UserStoreCountUtils.getUserStoreList().keySet();
    }

    public static UserStoreCountRetriever getCounterInstanceForDomain(String domain) throws UserStoreCounterException {
        RealmConfiguration realmConfiguration;
        if (StringUtils.isEmpty((String)domain)) {
            domain = IdentityUtil.getPrimaryDomainName();
        }
        if ((realmConfiguration = UserStoreCountUtils.getUserStoreList().get(domain)) != null && realmConfiguration.getUserStoreProperty(COUNT_RETRIEVER_CLASS) != null) {
            String retrieverType = realmConfiguration.getUserStoreProperty(COUNT_RETRIEVER_CLASS);
            AbstractUserStoreCountRetriever userStoreCountRetriever = UserStoreCountDataHolder.getInstance().getCountRetrieverFactories().get(retrieverType).buildCountRetriever(realmConfiguration);
            if (userStoreCountRetriever == null) {
                throw new UserStoreCounterException("Could not create an instance of class: " + retrieverType + " for the domain: " + domain);
            }
            return userStoreCountRetriever;
        }
        return null;
    }

    public static UserStoreCountRetriever getInternalCounterInstance() throws UserStoreCounterException {
        AbstractUserStoreCountRetriever countRetreiver;
        try {
            countRetreiver = UserStoreCountDataHolder.getInstance().getCountRetrieverFactories().get(InternalCountRetriever.class.getName()).buildCountRetriever(CarbonContext.getThreadLocalCarbonContext().getUserRealm().getRealmConfiguration());
            if (countRetreiver == null) {
                throw new UserStoreCounterException("Could not create a count retriever for Internal domain");
            }
        }
        catch (UserStoreException e) {
            throw new UserStoreCounterException("Could not create a count retriever for Internal domain");
        }
        return countRetreiver;
    }

    public static Map<String, String> convertArrayToMap(PairDTO[] pairDTOs) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (PairDTO pairDTO : pairDTOs) {
            map.put(pairDTO.getKey(), pairDTO.getValue());
        }
        return map;
    }

    public static PairDTO[] convertMapToArray(Map<String, String> claims) {
        PairDTO[] pairs = new PairDTO[claims.size()];
        Iterator<Map.Entry<String, String>> iterator = claims.entrySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            pairs[i] = new PairDTO(entry.getKey().toString(), entry.getValue().toString());
            ++i;
        }
        return pairs;
    }

    public static Long getInternalRoleCount(String filter) throws UserStoreCounterException {
        return UserStoreCountUtils.getInternalCounterInstance().countRoles("Internal%" + filter);
    }

    public static Long getApplicationRoleCount(String filter) throws UserStoreCounterException {
        return UserStoreCountUtils.getInternalCounterInstance().countRoles("Application%" + filter);
    }

    public static boolean isUserStoreEnabled(String domain) throws UserStoreCounterException {
        boolean isEnabled = false;
        try {
            RealmConfiguration realmConfiguration = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getRealmConfiguration();
            do {
                String userStoreDomain;
                if (!domain.equals(userStoreDomain = realmConfiguration.getUserStoreProperty("DomainName"))) continue;
                isEnabled = Boolean.valueOf(realmConfiguration.getUserStoreProperty("Disabled")) == false;
                break;
            } while ((realmConfiguration = realmConfiguration.getSecondaryRealmConfig()) != null);
        }
        catch (UserStoreException e) {
            throw new UserStoreCounterException("Error occurred while getting Secondary Realm Configuration", e);
        }
        return isEnabled;
    }
}

