/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.store.count.jdbc.internal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.user.store.count.AbstractUserStoreCountRetriever;
import org.wso2.carbon.identity.user.store.count.exception.UserStoreCounterException;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.util.DatabaseUtil;

public class InternalCountRetriever
extends AbstractUserStoreCountRetriever {
    private static final Log log = LogFactory.getLog(InternalCountRetriever.class);
    private RealmConfiguration realmConfiguration = null;
    private int tenantId = -1234;

    @Override
    public void init(RealmConfiguration realmConfiguration) {
        this.realmConfiguration = realmConfiguration;
        this.tenantId = realmConfiguration.getTenantId();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Long countRoles(String filter) throws UserStoreCounterException {
        Long l;
        ResultSet resultSet;
        PreparedStatement prepStmt;
        String sqlStmt;
        Connection dbConnection;
        block9: {
            dbConnection = null;
            sqlStmt = null;
            prepStmt = null;
            resultSet = null;
            dbConnection = this.getDBConnection(false);
            if (filter.startsWith("Internal")) {
                sqlStmt = "SELECT COUNT(UM_ID) AS RESULT FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME NOT LIKE 'Application%' AND UM_ROLE_NAME LIKE ? AND UM_TENANT_ID = ?";
                filter = filter.replace("Internal", "");
            } else {
                sqlStmt = "SELECT COUNT(UM_ID) AS RESULT FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME LIKE ? AND UM_TENANT_ID = ?";
            }
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, filter);
            prepStmt.setInt(2, this.tenantId);
            prepStmt.setQueryTimeout(this.searchTime);
            resultSet = prepStmt.executeQuery();
            if (!resultSet.next()) break block9;
            Long l2 = resultSet.getLong("RESULT");
            DatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)resultSet, (PreparedStatement[])new PreparedStatement[]{prepStmt});
            return l2;
        }
        try {
            log.error((Object)("No role count is retrieved for Internal domain filter:" + filter));
            l = -1L;
        }
        catch (SQLException e) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using sql : " + sqlStmt));
                }
                throw new UserStoreCounterException(e.getMessage(), e);
                catch (Exception e2) {
                    throw new UserStoreCounterException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections((Connection)dbConnection, resultSet, (PreparedStatement[])new PreparedStatement[]{prepStmt});
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)resultSet, (PreparedStatement[])new PreparedStatement[]{prepStmt});
        return l;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long countInternalRoles(String filter) throws UserStoreCounterException {
        Long l;
        ResultSet resultSet;
        PreparedStatement prepStmt;
        String sqlStmt;
        Connection dbConnection;
        block7: {
            dbConnection = null;
            sqlStmt = null;
            prepStmt = null;
            resultSet = null;
            dbConnection = this.getDBConnection(false);
            sqlStmt = "SELECT COUNT(UM_ID) AS RESULT FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME LIKE ? AND UM_TENANT_ID = ?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, filter);
            prepStmt.setInt(2, this.tenantId);
            prepStmt.setQueryTimeout(this.searchTime);
            resultSet = prepStmt.executeQuery();
            if (!resultSet.next()) break block7;
            Long l2 = resultSet.getLong("RESULT");
            DatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)resultSet, (PreparedStatement[])new PreparedStatement[]{prepStmt});
            return l2;
        }
        try {
            log.error((Object)("No role count is retrieved for Internal domain filter:" + filter));
            l = -1L;
        }
        catch (SQLException e) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using sql : " + sqlStmt));
                }
                throw new UserStoreCounterException(e.getMessage(), e);
                catch (Exception e2) {
                    throw new UserStoreCounterException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections((Connection)dbConnection, resultSet, (PreparedStatement[])new PreparedStatement[]{prepStmt});
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)resultSet, (PreparedStatement[])new PreparedStatement[]{prepStmt});
        return l;
    }

    private Connection getDBConnection(boolean shouldApplyTransaction) throws SQLException, UserStoreException {
        Connection dbConnection = IdentityDatabaseUtil.getUserDBConnection();
        if (dbConnection == null) {
            throw new UserStoreException("Could not create a database connection to User database");
        }
        if (shouldApplyTransaction) {
            dbConnection.setAutoCommit(false);
            if (dbConnection.getTransactionIsolation() != 2) {
                dbConnection.setTransactionIsolation(2);
            }
        }
        return dbConnection;
    }

    private void rollbackTransaction(Connection dbConnection) {
        try {
            if (dbConnection != null) {
                dbConnection.rollback();
            }
        }
        catch (SQLException e1) {
            log.error((Object)"An error occurred while rolling back transactions. ", (Throwable)e1);
        }
    }
}

