/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.store.count.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.user.store.count.AbstractUserStoreCountRetriever;
import org.wso2.carbon.identity.user.store.count.exception.UserStoreCounterException;
import org.wso2.carbon.identity.user.store.count.internal.UserStoreCountDSComponent;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.util.DatabaseUtil;

public class JDBCUserStoreCountRetriever
extends AbstractUserStoreCountRetriever {
    private static final Log log = LogFactory.getLog(JDBCUserStoreCountRetriever.class);
    private RealmConfiguration realmConfiguration = null;
    private int tenantId = -1234;

    @Override
    public void init(RealmConfiguration realmConfiguration) {
        this.realmConfiguration = realmConfiguration;
        this.tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Long countUsers(String filter) throws UserStoreCounterException {
        Long l;
        ResultSet resultSet;
        PreparedStatement prepStmt;
        String sqlStmt;
        Connection dbConnection;
        block7: {
            dbConnection = null;
            sqlStmt = null;
            prepStmt = null;
            resultSet = null;
            dbConnection = this.getDBConnection(this.realmConfiguration);
            sqlStmt = "SELECT COUNT(UM_USER_NAME) AS RESULT FROM UM_USER WHERE UM_USER_NAME LIKE ?  AND UM_TENANT_ID = ?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, "%" + filter + "%");
            prepStmt.setInt(2, this.tenantId);
            prepStmt.setQueryTimeout(this.searchTime);
            resultSet = prepStmt.executeQuery();
            dbConnection.commit();
            if (!resultSet.next()) break block7;
            Long l2 = resultSet.getLong("RESULT");
            DatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)resultSet, (PreparedStatement[])new PreparedStatement[]{prepStmt});
            return l2;
        }
        try {
            log.error((Object)"No user count is retrieved from the user store");
            l = -1L;
        }
        catch (SQLException e) {
            try {
                this.rollbackTransaction(dbConnection);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using sql : " + sqlStmt));
                }
                throw new UserStoreCounterException(e.getMessage(), e);
                catch (Exception e2) {
                    throw new UserStoreCounterException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections((Connection)dbConnection, resultSet, (PreparedStatement[])new PreparedStatement[]{prepStmt});
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)resultSet, (PreparedStatement[])new PreparedStatement[]{prepStmt});
        return l;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Long countRoles(String filter) throws UserStoreCounterException {
        Long l;
        ResultSet resultSet;
        PreparedStatement prepStmt;
        String sqlStmt;
        Connection dbConnection;
        block7: {
            dbConnection = null;
            sqlStmt = null;
            prepStmt = null;
            resultSet = null;
            dbConnection = this.getDBConnection(this.realmConfiguration);
            sqlStmt = "SELECT COUNT(UM_ROLE_NAME) AS RESULT FROM UM_ROLE WHERE UM_ROLE_NAME LIKE ? AND UM_TENANT_ID = ?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, "%" + filter + "%");
            prepStmt.setInt(2, this.tenantId);
            prepStmt.setQueryTimeout(this.searchTime);
            resultSet = prepStmt.executeQuery();
            dbConnection.commit();
            if (!resultSet.next()) break block7;
            Long l2 = resultSet.getLong("RESULT");
            DatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)resultSet, (PreparedStatement[])new PreparedStatement[]{prepStmt});
            return l2;
        }
        try {
            log.error((Object)"No role count is retrieved from the user store.");
            l = -1L;
        }
        catch (SQLException e) {
            try {
                this.rollbackTransaction(dbConnection);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using sql : " + sqlStmt));
                }
                throw new UserStoreCounterException(e.getMessage(), e);
                catch (Exception e2) {
                    throw new UserStoreCounterException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections((Connection)dbConnection, resultSet, (PreparedStatement[])new PreparedStatement[]{prepStmt});
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)resultSet, (PreparedStatement[])new PreparedStatement[]{prepStmt});
        return l;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Long countClaim(String claimURI, String valueFilter) throws UserStoreCounterException {
        Long l;
        ResultSet resultSet;
        PreparedStatement prepStmt;
        String sqlStmt;
        Connection dbConnection;
        block9: {
            dbConnection = null;
            sqlStmt = null;
            prepStmt = null;
            resultSet = null;
            String mappedAttribute = null;
            String domainName = this.realmConfiguration.getUserStoreProperty("DomainName");
            if (StringUtils.isEmpty((String)domainName)) {
                domainName = "PRIMARY";
            }
            UserRealm userRealm = UserStoreCountDSComponent.getRealmService().getTenantUserRealm(this.tenantId);
            if (StringUtils.isNotEmpty((String)claimURI)) {
                mappedAttribute = userRealm.getClaimManager().getAttributeName(domainName, claimURI);
            }
            dbConnection = this.getDBConnection(this.realmConfiguration);
            sqlStmt = "SELECT COUNT(UM_USER_ID) AS RESULT FROM UM_USER_ATTRIBUTE WHERE UM_ATTR_NAME = ? AND UM_TENANT_ID = ? AND UM_ATTR_VALUE LIKE ? AND UM_PROFILE_ID = ?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, mappedAttribute);
            prepStmt.setInt(2, this.tenantId);
            prepStmt.setString(3, "%" + valueFilter + "%");
            prepStmt.setString(4, "default");
            prepStmt.setQueryTimeout(this.searchTime);
            resultSet = prepStmt.executeQuery();
            dbConnection.commit();
            if (!resultSet.next()) break block9;
            Long l2 = resultSet.getLong("RESULT");
            DatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)resultSet, (PreparedStatement[])new PreparedStatement[]{prepStmt});
            return l2;
        }
        try {
            log.error((Object)"No claim count is retrieved from the user store.");
            l = -1L;
        }
        catch (SQLException e) {
            try {
                this.rollbackTransaction(dbConnection);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using sql : " + sqlStmt));
                }
                throw new UserStoreCounterException(e.getMessage(), e);
                catch (Exception e2) {
                    throw new UserStoreCounterException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, resultSet, (PreparedStatement[])new PreparedStatement[]{prepStmt});
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)resultSet, (PreparedStatement[])new PreparedStatement[]{prepStmt});
        return l;
    }

    private Connection getDBConnection(RealmConfiguration realmConfiguration) throws SQLException, UserStoreException {
        Connection dbConnection = null;
        DataSource dataSource = DatabaseUtil.createUserStoreDataSource((RealmConfiguration)realmConfiguration);
        if (dataSource != null) {
            dbConnection = DatabaseUtil.getDBConnection((DataSource)dataSource);
        }
        if (dbConnection == null && realmConfiguration.isPrimary()) {
            dbConnection = IdentityDatabaseUtil.getUserDBConnection();
        } else if (dbConnection == null) {
            throw new UserStoreException("Could not create a database connection to " + realmConfiguration.getUserStoreProperty("DomainName"));
        }
        dbConnection.setAutoCommit(false);
        if (dbConnection.getTransactionIsolation() != 2) {
            dbConnection.setTransactionIsolation(2);
        }
        return dbConnection;
    }

    private void rollbackTransaction(Connection dbConnection) {
        try {
            if (dbConnection != null) {
                dbConnection.rollback();
            }
        }
        catch (SQLException e1) {
            log.error((Object)"An error occurred while rolling back transactions. ", (Throwable)e1);
        }
    }
}

