/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.store.count.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.identity.user.store.count.AbstractCountRetrieverFactory;
import org.wso2.carbon.identity.user.store.count.exception.UserStoreCounterException;
import org.wso2.carbon.identity.user.store.count.internal.UserStoreCountDataHolder;
import org.wso2.carbon.identity.user.store.count.jdbc.JDBCCountRetrieverFactory;
import org.wso2.carbon.identity.user.store.count.jdbc.internal.InternalCountRetrieverFactory;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="identity.user.store.count.component", immediate=true)
public class UserStoreCountDSComponent {
    private static final Log log = LogFactory.getLog(UserStoreCountDSComponent.class);

    public static RealmService getRealmService() {
        return UserStoreCountDataHolder.getInstance().getRealmService();
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        UserStoreCountDataHolder.getInstance().setRealmService(realmService);
        if (log.isDebugEnabled()) {
            log.debug((Object)"RealmService is set in the User Store Count bundle");
        }
    }

    protected void unsetRealmService(RealmService realmService) {
        UserStoreCountDataHolder.getInstance().setRealmService(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"RealmService is unset in the Application Authentication Framework bundle");
        }
    }

    public static BundleContext getBundleContext() throws UserStoreCounterException {
        BundleContext bundleContext = UserStoreCountDataHolder.getInstance().getBundleContext();
        if (bundleContext == null) {
            String msg = "System has not been started properly. Bundle Context is null.";
            log.error((Object)msg);
            throw new UserStoreCounterException(msg);
        }
        return bundleContext;
    }

    protected void activate(ComponentContext ctxt) {
        BundleContext bundleContext = ctxt.getBundleContext();
        UserStoreCountDataHolder.getInstance().setBundleContext(bundleContext);
        JDBCCountRetrieverFactory jdbcCountRetrieverFactory = new JDBCCountRetrieverFactory();
        InternalCountRetrieverFactory internalCountRetrieverFactory = new InternalCountRetrieverFactory();
        ServiceRegistration serviceRegistration = bundleContext.registerService(AbstractCountRetrieverFactory.class.getName(), (Object)jdbcCountRetrieverFactory, null);
        bundleContext.registerService(AbstractCountRetrieverFactory.class.getName(), (Object)internalCountRetrieverFactory, null);
        if (serviceRegistration != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Identity User Store Count -  JDBCUserStoreCountRetriever registered.");
            }
        } else {
            log.error((Object)"Identity User Store Count -  JDBCUserStoreCountRetriever could not be registered.");
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User store count bundle is deactivated");
        }
        UserStoreCountDataHolder.getInstance().setBundleContext(null);
    }

    @Reference(name="user.store.count", service=AbstractCountRetrieverFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetCountRetrieverFactory")
    protected void setCountRetrieverFactory(AbstractCountRetrieverFactory countRetrieverFactory) {
        UserStoreCountDataHolder.getInstance().getCountRetrieverFactories().put(countRetrieverFactory.getCounterType(), countRetrieverFactory);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added count retriever : " + countRetrieverFactory.getCounterType()));
        }
    }

    protected void unsetCountRetrieverFactory(AbstractCountRetrieverFactory countRetrieverFactory) {
        UserStoreCountDataHolder.getInstance().getCountRetrieverFactories().remove(countRetrieverFactory.getCounterType());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removed count retriever : " + countRetrieverFactory.getCounterType()));
        }
    }

    @Reference(name="identityCoreInitializedEventService", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }
}

