/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.store.count;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.user.store.count.dto.PairDTO;
import org.wso2.carbon.identity.user.store.count.exception.UserStoreCounterException;
import org.wso2.carbon.identity.user.store.count.internal.UserStoreCountDSComponent;
import org.wso2.carbon.identity.user.store.count.util.UserStoreCountUtils;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.UserCoreConstants;

public class UserStoreCountService {
    private static final Log log = LogFactory.getLog(UserStoreCountService.class);
    int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();

    public PairDTO[] countUsers(String filter) throws UserStoreCounterException {
        Set<String> userStoreDomains = UserStoreCountUtils.getCountEnabledUserStores();
        PairDTO[] userCounts = new PairDTO[userStoreDomains.size()];
        int i = 0;
        for (String userStoreDomain : userStoreDomains) {
            String filterWithDomain = this.getFilterWithDomain(userStoreDomain, filter);
            long count = -1L;
            try {
                count = this.getUserCountWithClaims("http://wso2.org/claims/username", filterWithDomain);
                userCounts[i] = new PairDTO(userStoreDomain, Long.toString(count));
            }
            catch (UserStoreCounterException e) {
                userCounts[i] = new PairDTO(userStoreDomain, "Error while getting user count");
                log.error((Object)("Error while getting user count from user store domain : " + userStoreDomain), (Throwable)e);
            }
            ++i;
        }
        return userCounts;
    }

    public PairDTO[] countRoles(String filter) throws UserStoreCounterException {
        Set<String> userStoreDomains = UserStoreCountUtils.getCountEnabledUserStores();
        PairDTO[] roleCounts = new PairDTO[userStoreDomains.size() + 2];
        int i = 0;
        for (String userStoreDomain : userStoreDomains) {
            long count = -1L;
            String filterWithDomain = this.getFilterWithDomain(userStoreDomain, filter);
            try {
                count = this.getRoleCount(filterWithDomain);
                roleCounts[i] = new PairDTO(userStoreDomain, Long.toString(count));
            }
            catch (UserStoreCounterException e) {
                roleCounts[i] = new PairDTO(userStoreDomain, "Error while getting role count");
                log.error((Object)("Error while getting role count from user store domain : " + userStoreDomain), (Throwable)e);
            }
            ++i;
        }
        String internalDomainFilter = "Internal" + UserCoreConstants.DOMAIN_SEPARATOR + filter;
        String applicationDomainFilter = "Application" + UserCoreConstants.DOMAIN_SEPARATOR + filter;
        roleCounts[i] = new PairDTO("Internal", String.valueOf(this.getRoleCount(internalDomainFilter)));
        roleCounts[++i] = new PairDTO("Application", String.valueOf(this.getRoleCount(applicationDomainFilter)));
        return roleCounts;
    }

    public PairDTO[] countClaim(String claimURI, String valueFilter) throws UserStoreCounterException {
        Set<String> userStoreDomains = UserStoreCountUtils.getCountEnabledUserStores();
        PairDTO[] claimCounts = new PairDTO[userStoreDomains.size()];
        int i = 0;
        for (String userStoreDomain : userStoreDomains) {
            long count = -1L;
            String filterWithDomain = this.getFilterWithDomain(userStoreDomain, valueFilter);
            try {
                count = this.getUserCountWithClaims(claimURI, filterWithDomain);
            }
            catch (UserStoreCounterException e) {
                log.error((Object)("Error while getting user count with claim : " + claimURI + ", from user store domain : " + userStoreDomain), (Throwable)e);
            }
            claimCounts[i] = new PairDTO(userStoreDomain, Long.toString(count));
            ++i;
        }
        return claimCounts;
    }

    public long countUsersInDomain(String filter, String domain) throws UserStoreCounterException {
        String filterWithDomain = this.getFilterWithDomain(domain, filter);
        return this.getUserCountWithClaims("http://wso2.org/claims/username", filterWithDomain);
    }

    public long countRolesInDomain(String filter, String domain) throws UserStoreCounterException {
        String filterWithDomain = this.getFilterWithDomain(domain, filter);
        return this.getRoleCount(filterWithDomain);
    }

    public long countByClaimInDomain(String claimURI, String valueFilter, String domain) throws UserStoreCounterException {
        String filterWithDomain = this.getFilterWithDomain(domain, valueFilter);
        return this.getUserCountWithClaims(claimURI, filterWithDomain);
    }

    public String[] getCountEnabledUserStores() throws UserStoreCounterException {
        Set<String> domains = UserStoreCountUtils.getCountEnabledUserStores();
        return domains.toArray(new String[domains.size()]);
    }

    private long getUserCountWithClaims(String claimURI, String valueFilter) throws UserStoreCounterException {
        try {
            UserStoreManager userStoreManager = this.getUserStoreManager();
            if (!(userStoreManager instanceof org.wso2.carbon.user.core.UserStoreManager)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Cannot get user count. Provided user store manager : " + userStoreManager.getClass() + ", is not not an instance of : " + org.wso2.carbon.user.core.UserStoreManager.class));
                }
                throw new UserStoreCounterException("Unsupported user store manager to retrieve user count");
            }
            return ((org.wso2.carbon.user.core.UserStoreManager)userStoreManager).getUserCountWithClaims(claimURI, valueFilter);
        }
        catch (UserStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error while retrieving user count with tenant Id : " + this.tenantId + ", and the filter : " + valueFilter));
            }
            String errorMsg = "Error occurred while retrieving user count";
            throw new UserStoreCounterException(errorMsg, e);
        }
    }

    private long getRoleCount(String filter) throws UserStoreCounterException {
        try {
            UserStoreManager userStoreManager = this.getUserStoreManager();
            if (!(userStoreManager instanceof org.wso2.carbon.user.core.UserStoreManager)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Cannot get role count. Provided user store manager : " + userStoreManager.getClass() + ", is not not an instance of : " + org.wso2.carbon.user.core.UserStoreManager.class));
                }
                throw new UserStoreCounterException("Unsupported user store manager to retrieve role count");
            }
            return ((org.wso2.carbon.user.core.UserStoreManager)userStoreManager).countRoles(filter);
        }
        catch (UserStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error while retrieving role count with tenent Id " + this.tenantId + ", and the filter " + filter));
            }
            String errorMsg = "Error occurred while retrieving role count";
            throw new UserStoreCounterException(errorMsg, e);
        }
    }

    private String getFilterWithDomain(String domain, String filter) {
        return domain + UserCoreConstants.DOMAIN_SEPARATOR + filter;
    }

    private UserStoreManager getUserStoreManager() throws UserStoreCounterException {
        if (UserStoreCountDSComponent.getRealmService() == null) {
            String errorMsg = "Unable to retrieve realm service";
            throw new UserStoreCounterException(errorMsg);
        }
        try {
            return UserStoreCountDSComponent.getRealmService().getTenantUserRealm(this.tenantId).getUserStoreManager();
        }
        catch (UserStoreException e) {
            throw new UserStoreCounterException("Error while retrieving userStoreManager");
        }
    }
}

