/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.event.handler.notification.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.email.mgt.exceptions.I18nEmailMgtException;
import org.wso2.carbon.email.mgt.model.EmailTemplate;
import org.wso2.carbon.event.publisher.core.EventPublisherService;
import org.wso2.carbon.event.publisher.core.config.EventPublisherConfiguration;
import org.wso2.carbon.event.publisher.core.exception.EventPublisherConfigurationException;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.event.stream.core.exception.EventStreamConfigurationException;
import org.wso2.carbon.identity.core.ServiceURLBuilder;
import org.wso2.carbon.identity.core.URLBuilderException;
import org.wso2.carbon.identity.core.util.IdentityConfigParser;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.notification.email.bean.Notification;
import org.wso2.carbon.identity.event.handler.notification.exception.NotificationRuntimeException;
import org.wso2.carbon.identity.event.handler.notification.internal.NotificationHandlerDataHolder;
import org.wso2.carbon.identity.governance.model.UserIdentityClaim;
import org.wso2.carbon.user.api.Claim;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;

public class NotificationUtil {
    private static final Log log = LogFactory.getLog(NotificationUtil.class);
    private static final String USER_IDENTITY_CLAIMS = "UserIdentityClaims";

    public static Map<String, String> getUserClaimValues(String userName, UserStoreManager userStoreManager) {
        HashMap<String, String> claimsMap = new HashMap<String, String>();
        try {
            UserIdentityClaim userIdentityClaims;
            Claim[] userClaims = userStoreManager.getUserClaimValues(userName, "default");
            if (userClaims != null) {
                for (Claim userClaim : userClaims) {
                    claimsMap.put(userClaim.getClaimUri(), userClaim.getValue());
                }
            }
            HashMap userIdentityDataMap = (userIdentityClaims = (UserIdentityClaim)((Map)IdentityUtil.threadLocalProperties.get()).get(USER_IDENTITY_CLAIMS)) == null ? new HashMap() : userIdentityClaims.getUserIdentityDataMap();
            for (String key : userIdentityDataMap.keySet()) {
                if (claimsMap.containsKey(key)) continue;
                claimsMap.put(key, (String)userIdentityDataMap.get(key));
            }
        }
        catch (UserStoreException e) {
            String domainNameProperty = NotificationUtil.getUserStoreDomainName(userStoreManager);
            String message = null;
            message = StringUtils.isNotBlank((String)domainNameProperty) ? "Error occurred while retrieving user claim values for user " + userName + " in user store " + domainNameProperty + " in tenant " + NotificationUtil.getTenantDomain(userStoreManager) : "Error occurred while retrieving user claim values for user " + userName + " in tenant " + NotificationUtil.getTenantDomain(userStoreManager);
            log.error((Object)message, (Throwable)e);
        }
        return claimsMap;
    }

    public static Map<String, String> getUserClaimValues(String userName, String domainName, String tenantDomain) throws IdentityEventException {
        RealmService realmService = NotificationHandlerDataHolder.getInstance().getRealmService();
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        UserStoreManager userStoreManager = null;
        try {
            userStoreManager = realmService.getTenantUserRealm(tenantId).getUserStoreManager();
            if (userStoreManager == null) {
                String message = "Error occurred while retrieving userStoreManager for tenant " + tenantDomain;
                throw new IdentityEventException(message);
            }
            if (userStoreManager instanceof AbstractUserStoreManager) {
                userStoreManager = ((AbstractUserStoreManager)userStoreManager).getSecondaryUserStoreManager(domainName);
            }
        }
        catch (UserStoreException e) {
            String message = "Error occurred while retrieving user claim values for user " + userName + " in user store " + domainName + " in tenant " + tenantDomain;
            throw new IdentityEventException(message, (Throwable)e);
        }
        return NotificationUtil.getUserClaimValues(userName, userStoreManager);
    }

    public static Map<String, String> getPlaceholderValues(EmailTemplate emailTemplate, Map<String, String> placeHolderData, Map<String, String> userClaims) {
        String serverURL;
        Map<String, String> configFilePlaceholders = NotificationUtil.getConfigFilePlaceholders();
        ArrayList<String> placeHolders = new ArrayList<String>(NotificationUtil.extractPlaceHolders(emailTemplate.getBody()));
        if (StringUtils.isNotEmpty((String)emailTemplate.getSubject())) {
            placeHolders.addAll(NotificationUtil.extractPlaceHolders(emailTemplate.getSubject()));
        }
        if (StringUtils.isNotEmpty((String)emailTemplate.getFooter())) {
            placeHolders.addAll(NotificationUtil.extractPlaceHolders(emailTemplate.getFooter()));
        }
        if (userClaims != null && !userClaims.isEmpty()) {
            for (String placeHolder : placeHolders) {
                if (placeHolder.contains("user.claim.identity")) {
                    String identityClaim = userClaims.get("http://wso2.org/claims/identity/" + placeHolder.substring(placeHolder.indexOf(".", placeHolder.indexOf("identity")) + 1));
                    if (!StringUtils.isNotEmpty((String)identityClaim)) continue;
                    placeHolderData.put(placeHolder, identityClaim);
                    continue;
                }
                if (placeHolder.contains("user.claim")) {
                    String userClaim = userClaims.get("http://wso2.org/claims/" + placeHolder.substring(placeHolder.indexOf(".", placeHolder.indexOf("claim")) + 1));
                    if (!StringUtils.isNotEmpty((String)userClaim)) continue;
                    placeHolderData.put(placeHolder, userClaim);
                    continue;
                }
                if (!placeHolder.startsWith("server.placeholder")) continue;
                String key = placeHolder.substring(placeHolder.lastIndexOf(".") + 1);
                String value = configFilePlaceholders.getOrDefault(key, "");
                placeHolderData.put(placeHolder, value);
            }
        }
        try {
            serverURL = ServiceURLBuilder.create().build().getAbsolutePublicURL();
        }
        catch (URLBuilderException e) {
            throw NotificationRuntimeException.error("Error while building the server url.", e);
        }
        placeHolderData.put("carbon.product-url", serverURL);
        return placeHolderData;
    }

    public static Map<String, String> getConfigFilePlaceholders() {
        IdentityConfigParser configParser = IdentityConfigParser.getInstance();
        OMElement placeHolderElem = configParser.getConfigElement("EmailTemplatePlaceholders");
        if (placeHolderElem == null) {
            return Collections.emptyMap();
        }
        Iterator iterator = placeHolderElem.getChildrenWithLocalName("EmailTemplatePlaceholder");
        if (iterator == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> placeholderMap = new HashMap<String, String>();
        while (iterator.hasNext()) {
            OMElement omElement = (OMElement)iterator.next();
            if (omElement == null) continue;
            String key = omElement.getAttributeValue(new QName("key"));
            String value = omElement.getText();
            placeholderMap.put(key, value);
        }
        return placeholderMap;
    }

    public static List<String> extractPlaceHolders(String value) {
        String exp = "\\{\\{(.*?)\\}\\}";
        Pattern pattern = Pattern.compile(exp);
        Matcher matcher = pattern.matcher(value);
        ArrayList<String> placeHolders = new ArrayList<String>();
        while (matcher.find()) {
            String group = matcher.group().replace("{{", "").replace("}}", "");
            placeHolders.add(group);
        }
        return placeHolders;
    }

    public static String getUserStoreDomainName(UserStoreManager userStoreManager) {
        String domainNameProperty = null;
        if (userStoreManager instanceof org.wso2.carbon.user.core.UserStoreManager && StringUtils.isBlank((String)(domainNameProperty = ((org.wso2.carbon.user.core.UserStoreManager)userStoreManager).getRealmConfiguration().getUserStoreProperty("DomainName")))) {
            domainNameProperty = IdentityUtil.getPrimaryDomainName();
        }
        return domainNameProperty;
    }

    public static String getTenantDomain(UserStoreManager userStoreManager) {
        try {
            return IdentityTenantUtil.getTenantDomain((int)userStoreManager.getTenantId());
        }
        catch (UserStoreException e) {
            throw NotificationRuntimeException.error("Error when getting the tenant domain.", e);
        }
    }

    public static void deployStream(String streamName, String streamVersion, String streamId) throws NotificationRuntimeException {
        try {
            EventStreamService service = NotificationHandlerDataHolder.getInstance().getEventStreamService();
            StreamDefinition streamDefinition = new StreamDefinition(streamName, streamVersion, streamId);
            service.addEventStreamDefinition(streamDefinition);
        }
        catch (MalformedStreamDefinitionException e) {
            throw NotificationRuntimeException.error("Error occurred due to a malformed stream definition.", e);
        }
        catch (EventStreamConfigurationException e) {
            throw NotificationRuntimeException.error("Error in deploying a stream.", e);
        }
    }

    public static void deployPublisher(EventPublisherConfiguration eventPublisherConfiguration) throws NotificationRuntimeException {
        EventPublisherService eventPublisherService = NotificationHandlerDataHolder.getInstance().getEventPublisherService();
        try {
            eventPublisherService.deployEventPublisherConfiguration(eventPublisherConfiguration);
        }
        catch (EventPublisherConfigurationException e) {
            throw NotificationRuntimeException.error("Error in deploying a publisher.", e);
        }
    }

    public static Notification buildNotification(Event event, Map<String, String> placeHolderData) throws IdentityEventException, NotificationRuntimeException {
        EmailTemplate emailTemplate;
        String sendTo = placeHolderData.get("send-to");
        Map<Object, Object> userClaims = new HashMap();
        String notificationEvent = (String)event.getEventProperties().get("TEMPLATE_TYPE");
        String username = (String)event.getEventProperties().get("user-name");
        org.wso2.carbon.user.core.UserStoreManager userStoreManager = (org.wso2.carbon.user.core.UserStoreManager)event.getEventProperties().get("userStoreManager");
        String userStoreDomainName = (String)event.getEventProperties().get("userstore-domain");
        String tenantDomain = (String)event.getEventProperties().get("tenant-domain");
        String sendFrom = (String)event.getEventProperties().get("send-from");
        if (StringUtils.isNotBlank((String)username) && userStoreManager != null) {
            userClaims = NotificationUtil.getUserClaimValues(username, (UserStoreManager)userStoreManager);
        } else if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)userStoreDomainName) && StringUtils.isNotBlank((String)tenantDomain)) {
            userClaims = NotificationUtil.getUserClaimValues(username, userStoreDomainName, tenantDomain);
        }
        String locale = "en_US";
        if (userClaims.containsKey("http://wso2.org/claims/locality")) {
            locale = (String)userClaims.get("http://wso2.org/claims/locality");
        }
        if (StringUtils.isEmpty((String)sendTo)) {
            if (userClaims.containsKey("http://wso2.org/claims/emailaddress")) {
                sendTo = (String)userClaims.get("http://wso2.org/claims/emailaddress");
            }
            if (StringUtils.isEmpty((String)sendTo)) {
                throw NotificationRuntimeException.error("Email notification sending failed. Sending email address is not configured for the user.");
            }
        }
        try {
            emailTemplate = NotificationHandlerDataHolder.getInstance().getEmailTemplateManager().getEmailTemplate(notificationEvent, locale, tenantDomain);
        }
        catch (I18nEmailMgtException e) {
            String message = "Error when retrieving template from tenant registry.";
            throw NotificationRuntimeException.error(message, e);
        }
        NotificationUtil.getPlaceholderValues(emailTemplate, placeHolderData, userClaims);
        Notification.EmailNotificationBuilder builder = new Notification.EmailNotificationBuilder(sendTo);
        builder.setSendFrom(sendFrom);
        builder.setTemplate(emailTemplate);
        builder.setPlaceHolderData(placeHolderData);
        Notification emailNotification = builder.build();
        return emailNotification;
    }
}

