/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.event.handler.notification.listener;

import java.util.HashMap;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.publisher.core.config.EventPublisherConfiguration;
import org.wso2.carbon.event.publisher.core.config.OutputMapping;
import org.wso2.carbon.event.publisher.core.config.mapping.TextOutputMapping;
import org.wso2.carbon.identity.event.handler.notification.internal.NotificationHandlerDataHolder;
import org.wso2.carbon.stratos.common.beans.TenantInfoBean;
import org.wso2.carbon.stratos.common.exception.StratosException;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;
import org.wso2.carbon.user.api.UserStoreException;

public class NotificationEventTenantListener
implements TenantMgtListener {
    public void onTenantCreate(TenantInfoBean tenantInfoBean) throws StratosException {
    }

    public void onTenantUpdate(TenantInfoBean tenantInfoBean) throws StratosException {
    }

    public void onTenantDelete(int i) {
    }

    public void onTenantRename(int i, String s, String s2) throws StratosException {
    }

    public void onTenantInitialActivation(int i) throws StratosException {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(i);
            carbonContext.setTenantDomain(NotificationHandlerDataHolder.getInstance().getRealmService().getTenantManager().getDomain(i));
        }
        catch (UserStoreException e) {
            throw new StratosException("Error in starting a tenant flow.", (Throwable)e);
        }
        PrivilegedCarbonContext.endTenantFlow();
    }

    public void onTenantActivation(int i) throws StratosException {
    }

    public void onTenantDeactivation(int i) throws StratosException {
    }

    public void onSubscriptionPlanChange(int i, String s, String s2) throws StratosException {
    }

    public int getListenerOrder() {
        return 0;
    }

    public void onPreDelete(int i) throws StratosException {
    }

    private EventPublisherConfiguration getEventPublisherConfig() {
        EventPublisherConfiguration eventPublisherConfiguration = new EventPublisherConfiguration();
        eventPublisherConfiguration.setEventPublisherName("EmailPublisher");
        eventPublisherConfiguration.setFromStreamName("id_gov_notify_stream");
        eventPublisherConfiguration.setFromStreamVersion("1.0.0");
        eventPublisherConfiguration.setProcessEnabled(true);
        OutputEventAdapterConfiguration outputEventAdapterConfiguration = new OutputEventAdapterConfiguration();
        outputEventAdapterConfiguration.setName("Email Publisher");
        outputEventAdapterConfiguration.setMessageFormat("text");
        outputEventAdapterConfiguration.setType("email");
        eventPublisherConfiguration.setToAdapterConfiguration(outputEventAdapterConfiguration);
        TextOutputMapping textOutputMapping = new TextOutputMapping();
        textOutputMapping.setCustomMappingEnabled(true);
        textOutputMapping.setRegistryResource(false);
        textOutputMapping.setMappingText("{{body}}{{footer}}");
        textOutputMapping.setCacheTimeoutDuration(0L);
        eventPublisherConfiguration.setOutputMapping((OutputMapping)textOutputMapping);
        HashMap<String, String> adapterDynamicProperties = new HashMap<String, String>();
        adapterDynamicProperties.put("email.address", "{{send-to}}");
        adapterDynamicProperties.put("email.type", "{{content-type}}");
        adapterDynamicProperties.put("email.subject", "{{subject}}");
        eventPublisherConfiguration.setToAdapterDynamicProperties(adapterDynamicProperties);
        return eventPublisherConfiguration;
    }
}

