/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.event.handler.notification.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.email.mgt.EmailTemplateManager;
import org.wso2.carbon.event.publisher.core.EventPublisherService;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.event.handler.notification.DefaultNotificationHandler;
import org.wso2.carbon.identity.event.handler.notification.NotificationHandler;
import org.wso2.carbon.identity.event.handler.notification.internal.NotificationHandlerDataHolder;
import org.wso2.carbon.identity.event.handler.notification.listener.NotificationEventTenantListener;
import org.wso2.carbon.identity.governance.service.notification.NotificationTemplateManager;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="identity.event.handler.notification", immediate=true)
public class NotificationHandlerServiceComponent {
    private static final Log log = LogFactory.getLog(NotificationHandlerServiceComponent.class);

    @Activate
    protected void activate(ComponentContext context) {
        try {
            context.getBundleContext().registerService(AbstractEventHandler.class.getName(), (Object)new NotificationHandler(), null);
            context.getBundleContext().registerService(AbstractEventHandler.class.getName(), (Object)new DefaultNotificationHandler(), null);
            context.getBundleContext().registerService(TenantMgtListener.class.getName(), (Object)new NotificationEventTenantListener(), null);
        }
        catch (Throwable e) {
            log.error((Object)"Error occurred while activating Notification Handler Service Component", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Notification Handler bundle is activated");
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Notification Handler bundle is de-activated");
        }
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Registry Service");
        }
        NotificationHandlerDataHolder.getInstance().setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UnSetting the Registry Service");
        }
        NotificationHandlerDataHolder.getInstance().setRegistryService(null);
    }

    @Reference(name="realm.service", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Realm Service");
        }
        NotificationHandlerDataHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UnSetting the Realm Service");
        }
        NotificationHandlerDataHolder.getInstance().setRealmService(null);
    }

    @Reference(name="eventStreamManager.service", service=EventStreamService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetEventStreamService")
    protected void setEventStreamService(EventStreamService eventStreamService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Event Stream Service");
        }
        NotificationHandlerDataHolder.getInstance().setEventStreamService(eventStreamService);
    }

    protected void unsetEventStreamService(EventStreamService eventStreamService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UnSetting the Event Stream Service");
        }
        NotificationHandlerDataHolder.getInstance().setEventStreamService(null);
    }

    @Reference(name="eventPublisherService.service", service=EventPublisherService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetEventPublisherService")
    protected void setEventPublisherService(EventPublisherService eventPublisherService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Event Publisher Service");
        }
        NotificationHandlerDataHolder.getInstance().setEventPublisherService(eventPublisherService);
    }

    protected void unsetEventPublisherService(EventPublisherService eventPublisherService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UnSetting the Event Publisher Service");
        }
        NotificationHandlerDataHolder.getInstance().setEventPublisherService(null);
    }

    @Reference(name="emailTemplateManager.service", service=EmailTemplateManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetEmailTemplateManager")
    protected void setEmailTemplateManager(EmailTemplateManager emailTemplateManager) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Email Template Manager");
        }
        NotificationHandlerDataHolder.getInstance().setEmailTemplateManager(emailTemplateManager);
    }

    protected void unsetEmailTemplateManager(EmailTemplateManager emailTemplateManager) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UnSetting the Email Template Manager");
        }
        NotificationHandlerDataHolder.getInstance().setEmailTemplateManager(null);
    }

    @Reference(name="notificationTemplateManager.service", service=NotificationTemplateManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetNotificationTemplateManager")
    protected void setNotificationTemplateManager(NotificationTemplateManager notificationTemplateManager) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Notification Template Manager");
        }
        NotificationHandlerDataHolder.getInstance().setNotificationTemplateManager(notificationTemplateManager);
    }

    protected void unsetNotificationTemplateManager(NotificationTemplateManager notificationTemplateManager) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"UnSetting the Notification Email Template Manager");
        }
        NotificationHandlerDataHolder.getInstance().setNotificationTemplateManager(null);
    }
}

