/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.event.handler.notification.email.bean;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.email.mgt.model.EmailTemplate;
import org.wso2.carbon.identity.event.handler.notification.exception.NotificationRuntimeException;

public class Notification
implements Serializable {
    private String sendTo;
    private String sendFrom;
    private EmailTemplate template;
    private String subject;
    private String body;
    private String footer;
    private Map<String, String> placeHolderData;

    protected Notification(EmailNotificationBuilder builder) {
        this.sendTo = builder.sendTo;
        this.sendFrom = builder.sendFrom;
        this.template = builder.template;
        this.placeHolderData = builder.placeHolderData;
        this.body = Notification.replaceTags(this.template.getBody(), this.placeHolderData);
        if (StringUtils.isNotEmpty((String)this.template.getSubject())) {
            this.subject = Notification.replaceTags(this.template.getSubject(), this.placeHolderData);
        }
        if (StringUtils.isNotEmpty((String)this.template.getFooter())) {
            this.footer = Notification.replaceTags(this.template.getFooter(), this.placeHolderData);
        }
    }

    private static String replaceTags(String content, Map<String, String> tagsData) {
        for (Map.Entry<String, String> entry : tagsData.entrySet()) {
            try {
                content = content.replaceAll("\\{\\{url:" + entry.getKey() + "\\}\\}", URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw NotificationRuntimeException.error(e.getMessage(), e);
            }
            content = content.replaceAll("\\{\\{" + entry.getKey() + "\\}\\}", Matcher.quoteReplacement(entry.getValue()));
        }
        return content;
    }

    public String getSendTo() {
        return this.sendTo;
    }

    public String getSendFrom() {
        return this.sendFrom;
    }

    public EmailTemplate getTemplate() {
        return this.template;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    public String getFooter() {
        return this.footer;
    }

    public static class EmailNotificationBuilder {
        private String sendTo;
        private String sendFrom;
        private EmailTemplate template;
        private Map<String, String> placeHolderData;

        public EmailNotificationBuilder(String sendTo) {
            this.sendTo = sendTo;
        }

        public void setTemplate(EmailTemplate template) {
            this.template = template;
        }

        public void setSendFrom(String sendFrom) {
            this.sendFrom = sendFrom;
        }

        public void setPlaceHolderData(Map<String, String> placeHolderData) {
            this.placeHolderData = placeHolderData;
        }

        public void addPlaceHolderData(String key, String value) {
            this.placeHolderData.put(key, value);
        }

        public Notification build() {
            return new Notification(this);
        }
    }
}

