/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.event.handler.notification;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.email.mgt.util.I18nEmailUtil;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.notification.DefaultNotificationHandler;
import org.wso2.carbon.identity.event.handler.notification.email.bean.Notification;
import org.wso2.carbon.identity.event.handler.notification.internal.NotificationHandlerDataHolder;
import org.wso2.carbon.identity.event.handler.notification.util.NotificationUtil;

public class NotificationHandler
extends DefaultNotificationHandler {
    private static final Log log = LogFactory.getLog(NotificationHandler.class);
    private static final String STREAM_ID = "id_gov_notify_stream:1.0.0";

    @Override
    public void handleEvent(Event event) throws IdentityEventException {
        String notificationTemplate = this.getNotificationTemplate(event);
        if (StringUtils.isNotEmpty((String)notificationTemplate)) {
            event.getEventProperties().put("TEMPLATE_TYPE", notificationTemplate);
        }
        HashMap<String, String> arbitraryDataMap = new HashMap<String, String>();
        for (Map.Entry entry : event.getEventProperties().entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            arbitraryDataMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        Notification notification = NotificationUtil.buildNotification(event, arbitraryDataMap);
        String streamDefinitionID = this.getStreamDefinitionID(event);
        arbitraryDataMap.put("tmp-stream-id", streamDefinitionID);
        this.publishToStream(notification, arbitraryDataMap);
    }

    protected void publishToStream(Notification notification, Map<String, String> placeHolderDataMap) {
        EventStreamService service = NotificationHandlerDataHolder.getInstance().getEventStreamService();
        org.wso2.carbon.databridge.commons.Event databridgeEvent = new org.wso2.carbon.databridge.commons.Event();
        databridgeEvent.setTimeStamp(System.currentTimeMillis());
        HashMap<String, String> arbitraryDataMap = new HashMap<String, String>();
        databridgeEvent.setStreamId(placeHolderDataMap.remove("tmp-stream-id"));
        arbitraryDataMap.put("notification-event", I18nEmailUtil.getNormalizedName((String)notification.getTemplate().getTemplateDisplayName()));
        arbitraryDataMap.put("user-name", placeHolderDataMap.get("user-name"));
        arbitraryDataMap.put("userstore-domain", placeHolderDataMap.get("userstore-domain"));
        arbitraryDataMap.put("tenant-domain", placeHolderDataMap.get("tenant-domain"));
        arbitraryDataMap.put("send-from", notification.getSendFrom());
        for (Map.Entry<String, String> placeHolderDataEntry : placeHolderDataMap.entrySet()) {
            arbitraryDataMap.put(placeHolderDataEntry.getKey(), placeHolderDataEntry.getValue());
        }
        arbitraryDataMap.put("subject-template", notification.getTemplate().getSubject());
        arbitraryDataMap.put("body-template", notification.getTemplate().getBody());
        arbitraryDataMap.put("footer-template", notification.getTemplate().getFooter());
        arbitraryDataMap.put("locale", notification.getTemplate().getLocale());
        arbitraryDataMap.put("content-type", notification.getTemplate().getEmailContentType());
        arbitraryDataMap.put("send-to", notification.getSendTo());
        arbitraryDataMap.put("subject", notification.getSubject());
        arbitraryDataMap.put("body", notification.getBody());
        arbitraryDataMap.put("footer", notification.getFooter());
        databridgeEvent.setArbitraryDataMap(arbitraryDataMap);
        service.publish(databridgeEvent);
    }

    @Override
    public String getStreamDefinitionID(Event event) throws IdentityEventException {
        String streamDefinitionID = super.getStreamDefinitionID(event);
        if (StringUtils.isEmpty((String)streamDefinitionID)) {
            streamDefinitionID = STREAM_ID;
        }
        return streamDefinitionID;
    }

    @Override
    public String getName() {
        return "emailSend";
    }
}

