/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.event.handler.notification;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.email.mgt.model.EmailTemplate;
import org.wso2.carbon.email.mgt.util.I18nEmailUtil;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.identity.event.handler.notification.email.bean.Notification;
import org.wso2.carbon.identity.event.handler.notification.exception.NotificationRuntimeException;
import org.wso2.carbon.identity.event.handler.notification.internal.NotificationHandlerDataHolder;
import org.wso2.carbon.identity.event.handler.notification.util.NotificationUtil;
import org.wso2.carbon.identity.governance.IdentityGovernanceUtil;
import org.wso2.carbon.identity.governance.exceptions.notiification.NotificationTemplateManagerException;
import org.wso2.carbon.identity.governance.model.NotificationTemplate;
import org.wso2.carbon.identity.governance.service.notification.NotificationChannels;
import org.wso2.carbon.user.api.UserStoreManager;

public class DefaultNotificationHandler
extends AbstractEventHandler {
    private static final Log log = LogFactory.getLog(DefaultNotificationHandler.class);
    private static final String STREAM_DEFINITION_ID = "stream";
    private static final String NOTIFICATION_TEMPLATE_TYPE = "notification_template";
    private static final String DEFAULT_STREAM_ID = "id_gov_notify_stream:1.0.0";

    public void handleEvent(Event event) throws IdentityEventException {
        Map<String, String> arbitraryDataMap = this.buildNotificationData(event);
        this.publishToStream(arbitraryDataMap, event);
    }

    private String resolveNotificationChannel(String notificationChannel) {
        if (NotificationChannels.EMAIL_CHANNEL.getChannelType().equals(notificationChannel) || NotificationChannels.SMS_CHANNEL.getChannelType().equals(notificationChannel)) {
            return notificationChannel;
        }
        if (log.isDebugEnabled()) {
            String message = String.format("Notification channel : %s is not supported by the server. Notification channel changed to : %s", notificationChannel, IdentityGovernanceUtil.getDefaultNotificationChannel());
            log.debug((Object)message);
        }
        return IdentityGovernanceUtil.getDefaultNotificationChannel();
    }

    protected Map<String, String> buildNotificationData(Event event) throws IdentityEventException {
        HashMap<String, String> arbitraryDataMap = new HashMap<String, String>();
        for (Map.Entry entry : event.getEventProperties().entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            arbitraryDataMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        String sendTo = (String)arbitraryDataMap.get("send-to");
        Map<Object, Object> userClaims = new HashMap();
        String notificationTemplateName = this.getNotificationTemplate(event);
        if (StringUtils.isEmpty((String)notificationTemplateName)) {
            notificationTemplateName = (String)event.getEventProperties().get("TEMPLATE_TYPE");
        }
        if (StringUtils.isNotEmpty((String)notificationTemplateName)) {
            NotificationTemplate notificationTemplate;
            String username = (String)event.getEventProperties().get("user-name");
            org.wso2.carbon.user.core.UserStoreManager userStoreManager = (org.wso2.carbon.user.core.UserStoreManager)event.getEventProperties().get("userStoreManager");
            String userStoreDomainName = (String)event.getEventProperties().get("userstore-domain");
            String tenantDomain = (String)event.getEventProperties().get("tenant-domain");
            String sendFrom = (String)event.getEventProperties().get("send-from");
            String notificationChannel = this.resolveNotificationChannel((String)event.getEventProperties().get("notification-channel"));
            if (StringUtils.isNotBlank((String)username) && userStoreManager != null) {
                userClaims = NotificationUtil.getUserClaimValues(username, (UserStoreManager)userStoreManager);
            } else if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)userStoreDomainName) && StringUtils.isNotBlank((String)tenantDomain)) {
                userClaims = NotificationUtil.getUserClaimValues(username, userStoreDomainName, tenantDomain);
            }
            String locale = "en_US";
            if (NotificationChannels.SMS_CHANNEL.getChannelType().equals(notificationChannel) && userClaims.containsKey("en_US")) {
                locale = (String)userClaims.get("en_US");
            } else if (userClaims.containsKey("http://wso2.org/claims/locality")) {
                locale = (String)userClaims.get("http://wso2.org/claims/locality");
            }
            if (StringUtils.isEmpty((String)sendTo) && userClaims.containsKey("http://wso2.org/claims/emailaddress")) {
                sendTo = (String)userClaims.get("http://wso2.org/claims/emailaddress");
            }
            try {
                notificationTemplate = NotificationHandlerDataHolder.getInstance().getNotificationTemplateManager().getNotificationTemplate(notificationChannel, notificationTemplateName, locale, tenantDomain);
            }
            catch (NotificationTemplateManagerException exception) {
                String message = "Error when retrieving template from tenant registry.";
                throw NotificationRuntimeException.error(message, exception);
            }
            this.addNotificationTemplateDataToArbitraryDataMap(notificationTemplate, notificationTemplateName, sendTo, sendFrom, arbitraryDataMap, userClaims);
        }
        Map<String, String> arbitraryDataClaims = this.getArbitraryDataClaimsFromProperties(event);
        Set<String> keys = arbitraryDataClaims.keySet();
        for (String key : keys) {
            String claim = arbitraryDataClaims.get(key);
            String value = (String)userClaims.get(claim);
            arbitraryDataMap.put(key, value);
        }
        Map<String, String> arbitraryDataFromProperties = this.getArbitraryDataFromProperties(event);
        arbitraryDataMap.putAll(arbitraryDataFromProperties);
        return arbitraryDataMap;
    }

    private void addNotificationTemplateDataToArbitraryDataMap(NotificationTemplate notificationTemplate, String notificationTemplateName, String sendTo, String sendFrom, Map<String, String> arbitraryDataMap, Map<String, String> userClaims) {
        EmailTemplate emailTemplate = this.buildEmailTemplate(notificationTemplate);
        Notification notification = this.buildEmailNotification(emailTemplate, arbitraryDataMap, userClaims, sendTo, sendFrom);
        arbitraryDataMap.put("notification-event", I18nEmailUtil.getNormalizedName((String)notificationTemplateName));
        arbitraryDataMap.put("send-from", notification.getSendFrom());
        arbitraryDataMap.put("body-template", notification.getTemplate().getBody());
        arbitraryDataMap.put("locale", notification.getTemplate().getLocale());
        arbitraryDataMap.put("send-to", notification.getSendTo());
        arbitraryDataMap.put("body", notification.getBody());
        if (!NotificationChannels.SMS_CHANNEL.getChannelType().equals(notificationTemplate.getNotificationChannel())) {
            arbitraryDataMap.put("subject-template", notification.getTemplate().getSubject());
            arbitraryDataMap.put("footer-template", notification.getTemplate().getFooter());
            arbitraryDataMap.put("content-type", notification.getTemplate().getEmailContentType());
            arbitraryDataMap.put("subject", notification.getSubject());
            arbitraryDataMap.put("footer", notification.getFooter());
        }
    }

    private EmailTemplate buildEmailTemplate(NotificationTemplate notificationTemplate) {
        EmailTemplate emailTemplate = new EmailTemplate();
        emailTemplate.setTemplateDisplayName(notificationTemplate.getDisplayName());
        emailTemplate.setTemplateType(notificationTemplate.getType());
        emailTemplate.setLocale(notificationTemplate.getLocale());
        emailTemplate.setBody(notificationTemplate.getBody());
        if (NotificationChannels.EMAIL_CHANNEL.getChannelType().equals(notificationTemplate.getNotificationChannel())) {
            emailTemplate.setSubject(notificationTemplate.getSubject());
            emailTemplate.setFooter(notificationTemplate.getFooter());
            emailTemplate.setEmailContentType(notificationTemplate.getContentType());
        }
        return emailTemplate;
    }

    private Notification buildEmailNotification(EmailTemplate emailTemplate, Map<String, String> arbitraryDataMap, Map<String, String> userClaims, String sendTo, String sendFrom) {
        NotificationUtil.getPlaceholderValues(emailTemplate, arbitraryDataMap, userClaims);
        Notification.EmailNotificationBuilder builder = new Notification.EmailNotificationBuilder(sendTo);
        builder.setSendFrom(sendFrom);
        builder.setTemplate(emailTemplate);
        builder.setPlaceHolderData(arbitraryDataMap);
        return builder.build();
    }

    protected void publishToStream(Map<String, String> dataMap, Event event) throws IdentityEventException {
        EventStreamService service = NotificationHandlerDataHolder.getInstance().getEventStreamService();
        org.wso2.carbon.databridge.commons.Event databridgeEvent = new org.wso2.carbon.databridge.commons.Event();
        databridgeEvent.setTimeStamp(System.currentTimeMillis());
        try {
            databridgeEvent.setStreamId(this.getStreamDefinitionID(event));
        }
        catch (IdentityEventException e) {
            throw new IdentityEventException("Stream definition was not specified in the identity-event.properties file for " + event.getEventName());
        }
        databridgeEvent.setArbitraryDataMap(dataMap);
        service.publish(databridgeEvent);
    }

    private Map<String, String> getArbitraryDataClaimsFromProperties(Event event) throws IdentityEventException {
        HashMap<String, String> claimMap = new HashMap<String, String>();
        String tmpKeyStartWith = this.getName() + ".subscription." + event.getEventName() + ".claim";
        Properties subscriptionProperties = this.getSubscriptionProperties(event.getEventName());
        Set<Object> subscriptionPropertyKeys = subscriptionProperties.keySet();
        for (Object subscriptionPropertyKey : subscriptionPropertyKeys) {
            String key = (String)subscriptionPropertyKey;
            if (!key.startsWith(tmpKeyStartWith)) continue;
            String attribute = key.substring(tmpKeyStartWith.length() + 1);
            String value = (String)subscriptionProperties.get(key);
            claimMap.put(attribute, value);
        }
        return claimMap;
    }

    private Map<String, String> getArbitraryDataFromProperties(Event event) throws IdentityEventException {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        String streamIdKey = this.getName() + ".subscription." + event.getEventName() + "." + STREAM_DEFINITION_ID;
        String templateType = this.getName() + ".subscription." + event.getEventName() + "." + NOTIFICATION_TEMPLATE_TYPE;
        String claimKeyStartWith = this.getName() + ".subscription." + event.getEventName() + ".claim";
        Properties subscriptionProperties = this.getSubscriptionProperties(event.getEventName());
        Set<Object> subscriptionPropertyKeys = subscriptionProperties.keySet();
        for (Object subscriptionPropertyKey : subscriptionPropertyKeys) {
            String key = (String)subscriptionPropertyKey;
            if (key.startsWith(claimKeyStartWith) || key.equalsIgnoreCase(streamIdKey) || key.equalsIgnoreCase(templateType)) continue;
            String keyPrefix = this.getName() + ".subscription." + event.getEventName();
            String attribute = key.substring(keyPrefix.length() + 1);
            String value = (String)subscriptionProperties.get(key);
            dataMap.put(attribute, value);
        }
        return dataMap;
    }

    public String getName() {
        return "default.notification.sender";
    }

    protected String getStreamDefinitionID(Event event) throws IdentityEventException {
        String streamDefinitionID = this.getSubscriptionProperty(STREAM_DEFINITION_ID, event.getEventName());
        if (StringUtils.isEmpty((String)streamDefinitionID)) {
            streamDefinitionID = DEFAULT_STREAM_ID;
        }
        return streamDefinitionID;
    }

    protected String getNotificationTemplate(Event event) throws IdentityEventException {
        return this.getSubscriptionProperty(NOTIFICATION_TEMPLATE_TYPE, event.getEventName());
    }
}

