/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.wso2event.internal.ds;

import java.util.concurrent.ConcurrentHashMap;
import org.wso2.carbon.databridge.core.DataBridgeSubscriberService;
import org.wso2.carbon.event.input.adapter.wso2event.WSO2EventAdapter;

public final class WSO2EventAdapterServiceValueHolder {
    private static DataBridgeSubscriberService dataBridgeSubscriberService;
    private static ConcurrentHashMap<String, ConcurrentHashMap<String, ConcurrentHashMap<String, WSO2EventAdapter>>> inputEventAdapterListenerMap;

    private WSO2EventAdapterServiceValueHolder() {
    }

    public static void registerDataBridgeSubscriberService(DataBridgeSubscriberService dataBridgeSubscriberService) {
        WSO2EventAdapterServiceValueHolder.dataBridgeSubscriberService = dataBridgeSubscriberService;
    }

    public static DataBridgeSubscriberService getDataBridgeSubscriberService() {
        return dataBridgeSubscriberService;
    }

    public static synchronized void registerAdapterService(String tenantDomain, String streamId, WSO2EventAdapter wso2EventAdapter) {
        ConcurrentHashMap<String, WSO2EventAdapter> streamSpecificInputEventAdapterListenerMap;
        ConcurrentHashMap<String, ConcurrentHashMap<String, WSO2EventAdapter>> tenantSpecificInputEventAdapterListenerMap = inputEventAdapterListenerMap.get(tenantDomain);
        if (tenantSpecificInputEventAdapterListenerMap == null) {
            tenantSpecificInputEventAdapterListenerMap = new ConcurrentHashMap();
            inputEventAdapterListenerMap.put(tenantDomain, tenantSpecificInputEventAdapterListenerMap);
        }
        if ((streamSpecificInputEventAdapterListenerMap = tenantSpecificInputEventAdapterListenerMap.get(streamId)) == null) {
            streamSpecificInputEventAdapterListenerMap = new ConcurrentHashMap();
            tenantSpecificInputEventAdapterListenerMap.put(streamId, streamSpecificInputEventAdapterListenerMap);
        }
        streamSpecificInputEventAdapterListenerMap.put(wso2EventAdapter.getEventAdapterName(), wso2EventAdapter);
    }

    public static void unregisterAdapterService(String tenantDomain, String streamId, WSO2EventAdapter wso2EventAdapter) {
        ConcurrentHashMap<String, WSO2EventAdapter> streamSpecificInputEventAdapterListenerMap;
        ConcurrentHashMap<String, ConcurrentHashMap<String, WSO2EventAdapter>> tenantSpecificInputEventAdapterListenerMap = inputEventAdapterListenerMap.get(tenantDomain);
        if (tenantSpecificInputEventAdapterListenerMap != null && (streamSpecificInputEventAdapterListenerMap = tenantSpecificInputEventAdapterListenerMap.get(streamId)) != null) {
            streamSpecificInputEventAdapterListenerMap.remove(wso2EventAdapter.getEventAdapterName());
        }
    }

    public static ConcurrentHashMap<String, WSO2EventAdapter> getAdapterService(String tenantDomain, String streamId) {
        ConcurrentHashMap<String, ConcurrentHashMap<String, WSO2EventAdapter>> tenantSpecificInputEventAdapterListenerMap = inputEventAdapterListenerMap.get(tenantDomain);
        if (tenantSpecificInputEventAdapterListenerMap != null) {
            return tenantSpecificInputEventAdapterListenerMap.get(streamId);
        }
        return null;
    }

    static {
        inputEventAdapterListenerMap = new ConcurrentHashMap();
    }
}

